// ImgLib_Class.h : main header file for the TII_DLL_002 DLL
//
/*
 * Copyright (c) 2000-2001 Wenny Macura
 *
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL WENNY MACURA BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef IMAGE_LIB_CLASS_H
#define IMAGE_LIB_CLASS_H
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// In an application using this header file remove the comment bellow
//#define IMPORT_LIB
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#include    <stdio.h>
#include    <stdlib.h>
#include    <math.h>

#include    <Tii/CRect.h>
#include    <Tii/ImgClass.h>
#include    <Tii/String.h>
#include    <Tii/Utility.h>
#include    <Tii/HdrClass.h>
#include    <Tii/TIFFClass.h>
#include    <Tii/JPGClass.h>
#include    <Tii/BmpClass.h>
#include    <Tii/PpmClass.h>
#include    <Tii/PgmClass.h>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Library functions
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
char    ImgFile[256];            // = "";
char    ComName[256];
char    Host[32];                // = "plate_00";   // default client name
char    StreamNm[256];
double  coef[4][512];

class ImgLib_Class
{
    public:
        String Last_Error;
        HdrClass    m_Hdr;       // = NULL;
        bool    ThnJPG;          // =true;            // set thumbnails as JPEG
        bool    frst;

        //CTime StartTime;
        //CTime EndTime;
        //CTimeSpan ElapsedTime;

        char    HdrFile[256];    // = "";

        unsigned        Width;
        unsigned        Height;
        CRect   CropRct;

    #ifndef ZommIncr
    #define ZommIncr 2.0
    #endif

        Utility     m_Utility;
        TIFFClass   m_pTIFFClass;
        JPGClass    m_JPGClass;
        BmpClass    m_BmpClass;
        PpmClass    m_PpmClass;
        PgmClass    m_PgmClass;
        ImgLib_Class();
        ~ImgLib_Class();
        void    Init_ImageLib();
        void    Destroy_ImageLib();
        char    *Get_Version_String();
        int     Get_Version_Int();
        char    *Get_Copyright();
        //
        // just read the entire JPEG image into memory and fill in the IMG structure
        int Read_Data( IMG  *Imag );
        // just write the entire JPEG image out to a file
        int Write_Data( int Quality, IMG    *Out );

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //        static class Utility  *pUtility;
        // Function Definitions
        // It is recommended to look at the ImgClass.h, to get a bit of of info
        // about the Image and header structures used.

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	GetSingleColor(ImgClass *In,ImgClass *Out,int color)
        //	Get a single color from a RGB image in In and place it into Out
        //	Color =0 Red; 1= Green; 2 = Blue
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    GetSingleColor(ImgClass *In,ImgClass *Out,int color);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	Convert In from YCC to RGB profile, no sub sampling
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    YCCtoRGB(ImgClass *In);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	Convert In from RGB to YCC profile
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    RGBtoYCC(ImgClass *In);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	Obtain the last execution Library Error.
        //  Use PostError(""), after a call to  Get_Last_Error() to clear the Error stack.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        char    *Get_Last_Error();

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // OutFile is a name of the locally generated thnl, may be an empty string
        // If OutFile = "" then the header file will be written to the same path, where ImageFile resides.
        // The file name will be the same  as ImageFile but the extention will be changed to ".hdr"
        // It is recommended to keep the header file extention as ".hdr"
        // There may be any number of header files associated with the an Image.
        // The header file, has a deep historical attachment and should be removed
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Make_Local_Header(char *ImageFile,char *OutFile);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Quality	0  ~ for LZW compressed tiff thumbnail, 1 to 100 JPEG
        // usefull Quality range is from 10 to 90, where 10 will produce a small but low quality file
        // and 90 will produce a good quality but relatively large file.
        //
        // Size		Output image size in pixels, lines will be Size * Image_Aspect_Ratio
        // HdrFile	Image Header file name, use  Make_Local_Header(...) to generate it.
        // OutFile	Name of the resulting Thumbnail
        // This is a very slow and memory wastefull thumbnail generation ???
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Make_Local_Tnl(int Quality, int Size, char *HdrFile,char *Outfile);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // The newer thumbnail generation function.
        //
        // Use any of the write functions below to generate a thumbnail file.
        // !!! Don't forget to set the Out->ImgStruct.File to an appropriate file name !!!
        // before you use any of the Write...() functions.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Make_Local_Tnl(int Quality, int Size, ImgClass *In,ImgClass *Out);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Obtain the Image Aspect ratio from the header file.
        // just saves time parsing the file.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        double  Get_Aspect( char *HdrFile);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // obtains the Image width in pixels and image height in lines from the header file.
        // same parsing note as above.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Get_Image_Dimension( char *HdrFile,int *Width, int *Height);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Get the Res of an Image, if specified.
        // Xres and Yres are set to 0.0 if Res is not specified in the image file.
        // ResType is the same as in TIFF files.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Get_Image_Res( char *HdrFile,double *Xres, double *Yres, int *ResType);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	Read the entire Image into Memory, optionally swap the R and B channels
        //  The RGBSwap is to accommodate Microsoft's bitmaps
        //  Img->ImgStruct.File must represent a legal existing image file
        //  TIFF,JPEG,PGM,PPM,BMP
        //  If RGBSwap bit 4 is set XBitmap is stored in the ImgData
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    ReadImage( bool RGBSwap, ImgClass *Img );

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //	Read the entire Image into Memory, optionally swap the R and B channels
        //  ImgFile must be a valid image file name, and the file should exist;
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    ReadImage( bool RGBSwap,char *ImgFile, ImgClass *Img );

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Scale From to To by XScale and YScale
        // YScale may be set to -1.0 to preserve the Image Aspect ratio.
        // ScaleImage uses modified bi-cubic interpolation to interpolate From Image.
        // This function likes to eat up memory, assure that adequate swap space is set.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    ScaleImage(ImgClass *From, double XScale, double YScale,  ImgClass *To);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Resample In to Out  to OutX pixels x OutY lines
        // OutY may be set to -1 to preserve the Image Aspect ratio.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    SubsampleLocalImage(ImgClass *In, ImgClass *Out,int OutX,int OutY);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // write different images
        // Out->ImgStruct.File must be a legal image path/name
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // if compress = true the output image will be LZW compressed
        // if bgr is true the red and blue channels will be swapped before write
        bool    WriteTIFF(bool compress, bool bgr,ImgClass * Out);
        // for JPEG the quality is in the range from 1 to 100
        bool    WriteJPEG( int Quality, ImgClass *Out);
        bool    Write_8BitPPM( ImgClass *Out);
        bool    Write_8BitPGM( ImgClass *Out);
        bool    Write_BMP( ImgClass *Out);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Get a section of an image specified by Rect ( x,y,Width,Height )
        // File should be a legal image file name.
        // the crop rectangle image data is returned in Img;
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    GetImageRectangle(ImgClass *In, CRect *Rct, ImgClass *Out);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // convert an In to Out, Quality is optional for JPEGs
        // Legal Image types:
        //    TIFF_FILE 0
        //    JPEG_FILE 1
        //    PPM_FILE  2
        //    PGM_FILE  3
        //    BMP_FILE  4
        //    TII_FILE  5   DO NOT USE
        //    GIF_FILE  6   DO NOT USE, not implemented !!!
        // In and Out must be legal image field names,
        // Quality is used if Out_Type is set to JPEG_FILE, use 0 in other cases.
        // if the output image exists, it not written over, and true is returned.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Convert_Image( char *In, char *Out, int Out_Type, int Quality);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Read header info from an image
        // Fill in the IMAGE_HDR structure.
        // HdrFile should be existing header file.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Read_Hdr( char *HdrFile, IMAGE_HDR *hdr);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //rotation =	0 no action
        //				1	90	CW
        //			   -1	90	CCW
        //				2	180	CW
        //			   -2	180	CCW
        //				3	flip UPDOWN
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool    Rotate_Image( char *In, char *Out, int Type, int Rotation);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //  !!! +++ DO NOT USE +++ !!!
        //
        //  Calculate an crop rectangle, in image coordinates from an image described as 0,0,ImgWidth,ImgHeight
        //  the rectangle is centered around Pt
        //  First set to false
        //  Rhb not used set to false
        //  Pt point within the DispRct
        //  DispRct rectangle describing the display area
        //  Zoom zoom factor
        //
        //  !!! +++ DO NOT USE +++ !!!
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        CRect CalcCropRect(bool *Frst,bool Rhb,CPoint Pt, CRect DispRct, double Zoom, int ImgWidth, int ImgHeight);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // ZoomImageLocal returns a unique file name or an empty string on error
        //
        // Produce an OutImage, which is zoomed section of Image file.
        // The Dest image is scaled to fir to ImgW,ImgH rectangle
        // ImgW,ImgH width and height of the client display rectangle ( display coordinates)
        // Xpos, Ypos		center of the zoomed area, they should both be within the display rectangle
        // ???,???, ImgW,ImgH
        // Crop 			if not empty Xpos and Ypos are it is assumed that ImgW and ImgH represent
        //                  this Crop rectangle.
        //
        // Magnification 	Zoom factor, either total or incremental
        // 			if Crop if not empty, Magnification is incremental ( 1.5 to 2.0 seems fine)
        // Quality		 	not used
        // Src    		Source image
        // OutImage		Output image.
        //
        //
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        char  *ZoomImageLocal
            (
            int Xpos, int Ypos,
            int ImgW, int ImgH,
            CRect   *Crop,
            double Magnification,
            int Quality,
            ImgClass    *Src,
            ImgClass    *Dest
            );

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Slow version of the above (:-o)
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        char *ZoomImageLocal
            (
            int Xpos, int Ypos,
            int ImgW, int ImgH,
            CRect   *Crop,
            double Magnification,
            int Quality,
            char    *Src,
            ImgClass *OutImg
            );
        char  *ImgLib_Class::ZoomImageLocal
            (
            int         Xpos,       int         Ypos,
            int         DispW,      int         DispH,
            CRect       *Crop,
            double      Magnification,
            int         Quality,
            char        *Hdr_File,
            ImgClass    *Src,
            ImgClass    *Dest
            );

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Get the library crop rectangle.
        // Use this rectangle in ZoomImageLocal(...)
        // GetCropRect(..) should be called after each successfull call to ZoomImageLocal(...)
        bool    GetCropRect( CRect *Crp);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        //  !!! +++ DO NOT USE +++ !!!
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool GenerateLocalCmd(CRect *CropRct, int ImgW, int ImgH, int Qual);

        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Place the Str on the Error stack
        // if Str is empty, the error stack is cleared.
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        bool PostError ( char *Str );
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // Obtain the file name from a fully qualified path
        //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        char *Get_File_Name ( char *Str );
};
#endif                           //IMAGE_LIB_CLASS_H
