// ImgClass.h : header file
//

#ifndef IMGCLASS_H
#define IMGCLASS_H
#include "copyright.h"
#ifndef byte
typedef unsigned char byte;
#endif
#define RANGE(a,x,y) ( (a<x)?x:(a>y)?y:a )

/////////////////////////////////////////////////////////////////////////////
// ImgClass window

#include <Tii/WM_structures.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef     m100M
//	Largest chunk of memory allocated at once (HP9000)
#define     m100M (1024*1024*128)
#endif
#ifndef     m50M
//	Spare memory 10 megs ??
#define     m50M (1024*1024*10)
#endif
#define	SPLIT_IMAGE 1
/*
    The ImgClass, does not deal with LUTs,just direct data
    Shuould we include the LUTs and or profiles ??
 */

class ImgClass
{
    // Construction
    public:
		IMAGE_HDR_t   ImHdr;		// the header structure
		IMG_t ImgStruct;			// the image structure
		ImgClass();
		virtual ~ImgClass();
		bool	ImgClass::SetMapOneToOne();
		void    DelImgData();		// delete the iamge buffers
		bool    SetImgData();		// returns true on ERROR, ImgStruct.ImgData is NULL on ERROR
		byte    *GetLinePtr( int Line );	//obtain a pointer to an Image line
		int     LongAllign( const int size );	//allign size to 32 bits
		bool	ImgClass::IsLut1to1();
		int		AddImage(ImgClass *Img);	// add an Image to the stack
		//		Image creation time/ access time
 		unsigned long   AccTime;
		long int    TimeStamp;
		
		// R,G,B gamma values
		double      Gamma[3];
		// Next Image is used for splitting a large image into smaller sections
		// or as a simple next image in an iamge sequence.
		ImgClass    *NextImage;  
		ImgClass    *Parent;     
		int		ThisImageLines;		// no of lines in this image
									// may be different fro ImgStuct.lines
		//	Set to non-zero if
		//	The Image data is beeing written into by a user
		// or the image is beeing ted into.
		// RULE:	while Access is set do not delete the image,
		int     Access;
		int     NoCliks;
		
		// no of bytes allocated for the Image data
		// including all subimages, Main image contains the entire image
		// NextImage will contain teh Image data size - m100M;( se above m100M )
		size_t  Allocated;		
		
		//if nonzero, split the image into multiple sections 
		int     SplitImage;
		int	*RMap;
		int *GMap;
		int *BMap;
};
#endif                           // IMGCLASS_H
