// ImageLib.h : main header file for the ImageLib
#ifndef IMAGE_LIB_H
#define IMAGE_LIB_H
//
//!!!!!!!!!!!!!!!!!!!!!!!!!
// NOTE:
// This library was mainly designed with large images ( 4GB )
// in mind the image loading and manipulation is ruther quick,
// especially for large images.
//!!!!!!!!!!!!!!!!!!!!!!!!!
#include "copyright.h"

#define LIBFUN extern

#ifndef NO_COEF
#define NO_COEF 1024
#endif
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// function pointer definition
#define PMETHOD(type,methodname,arglist)  type (*methodname) arglist
// fit a in between x and y inclusive

#include    <stdio.h>
#include    <stdlib.h>
#include    <math.h>

//#include    <Tii/Includes.h>
#include	<Tii/Utility.h>
#include    <Tii/ImgClass.h>
#include    <Tii/CRect.h>
#include    <Tii/WString.h>
// may be we should define these ImageLib.h

extern  int     ReadBusy;        // defined for ImgLib nonzero if image is read
extern  char    INCDIR_BASE[];   // used by the lib
extern  char    INCDIR[];        // used by the lib
extern  char    CMD_DIR[][STRING__MAX];       // just to keep the lib happy

extern	Utility *pUtility;
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Library functions
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//
// just read the entire JPEG image into memory and fill in the IMG structure
//LIBFUN  int Read_Data( IMG  *Imag );
// just write the entire JPEG image out to a file
//LIBFUN  int Write_Data( int Quality, IMG    *Out );

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * initiate and destroy the library
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
LIBFUN        void Init_ImageLib();
LIBFUN        void Destroy_ImageLib();

/*
 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +        static class Utility  *pUtility;
 +	Function Definitions
 +	It is recommended to look at the ImgClass.h, to get a bit of of info
 +	about the Image and header structures used.
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Get various Library Version info
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        char *Get_Version_String();
LIBFUN        int   Get_Version_Int();
LIBFUN        char *Get_Copyright();

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	GetSingleColor(ImgClass *In,ImgClass *Out,int color)
//	Get a single color from a RGB image in In and place it into Out
//	Color =0 Red; 1= Green; 2 = Blue
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    GetSingleColor(ImgClass *In,ImgClass *Out,int color);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Convert In from YCC to RGB profile, no sub-sampling
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    YCCtoRGB(ImgClass *In);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Convert In from RGB to YCC profile
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    RGBtoYCC(ImgClass *In);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Obtain the last execution Library Error.
//  Use PostError("")
//	after this call to  Get_Last_Error() to clear the Error stack.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        char    *Get_Last_Error();

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *	OutFile is a name of the locally generated header.
 *	May be an empty string
 *	NOTE:
 *	If OutFile = ""
 *	then the header file will be written to the same path,
 *	where ImageFile resides.
 *	The file name will be the same  as ImageFile
 *	but the extention will be changed to ".hdr"
 *
 *	It is recommended to keep the header file extention as ".hdr"
 *
 *	There may be any number of header files associated with the an Image.
 *
 *	The header file, has a deep historical attachment and should be removed
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
LIBFUN        bool    Make_Local_Header(char *ImageFile,char *OutFile);

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 *
 *	Obtain the header info and place fill in the IMAGE_HDR structure
 *
 *++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
LIBFUN        bool    Make_Header(char *ImageFile,IMAGE_HDR_t *p_mHdr);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Quality:
//		0  ~ for LZW compressed tiff thumbnail,
//		1 to 100 for JPEG
//		usefull Quality range is from 10 to 90, where 10 will produce a small but low quality file
//		and 90 will produce a good quality but relatively large file.
//
//	Size:
//		Output image size in pixels, lines will be Size * Image_Aspect_Ratio
//	HdrFile	:
//		Image Header file name, use  Make_Local_Header(...) to generate it.
//	OutFile	Name:
//		The file name of the resulting Thumbnail
//
// This is a very slow and memory wastefull thumbnail generation ???
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN	bool    Make_Local_Tnl(int Quality, int Size, char *HdrFile,char *Outfile, double Gamma);
//LIBFUN        bool    Make_Local_Tnl(int Quality, int Size, char *HdrFile,char *Outfile);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// The newer thumbnail generation function.
//
// Use any of the write functions below to generate a thumbnail file.
// !!! Don't forget to set the Out->ImgStruct.File to an appropriate file name !!!
// before you use any of the Write...() functions.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Make_Local_Tnl_Img(int Quality, int Size, ImgClass *In,ImgClass *Out,double Gamma);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Obtain the Image Aspect ratio from the header file.
// The aspect is Width/Height
// just saves time parsing the file.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        double  Get_Aspect( char *HdrFile);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// obtains the Image width in pixels and image height in lines from the header file.
// same parsing note as above.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Get_Image_Dimension( char *HdrFile,int *Width, int *Height);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Get the Res of an Image, if specified.
// Xres and Yres are set to 0.0 if Res is not specified in the image file.
// ResType is the same as in TIFF files.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Get_Image_Res( char *HdrFile,double *Xres, double *Yres, int *ResType);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Read the entire Image into Memory, optionally swap the R and B channels
//  RGBSwap:
//		The RGBSwapis to accommodate Microsoft's bitmaps
//  Img:
//		Img->ImgStruct.File must represent a legal existing image file
//		TIFF,JPEG,PGM,PPM,BMP...
//		If RGBSwap bit 4 is set XBitmap is stored in the ImgData
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    ReadImage( bool RGBSwap, ImgClass *Img );

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Read the entire Image into Memory, optionally swap the R and B channels
//  ImgFile must be a valid image file name, and the file should exist;
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN         bool    ReadImage1( bool RGBSwap,char *ImgFile, ImgClass *Img );

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Scale From to To by XScale and YScale
// YScale may be set to -1.0 to preserve the Image Aspect ratio.
// ScaleImage uses modified bi-cubic interpolation to interpolate the From Image.
// This function likes to eat up memory, assure that adequate swap space is set,
// if your memory is limited.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    ScaleImage(ImgClass *From, double XScale, double YScale,  ImgClass *To);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Resample In to Out  to OutX pixels x OutY lines
// OutY may be set to -1 to preserve the Image Aspect ratio.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    SubsampleLocalImage(ImgClass *In, ImgClass *Out,int OutX,int OutY);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// write different images
// Out->ImgStruct.File must be a legal image path/name
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// if compress = true the output image will be LZW compressed
// if bgr is true the red and blue channels will be swapped before write
LIBFUN        bool    WriteTIFF(bool compress, bool bgr,ImgClass * Out);
// for JPEG the quality is in the range from 1 to 100
LIBFUN        bool    WriteJPEG( int Quality, ImgClass *Out);
LIBFUN        bool    Write_8BitPPM( ImgClass *Out);
LIBFUN        bool    Write_8BitPGM( ImgClass *Out);
LIBFUN        bool    Write_BMP( ImgClass *Out);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Get a section of an image specified by Rect ( x,y,Width,Height )
// the crop rectangle image data is returned in Out;
// Out can't be In
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    GetImageRectangle(ImgClass *In, CRect *Rct, ImgClass *Out);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// convert In to Out and write Out, Quality is optional for JPEGs
// Legal Image types:
//    TIFF_FILE 0
//    JPEG_FILE 1
//    PPM_FILE  2
//    PGM_FILE  3
//    BMP_FILE  4
//    TII_FILE  5   DO NOT USE
//    GIF_FILE  6   DO NOT USE, not implemented !!!
// In and Out must be legal image field names,
// Quality is used if Out_Type is set to JPEG_FILE, use 0 in other cases.
// if the output image exists, it will not be written over, and true is returned.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Convert_Image( char *In, char *Out, int Out_Type, int Quality);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Read Image header info
// Fill in the IMAGE_HDR structure.
// HdrFile should be a legal and existing header file.
//	see Make_Header() above.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Read_Hdr( char *HdrFile, IMAGE_HDR_t *hdr);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	Various Image rotations
//rotation =	0 no action
//				1	90	CW
//			   -1	90	CCW
//				2	180	CW
//			   -2	180	CCW
//				3	flip UPDOWN
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool    Rotate_Image( char *In, char *Out, int Type, int Rotation);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//  !!! +++ DO NOT USE +++ !!!
//
//  Calculate an crop rectangle, in image coordinates from an image described as 0,0,ImgWidth,ImgHeight
//  the rectangle is centered around Pt
//  First set to false
//  Rhb not used set to false
//  Pt point within the DispRct
//  DispRct rectangle describing the display area
//  Zoom zoom factor
//
//  !!! +++ DO NOT USE +++ !!!
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        CRect CalcCropRect(bool *Frst,bool Rhb,CPoint Pt, CRect DispRct, double Zoom, int ImgWidth, int ImgHeight);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ZoomImageLocal returns a unique file name or an empty string on error
//
// Produce an OutImage, which is zoomed section of Image file.
// The Dest image is scaled to fit to ImgW,ImgH rectangle
// ImgW,ImgH:
//		width and height of the client display rectangle ( display coordinates)
//	Xpos, Ypos:	(display coordinate space )
//		center of the zoomed area,
//		they should both be within the display rectangle
//		???,???, ImgW,ImgH
//	Crop: ( image coordinate space )
//		if not empty Xpos and Ypos are assumed to be within this Crop in display
//		coordinates, Xpos and Ypos are assumed to be within this Crop
//
// Magnification:
//		Zoom factor, either total or incremental
//		if Crop if not empty, Magnification may be kept incremental ( 1.5 to 2.0 seems fine)
//	Quality	:
//	 	not used
//	Src:
//		Source image
// OutImage:
//		Destination image.
//
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        char  *ZoomImageLocal
(
	int Xpos, 	int Ypos,
	int ImgW, 	int ImgH,
	CRect   	*Crop,
	double 		Magnification,
	int 		Quality,
	ImgClass	*Src,
	ImgClass	*Dest
);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Slow version of the above (:-o)
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        char *ZoomImageLocal
(
	int Xpos,
	int Ypos,
	int ImgW,
	int ImgH,
	CRect		*Crop,
	double		Magnification,
	int			Quality,
	//			The source image file or an Image header file
	char		*Src,
	ImgClass *OutImg                 // output Image
);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Get the library crop rectangle.
// Use this rectangle in ZoomImageLocal(...)
// GetCropRect(..) should be called after each successfull call to ZoomImageLocal(...)
LIBFUN  bool    GetCropRect( CRect *Crp);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//  !!! +++ DO NOT USE +++ !!!
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool GenerateLocalCmd(CRect *CropRct, int ImgW, int ImgH, int Qual);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Place the Str on the Error stack
// if Str is empty, the error stack is cleared.
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN        bool PostError ( char *Str );
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Obtain the file name from a fully qualified path
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
LIBFUN      char	*Get_File_Name ( char *Str );

// create a fully qualified name in the tmp directory
// Extention is optional, may be ""
LIBFUN      char	*Make_Temp_FileName(char *FileName, char *Extention);

// set the Image Access flag
LIBFUN      void    SetAccess(ImgClass *Img);
// clear the Image Access flag
LIBFUN      void    ClearAccess(ImgClass *Img);
LIBFUN		bool	SlowScaleImage(bool Compress,char *From, char *To, double XSc, double YSc,double Res);
typedef struct
{
    PMETHOD(CRect,      CalcCropRect,(bool *,bool,CPoint, CRect, double, int, int));
    PMETHOD(void,       ClearAccess,(ImgClass *));
    PMETHOD(bool,       Convert_Image,( char *, char *, int , int ));

    PMETHOD(void,       Destroy_ImageLib,());

    PMETHOD(bool,       GenerateLocalCmd,(CRect *,int,int,int));
    PMETHOD(bool,       GetCropRect,( CRect *));
    PMETHOD(bool,       GetImageRectangle,(ImgClass *, CRect *, ImgClass *));
    PMETHOD(char *,     Get_File_Name, ( char * ));
    PMETHOD(char*,      Get_Copyright,());
    PMETHOD(double,     Get_Aspect,( char *));
    PMETHOD(bool,       Get_Image_Dimension,( char *,int *, int *));
    PMETHOD(bool,       Get_Image_Res,( char *,double *, double *, int *));
    PMETHOD(char*,      Get_Last_Error,());
    PMETHOD(bool,       GetSingleColor,(ImgClass *,ImgClass *,int ));
    PMETHOD(int,        Get_Version_Int,());
    PMETHOD(char*,      Get_Version_String,());

    PMETHOD(void,       Init_ImageLib,());

    PMETHOD(bool,       Make_Header,(char *,IMAGE_HDR_t *));
    PMETHOD(bool,       Make_Local_Header,(char *,char *));
    PMETHOD(bool,       Make_Local_Tnl,(int, int, char *,char *,double));
    PMETHOD(bool,       Make_Local_Tnl_Img,(int, int, ImgClass *,ImgClass *,double));
    PMETHOD(char *,     Make_Temp_FileName,(char *, char *));

    PMETHOD(bool,       PostError,( char * ));

    //PMETHOD(int,		Read_Data,( IMG  *));
    PMETHOD(bool,       Read_Hdr,(char*,IMAGE_HDR_t *));
    PMETHOD(bool,       ReadImage,( bool, ImgClass *));
    PMETHOD(bool,       ReadImage1,( bool,char *, ImgClass *));
    PMETHOD(bool,       RGBtoYCC,(ImgClass *));
    PMETHOD(bool,       Rotate_Image,( char *, char *, int,int));

    PMETHOD(bool,       ScaleImage,(ImgClass *, double, double,ImgClass *));
    PMETHOD(void,       SetAccess,(ImgClass *));
    PMETHOD(bool,       SubsampleLocalImage,(ImgClass *, ImgClass *,int,int));

    PMETHOD(bool,       Write_8BitPGM,( ImgClass *));
    PMETHOD(bool,       Write_8BitPPM,( ImgClass *));
    PMETHOD(bool,       Write_BMP,( ImgClass *));
    //PMETHOD(int,		Write_Data,( int, IMG*) );
    PMETHOD(bool,       WriteJPEG,( int, ImgClass *));
    PMETHOD(bool,       WriteTIFF,(bool, bool,ImgClass *));

	PMETHOD(void,		Write_Progress,(int,int));
	PMETHOD(void,		Read_Progress,(int,int));
    PMETHOD(bool,       YCCtoRGB,(ImgClass *));

    PMETHOD(char *,     ZoomImageLocal,(int,int,int,int,CRect*,double,int,char*,ImgClass *));
}   s_LibMethods;

LIBFUN  s_LibMethods    LibMethods;
#endif                           //IMAGE_LIB_H
