#ifndef HDRCLASS_H
#define HDRCLASS_H
/***************************************************************************
                          HdrClass.h
                             -------------------
	begin                : Sat May 25 06:57:50 PDT 2002
	copyright            : (C) 2001-2003 by Wenny Macura
	email                : wmacu@telus.net

	The HdrClass processes image formats header info.
	Optionally it may produce a predefined Headre files

	The *.hdr files were introduced, for the remote processing.
	The *.hdr files contain the vital image info, for images
	stored on the Server.
	
	The headers could be eliminated in local operations.
	
	
 /////////////////////////////////////////////////////////////////////////////
 */
#include "copyright.h"

//	All Proc...operations will fill in the local ImageHeader [ ImHdr ]
//	Use Get_Hdr_Info() to extract the ImHdr pointer and or data

#include <Tii/WM_structures.h>
#include    <Tii/ImgClass.h>

class HdrClass
{
    // Construction
    public:
        //	the definition of the image headre structure see "Tii/WM_structures.h"
        IMAGE_HDR_t   ImHdr;
        HdrClass();
        virtual ~HdrClass();
    public:
        //	added June 04, just to keep it all toghether [wm];
        int     GetImageType(char *FileName);
        //	added June 04 wm;
        bool ProcImgHdr(ImgClass *Img);
        bool ProcHdrTARGA(char *ImageFile);
        bool ProcHdrBMP(char *ImageFile);
        bool ProcHdrPGM( char *ImageFile);
        bool ProcHdrPPM( char *ImageFile);
        bool ProcHdr( char *ImageFile);
        bool ProcHdrTiff(char * ImageFile);
        bool ProcHdrJpg(char * ImageFile );
        // DO NOT USE !!
        bool ProcHdrTII ( char *InputFile );
        // read a Header file and place result into HdrClass::ImHdr
        bool ReadHeader(char *HdrFile);
        // read a Header file and place result into Hdr
        bool ReadHeader(char *HdrFile, IMAGE_HDR_t *Hdr);
        // write the HdrClass::ImHdr structure
        bool WriteHeader( char *OutHdrFile);
        // write the Hdr structure
        bool WriteHeader( char *OutHdrFile, IMAGE_HDR_t *Hdr);
        //returns a pointer to this->ImHdr
        IMAGE_HDR_t *Get_Hdr_Info();
};
#endif                           // HDRCLASS_H
