//GlobDefine.h
#ifndef GLOBDEFINE_H
#define GLOBDEFINE_H

#include    "CRect.h"

#define STRING__MAX 512


#define FILL    0xFF

#define QLOW    0xAF             //Quality constants
#define QMED    0xBF
#define QHIGH   0xCF
#define QBEST   0xDF
#define QFULL   0xEF

#define NO_SERVERS  4            // default no of servers running concurently
#define RCT_NO      512          // No of sub-rectangles
#define NO_CROPS    128          // No of different Crops

#define NO_SQRCT 128             // max no of rectangles making up the bitmap
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	!!!!!---	All directories should contain the '/' at the end	---!!!!!
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#define COMMAND_DIR "/export/home/incoming/Commands/"
//#define ACCNT_DIR   "/export/home/incoming/Account/"

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	!!!!!---	File definitions	---!!!!!
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#define COMMAND_LOG "/export/home/incoming/log/Command.log"
#define RANGE(a,x,y) ( (a<x)?x:(a>y)?y:a )
#define PMETHOD(type,methodname,arglist)  type (*methodname) arglist

#define NO_IMAGES  4096	 // NO_IMAGES should be defined in GlobDefine.h (4096 )
#define NOUSERS	64

//#define ERR_LOG     "/log/Error.log"
#define LIST_LOG    "/log/List.log"
#define QLOG        "/log/Server.log"
#define QLOG1       "/log/Server_1.log"
#define QLOG2       "/log/Server_2.log"

#define DELAYS  1                //Delay in sec
#define DELAYUS 1000000           //Delay in micro secunds

#define NO_WORDS    32           // no of different words in a string, for parsing the string
//#define NO_IMAGES   1024         // max no of images processed by the servers at a time
#define LOG_SIZE    50000        //define the log size to 50k

#define WORD_LNGTH 128
#define REM_TIME 180             // delete file every 180 sec (3 min )
#define NOPAR       64           //No of stream parameters

//typedef	unsigned char	byte;
//#define RANGE(a,b,c) (a < b)?b:( (a > c)?c: a )
//#define NO_COEF 1024

// the parameters have the form
// Name value,value,.....
typedef struct
{
    char ParName[32];            // name of the parameter
    int IntPar[16];              // up to 16 integer values of a parameter
    char TxtPar[256];            // textual representation of the parameter set
}   PARAMETER;

// used for reconstructing the local image, from previous access
//
typedef struct                   //overlapped rect list structure
{
    CRect   *Rct;                // the actual rectangle
    int     Value[8];            //Values to rebuild a bitmap
    void    *Next;               // next in a linked list
    void    *Prev;               // previous in a linked list
    bool    New;
}   RLIST;
#endif
