// GIFFClass.h: interface for the GIFFClass class.
//
//////////////////////////////////////////////////////////////////////
/*
 * GIF_Class  -  GIF loading code.  Based strongly on xv
 *
 *  Author:    John Bradley, University of Pennsylvania
 *
 * gif2ras.c - Converts from a Compuserve GIF (tm) image to a Sun Raster image.
 *
 * Copyright (c) 1988, 1989 by Patrick J. Naughton
 *
 * Author: Patrick J. Naughton
 * naughton@wind.sun.com
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 */
#include "copyright.h"
#include <stdio.h>
#include <Tii/Includes.h>

#ifndef GIFFCLASS_H
#define GIFFCLASS_H

#define NEXTBYTE (*dataptr++)
#define EXTENSION     0x21
#define IMAGESEP      0x2c
#define TRAILER       0x3b
#define INTERLACEMASK 0x40
#define COLORMAPMASK  0x80
#define CONV24_8BIT  0
#define PIC8  CONV24_8BIT
#define F_GIF         0
#define F_FULLCOLOR 0

typedef unsigned char   byte;

/* info structure filled in by the LoadXXX() image reading routines */
typedef struct
{
    byte *pic;                   /* image data */
    int   w, h;                  /* pic size */
    int   type;                  /* PIC8 or PIC24 */

    byte  r[256],g[256],b[256];
                                 /* colormap, if PIC8 */

    int   normw, normh;
    /* 'normal size' of image file
                                (normally eq. w,h, except when
                            doing 'quick' load for icons */

    int   frmType;               /* def. Format type to save in */
    int   colType;               /* def. Color type to save in */
    char  fullInfo[256];         /* Format: field in info box */
    char  shrtInfo[256];         /* short format info */
    char *comment;               /* comment text */

    int   numpages;              /* # of page files, if >1 */
    char  pagebname[64];         /* basename of page files */
} PICINFO;

class GIFFClass
{
    public:
        bool LoadGIF(char *fname, PICINFO *pinfo);
        void InitClass();
        int   gif89;
        int Prefix[4096];
        int Suffix[4096];
        int OutCode[4097];
        void doInterlace(int Index);
        int readCode();
        PICINFO pinfo;
        char *bname;
        int   filesize;

        byte *RawGIF;            /* The heap array to hold it, raw */
        byte *Raster;            /* The raster data stream, unblocked */
        byte *pic8;
        bool Interlace, HasColormap;

        int BitOffset;           /* Bit Offset of next code */
        int XC, YC;              /* Output X and Y coords of current pixel */
        int Pass;                /* Used by output routine if interlaced pic */
        int OutCount;            /* Decompressor output 'stack count' */
        int RWidth, RHeight;     /* screen dimensions */
        int Width, Height;       /* image dimensions */
        int LeftOfs, TopOfs;     /* image offset */
        int BitsPerPixel;        /* Bits per pixel, read from GIF header */
        int BytesPerScanline;    /* bytes per scanline in output raster */
        int ColorMapSize;        /* number of colors */
        int Background;          /* background color */
        int CodeSize;            /* Code size, read from GIF header */
        int InitCodeSize;        /* Starting code size, used during Clear */
        int Code;                /* Value returned by ReadCode */
        int MaxCode;             /* limiting value for current code size */
        int ClearCode;           /* GIF clear code */
        int EOFCode;             /* GIF end-of-information code */
                                 /* Decompressor variables */
        int CurCode, OldCode, InCode;
        int FirstFree;           /* First free code, generated per GIF spec */
        int FreeCode;            /* Decompressor,next free slot in hash table */
        int FinChar;             /* Decompressor variable */
        int BitMask;             /* AND mask for data size */
        int ReadMask;            /* Code AND mask for current code size */
        int Misc;                /* miscellaneous bits (interlace, local cmap)*/
        byte *dataptr;
        bool readImage(PICINFO *pinfo);
        //	int	r[256];
        //	int	g[256];
        //	int	b[256];
        double  normaspect;
        int numcols;
        FILE *fp;
        bool GIF_ReadImage ( ImgClass *Img );
        bool GIF_GetHeader ( char *ImgName, IMAGE_HDR_t *mHdr);
        GIFFClass();
        virtual ~GIFFClass();

};
#endif                           // GIFFCLASS_H
