//CRect.h
// Definition of CRect abd CPoint	simmillar to MSoft	Wm
// Just to ease VCC conversions.
#ifndef     CRECT_H
#define     CRECT_H
/***************************************************************************
						CRect.h  -  description
							-------------------
	begin                : Sat May 25 06:57:50 PDT 2002
	copyright            : (C) 2004 by Wenny Macura
	email                : wmacu@telus.net
***************************************************************************
/////////////////////////////////////////////////////////////////////
*
*	CRect	is defined by the top left corner (origin), width and height
*
*	NOTE:	Width an Height compare with Width() Height() of VCC
*			No bottom and right
*	CPoint	has no operations defined at this time
*
//////////////////////////////////////////////////////////////////////
*/
#include "copyright.h"

#define bottom ( this->Top + this->Height)
#define right  ( this->Left + this->Width)

class   CPoint
{
	public:
		CPoint();
		CPoint( int X,int Y);
		int x;
		int y;
};

class   CRect
{
	public:

		CRect();
		CRect( CPoint TopLeft, CPoint BottomRight );
		CRect(int left,int top, int width, int height);
		~CRect();
		// Rect.Copy( CRect *Dest ) will copy Rect to destination
		void Copy( CRect *Dst);
		// will set the rect to Left=x,Top = y, Width = w, Height=h
		// Rcet.SetRect(0,0,100,100)
		void SetRect(const CPoint *Origin, const int w, const int h );
		void SetRect(const int x, const int y, const int w, const int h );
		// Sets the rect to 0s
		void SetRectEmpty();
		// returns true if either Width or Height = 0
		bool IsRectEmpty();
		// returns true if Point is within the Rectangle ( boubdries included )
		bool PointInRect( const CPoint Point );
		bool PointInRect( const CPoint *Point );
		// point is set to the center point of the rectangle
		CPoint CenterPoint();
		// make sure the Top and Left are on the Top Left
		// and Width and Height are > 0
		void    normalize();
		//	int		Width() { return Width;}		//same as microsoft
		//	int		Height() { return Height;}

		CRect& operator=(const CRect Rect);
		CRect& operator=(const CRect *Rect);

		bool operator==(const CRect Rect);
		bool operator==(const CRect *Rect);

		int Left;
		int Top;
		int Width;
		int Height;
};
#endif                           //CRECT_H
