//FILE:		$RCSfile: Options.h,v $
//Revision:	$Revision: 1.2 $

#include "copyright.h"
#ifndef OPTIONS_H
#define OPTIONS_H

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <sys/types.h>
#include	<getopt.h>
#include	<Tii/HdrClass.h>
#include    <Tii/ImageLib.h>
#include    <Tii/WString.h>
#define NO_OPTIONS  32
//#define NO_OPTION_FILES 4096	// no of files, using wildcards
extern   WString  Files[];

static	char	OptString[64] =    "i:o:s:q:d:e:r:g:tkcavh?";

//generates a stack of strings by using the AddStr( char *)
class Str_Stack
{
public:
	WString	*Stack_Str;
	Str_Stack *Next;
	Str_Stack() {
		Stack_Str = NULL;
		Next =NULL;
	}
	~Str_Stack() {
		if (Stack_Str) {
			delete Stack_Str;
			Stack_Str = NULL;
		}
		if (Next) { delete Next;}
	}
	void AddStr ( char *mStr)
	{
		if (Stack_Str)
			delete Stack_Str;
		Stack_Str = new WString(mStr);
		Next = new Str_Stack;
	}
};

static struct option long_options[] = {
		{"input", 1, 0, 'i'},
		{"output", 1, 0, 'o'},
		{"size", 1, 0, 's'},
		{"quality", 1, 0, 'q'},
		{"debug", 1, 0, 'd'},
		{"extention", 1, 0, 'e'},
		{"res",1,0,'r'},
		{"gamma",1,0,'g'},
		{"thumbnail", 0, 0, 't'},
		{"keephdr", 0, 0, 'k'},
		{"compress", 0, 0, 'c'},
		{"fit_to_square", 0, 0, 'a'},
		{"version", 0, 0, 'v'},
		{"help", 0, 0, 'h'},
		{"help", 0, 0, '?'},
		{0, 0, 0, 0}
};

class Options
{
    public:
    	Str_Stack	FileStack;		//stack of imag file names
		HdrClass	*pmHdr;			//defined in ImgLib
		int	digit_option;
        Options();
        ~Options();
        char *NextOption;
        char Arg[NO_OPTIONS][64];	//the option arguments
        char *Get_Opt_Arg(char *Option);
        int  Get_Opt_Index(char *Option);
        bool Fill_Opt_Arguments( int argc, char **argv );
        void usage ();
};

#endif                           //	OPTIONS_H
