//FILE:		$RCSfile: Options.cc,v $
//Revision:	$Revision: 1.3 $
#include "copyright.h"

//	Input option processing methods.
//#define		DEBUG_OPTIONS

#include    <dirent.h>
#include    <sys/stat.h>
#include    "Options.h"
#include    <Tii/ImageLib.h>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// NOTE:
// New version using getopt, This was an old, old  hack, written for MDA 20 years ago, and made into a class ?:-(
// WString was added just to try the class, no other reasonn.
// the debug level is compile option only
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Options::Options(void)
{
	int jj;
	#ifdef  DEBUG_OPTIONS
	printf("0022    Options::Options()	ENTRY\n");
	#endif

	int	digit_option = 0;
	pmHdr = new HdrClass;
// Clear the Argumnets
	for ( jj =0; jj < NO_OPTIONS; jj++)	{ *Arg[jj] = 0;}
	// empty the file list.
	// We should actually use dynamically allocated stack to implement this.
//	for ( jj =0; jj < NO_OPTION_FILES; jj++) { Files[jj] = "";}
	#ifdef  DEBUG_OPTIONS
	printf("0033    Options::Options()	EXIT\n");
	#endif

}
Options::~Options(void)
{	
	#ifdef  DEBUG_OPTIONS
	printf("0040	Options::~Options()	ENTRY\n");
	#endif
	#ifdef  DEBUG_OPTIONS
	printf("0043	Options::~Options()	EXIT\n");
	#endif
}

/*---------------------------------------------------
Arguments:
One of the strings specified in Opt;
see Options.h

Returned Values:
The Option's text argument or NULL.
NULL is returned for invalid option;
---------------------------------------------------*/
char *Options::Get_Opt_Arg( char *Option )
{
	int j;

	if ( Option == NULL)
		return NULL;
	if ( *Option == 0)
		return NULL;

	#ifdef  DEBUG_OPTIONS
	printf("0066	Options::Get_Opt_Arg(%s)	ENTRY\n",Option);
	#endif
	j = Get_Opt_Index(Option);
	if (j < 0 )
		return NULL;
	return Arg[j];
}


/*---------------------------------------------------
Arguments:
One of the strings specified in Opt;
see Options.h

Returned Values:
The Option's index	or -1.
-1 is returned for invalid option;

---------------------------------------------------*/
int Options::Get_Opt_Index( char *Option) {

	#ifdef  DEBUG_OPTIONS
	printf("0089	Options::Get_Opt_Index(%s)	ENTRY\n",Option);
	#endif
	int j;
//    static  char    *Ptr;
	char    *OptPtr;
	int 	i_Opt;

	OptPtr = Option;
	if ( *OptPtr == '-' ) { OptPtr++; }
	i_Opt = *OptPtr;
	// scan the options
	for(j=0; j < NO_OPTIONS; j++) {
		if ( long_options[j].val == 0 )
			break;
		if ( long_options[j].val == i_Opt ) {
			return(j);           // yip, got the right one
		}
	}
	#ifdef  DEBUG_OPTIONS
	printf("0108	Options::Get_Opt_Index(%s)	EXIT\n",Option);
	#endif
	return(-1);                  // no such option
}


/*---------------------------------------------------
This entire class should be either rewritten using getopt or eliminated
just grabbed it from an old, old program [wm].

	There might be a problem if -i is the last option specified.

Arguments:
	Standardt program arguments

Returned Values:
	false	on OK
	true	on	Error  and usage() is caled

	Done now using using getopt :-)
---------------------------------------------------*/
bool    Options::Fill_Opt_Arguments( int    argc, char **argv )
{
	int mindex;
	int jj = 0;
	int type;
	int nn = 0;
	struct  stat    Fstat;
	char *out;
	char	OutPath[1024];

	type = -1;
	Str_Stack *mStack = &FileStack;		// create a stack pointer
#ifdef  DEBUG_OPTIONS
	for (jj =0; jj < argc; jj++ )
		printf(" argv[%d] = %s\n",jj,argv[jj]);
#endif
	
	while (1)
	{
		int this_option_optind = optind ? optind : 1;
		int option_index = 0;
		jj = getopt_long (argc, argv, OptString,long_options, &option_index);
#ifdef  DEBUG_OPTIONS
		printf("159  Options::Fill_Opt_Arguments jj = %d ~\"%c\"  argc = %d optarg %s %d\n",jj,jj,argc,optarg,optind);
#endif
		if ( jj < 0 ) {
			break;
		}
		switch ( jj )
		{
			case 0:
			{
				printf("168 Fill_Opt_Arguments ()Long option %s \n",long_options[option_index].name);
			}
			break;
			case 'i':
			{
				if ( *optarg) {
					int mIndex = Get_Opt_Index( "-i");
					if ( ( type = pmHdr->GetImageType(optarg)) >= 0 ) {
						mStack->AddStr(optarg);
						mStack = mStack->Next;
					}
				}
				else {
					usage();
				}					
			}
			break;
			case 'o':
			{
				mindex = Get_Opt_Index("-o");
				if ( *optarg) {
					strcpy(Arg[mindex],optarg);
					*OutPath =  0;
					strcpy( OutPath, optarg);
					out = pUtility->GetFileName(OutPath);
					*out = 0;
				}
				else
					usage();
			}
			break;

			case 's':
				{
					mindex = Get_Opt_Index("-s");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
					else
						strcpy (Arg[mindex],"400");	//default size is 400
				}
			break;
			case 'q':
				{
					mindex = Get_Opt_Index("-q");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
				}
			break;

			case 'd':
				{
					mindex = Get_Opt_Index("-d");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
					else
						strcpy (Arg[mindex],"0");	//default is 0
				}
			break;
			case 'e':
				{
					mindex = Get_Opt_Index("-e");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
				}
			break;
			case 'r':
				{
					mindex = Get_Opt_Index("-r");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
					else
						strcpy (Arg[mindex],"300.0");	//default is 300 dpi
				}
			break;
			case 'g':
				{
					mindex = Get_Opt_Index("-g");
					if ( *optarg)
						strcpy(Arg[mindex],optarg);
					else
						strcpy (Arg[mindex],"1.0");	//default is 1.0
				}
			break;
			case 't':
				{
					mindex = Get_Opt_Index("-t");
					strcpy(Arg[mindex],"true");
				}
			break;
			case 'k':
				{
					mindex = Get_Opt_Index("-k");
					strcpy(Arg[mindex],"true");
				}
			break;
			case 'c':
				{
					mindex = Get_Opt_Index("-c");
					strcpy(Arg[mindex],"true");
				}
			break;
			case 'a':
				{
					mindex = Get_Opt_Index("-a");
					strcpy(Arg[mindex],"true");
				}
			break;
			case 'v':
				{
					mindex = Get_Opt_Index("-v");
					strcpy(Arg[mindex],"true");
				}
			break;
			case '?':
			case 'h':
			default:
			{
				usage ();
				exit (0);
			}
		}	
	}
	int kk;
	for ( jj = argc -1; jj >=0 ; jj--)
	{
		if ( *argv[jj] =='-' )
			break;
	}

	WString aa = *(argv[jj]+1);
	if ( strstr("tkcavh?",(char *)aa) )	{
//        printf ("292   no argument for %s\n",(char*)aa);
		jj++;
	}
	else
	{
		if ( strlen(argv[jj]) > 2 )
			jj++;
		else
			jj +=2;
	}
	kk = jj;
	nn = 0;
// The options were proccessed, do the rest of the arguments	
	while ( kk < argc )
	{
		int res;
		res = stat(argv[kk],&Fstat);
		if ( res )
			goto	CONT;
		if ( S_ISDIR(Fstat.st_mode) )	//don't process directories
			goto	CONT;

		if ( strstr(argv[kk],OutPath) == argv[kk] )
			goto CONT;

		type = pmHdr->GetImageType(argv[kk] );
//		printf("314 Files %d %s  %d\n",nn,argv[kk], type);
		if ( type >= 0 ) {
			mStack->AddStr(argv[kk]);
			mStack = mStack->Next;						
			nn++;
		}
		else
		{

			if ( !strstr(argv[kk],".hdr") ) {
				if ( type >= 0 ) {
				mStack->AddStr(argv[kk]);
				}
			}
		}
CONT:
		kk++;
		if ( kk >= argc )
		break;
	}
//	printf ("Options::Fill_Opt_Arguments() EXIT\n");
	return false;
}


/*---------------------------------------------------*/
void    Options::usage ()
{
	int jj;

	static WString UsageText[] =
	{
		"\nImgScale Usage:\n",
//		"ImgScale	-i inputFile [ -o OutputFile ] -s ###[%] [-d # ] [-k] [-t] [-c] [-q ###]\n",
//		"		-r### [-?][-h]\n",
		"ImgScale	-i inputFile [ -o OutputFile ] -s ###[%] [-d # ] [-k] [-t] [-c] [-q ###]\n",
		"	[-e .ext][-?][-h]\n",
		"	Input File extensions are [.tif/.jpg/.bmp/.pgm/.ppm/.tga/.png/.gif]\n",
		"	Input wildcards are allowed\n",
		"-i[--input] 	input file(s)\n",
		"	if -i contains a wildcard, then only the path is extracted from the -o option\n",
		"-o[--output]	output path and or file\n",
		"	if -o is not specified the output will be directed to /tmp\n",
		"	if only path is specified use the trailing '/' as in [ /foo/ ]\n",
		"-s[--size] ###[%]  [ default 400 ]\n",
		"	Output size in pixels or percent of the original image.\n",
		"	if % is appended to the ### then the the original image is scaled by percentage as specified\n"
		"	-a option is not used with [%]\n",
		"-q [--quality] ### [ default 66 with -t option]\n"
		"	JPG output quality of the JPG thumbnail. Usefull range 15 to 95 ( 0 to 100 )\n",
		"	0 or no argument produces a Bi-cubically scaled TIF image as *.scl\n",
		"	see also -t option\n",
		"-d [--debug] #\n",
		"	debug level 0 to 5\n",
//		"-r [--res ] ###.### [default 300.00]\n",
//		"	Output Image Res in dpi.\n",
		"-g [--gamma ] ###.### [default 1.00]\n",
		"	Output Image Gamma.\n",
		"	Gamma is not applied if no -t or -q options ( scaling ).\n",
		"-k [--keephdr]\n",
		"	Keep the generated Image header files\n",
		"	The headers are placed to the output directory, see [-o]\n"
		"-t [--thumbnail]\n",
		"	produces a JPEG output with *.tnl extention if -q is not specified default is used\n",
		"	if -t option is not given, the output file extention will be *.scl\n",
		"-c [--compress]\n",
		"	if -q option is 0 or not specified compress the output TIFF file\n",
		"-v [--version]\n",
		"	display the version number\n",
		"-a [--fit_to_square]\n",
		"	fit the output image into a square defined by the -s option\n",
		"-e Outputfile Extention.\n",
		"-?, -h print this mesg.\n",
		""
	};
	jj = 0;
	while ( *UsageText[jj] )
	{
		printf("%s", (char *)UsageText[jj]);
		jj++;
	}
	return;

}
#ifdef DEBUG_OPTIONS
#undef DEBUG_OPTIONS
#endif
