//FILE:		ImgScale.cc
//Revision:	2.18.14
#include "copyright.h"

#include    <stdio.h>
#include    <stdlib.h>
#include    <sys/types.h>
#include    <Tii/ImageLib.h>
#include    <Tii/HdrClass.h>
#include    <Tii/ImgClass.h>
#include    <Tii/Utility.h>
#include    <Tii/TIFFClass.h>
#include    <Tii/WString.h>
#include    "Options.h"

#ifndef	RANGE
// chack whether a is in range of <b,c> if a<b return b; a > c retun c
#define RANGE(a,b,c) (a < b)?b:( (a > c)?c: a )
#endif

#ifndef IMPORT_LIB
#define IMPORT_LIB extern
#endif

#define PROG_VERSION "v 2.8.14 2004/11/06 12:32:09"
#define STR_LEN	1024
IMPORT_LIB      TIFFClass   *pTIFFClass;	// defined in ImgLib
IMPORT_LIB      Utility     *pUtility;		// defined in ImgLib

int         DEBUG_LEVEL =   0;   //Debug LEVEL

ImgClass    *GImg           =   NULL;
ImgClass    *TmpImg         =   NULL;

Options     *pOptions       =   NULL;
HdrClass    *pHeader        =   NULL;
char        tmps[256];
//WString  Files[NO_OPTION_FILES];

int SpecSize;
double Aspect;                   	// width/height
IMPORT_LIB  double  coef[4][NO_COEF];    //defined in ImgLib

int     ReadProgress();

// check if the file exists and if true
// prepend X### to the filename
char *MakeOutFile ( char *FileName )
{
	char *extention;
	static char mFile[STR_LEN];
	static char Fname[STR_LEN];
	static char mPath[STR_LEN];
	char *ptr = NULL;
	int j = 0;
	strcpy( mFile,FileName);
	extention = pOptions->Get_Opt_Arg("-e");

	if ( *extention ) {
			pUtility->ChangeExt(mFile,extention);
	}
	else {
		extention = pOptions->Get_Opt_Arg("-t");
		if (*extention ) {      //NO, but do we have -t
			pUtility->ChangeExt(mFile,"tnl");
		}
		else {
			pUtility->ChangeExt(mFile,"scl");
		}
	}
	if ( !pUtility->FileExists(mFile) )
		return mFile;
	else {
		ptr = pUtility->GetFileName(mFile);
		if ( *ptr == 0 )
			return mFile;
		strcpy( Fname,pUtility->GetFileName(mFile));
		*ptr = 0;
		strcpy(mPath,mFile);


LOOP:
		sprintf(mFile,"%sX%03d_%s",mPath,j++,Fname);
		if ( !pUtility->FileExists(mFile) )
			return mFile;
		goto    LOOP;
	}
	return mFile;
}
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int main (int argc, char *argv[] )
{
	Str_Stack *mStack = NULL;
	bool    Compress = false;
	char    tmps[256];
	int		Err_No = 0;
	int j;
	int k;
	int     NoFiles = 0;
	int JpgQual = 0;
	int	XSize,YSize;
	char    InFile[128];
	char    OutFile[128];
	char    HdrFile[128];
	char    OutPath[128];
	char    DstFile[128];

	//    char    *Ptr;
	char  *Ptr;
	char    *in;
	char    *out;
	char    *ptr;

	int     size;
	int     stat =0;
	int     JpegFlag    =0;
	int Origx,Origy,width,height;
	int FilePtr =0;
	bool    Thum;
	bool    RemoveHdr;
	WString	InputFile;
	//    char	*Files[NO_FILES];
	bool    bstat = false;
	int     Index;
	double  ImgScale = 0;
	double	Scale = 0.0;		//optional percent scaling factor
	float	Res = 300.0;
	double	Gamma = 1.0;
	//	printf ("argc =%d\n",argc);
	int calcSize;
	Init_ImageLib();		// initiate the library !!

	
	if ( !pOptions)
		pOptions =   new Options;
	
	if ( argc < 2 ) {
		pOptions->usage();
		goto    ERR;
	}
	//	Fill up the option info
	if ( pOptions->Fill_Opt_Arguments( argc, argv ) )   {
		//        pOptions->usage();
		goto    ERR;
	}

	Ptr = pOptions->Get_Opt_Arg("-v");
	if ( *Ptr )    {
		printf("ImgScale version %s\n",PROG_VERSION);
		printf("WM_ImgLib version %s\n",Get_Version_String());
		goto    ERR;
	}

	// the debug option
	Ptr = pOptions->Get_Opt_Arg("-d");
	//	printf("Ptr =  %s\n",Ptr);
	if ( *Ptr != 0 )
		DEBUG_LEVEL = atoi(Ptr); // set to 0 if < 0 
	DEBUG_LEVEL = RANGE(DEBUG_LEVEL,0,5);
	/*++++++++++++++++++++++++++++++++++++++++++*/
	if ( DEBUG_LEVEL > 4 )
		printf("187	Main	ENTRY\n");
	/*++++++++++++++++++++++++++++++++++++++++++*/


	// this should not happen
	if ( pUtility == NULL ) {
		if ( DEBUG_LEVEL > 4 )
			printf("195	ImgScale(..) Creating Utility\n");
		pUtility = new Utility;
	}

	Index = 0;
	// check the -t option

	if ( DEBUG_LEVEL > 3 )
		printf("203	Main	After pOptions->Fill_Opt_Arguments(..)\n");

	Ptr = pOptions->Get_Opt_Arg("-t");
	Thum = false;
	if( *Ptr)
		Thum =true;              // yes we want a thumbnail

	Compress = false;
	Ptr = pOptions->Get_Opt_Arg("-c");
	if( *Ptr )
		Compress =true;          // yes we want compressed image
								// the quality option    
	Ptr = pOptions->Get_Opt_Arg("-q");
	JpgQual = 0;
	if ( *Ptr ==0 )
	{
		if ( *pOptions->Get_Opt_Arg("-t") )
			JpgQual = 66;
	}
	else
	{
		JpgQual = atoi(Ptr);         // set to 0 if < 0
		if ( JpgQual > 100 )         // set to 75 if > 100
			JpgQual= 100;
		else if (JpgQual <= 0)
			JpgQual =0;
	}
	if ( DEBUG_LEVEL > 0 )
		printf("231	Main	Quality set to %d\n",JpgQual);

	//    InitImCl( &JpgImg );	// clear the image structure
	FilePtr =0;
	stat  = 0;
								// the size option
	Ptr = pOptions->Get_Opt_Arg("-s");
	if ( strstr(Ptr,"%") )
	{
		strcpy(tmps,Ptr);
		tmps[strlen(tmps) -1] =0;	//assume last char is '%'
		Scale = atof(tmps)/100.00;
		SpecSize = 0;
	}
	else
	{
		SpecSize = atoi( Ptr );

		if ( SpecSize <= 0 )
			SpecSize = 500;          //	use	300 	as default;
	}
	Ptr = pOptions->Get_Opt_Arg("-g");
	if ( *Ptr )
	{
		Gamma = atof( Ptr );

		if ( Gamma <= 0.0 )
			Gamma = 1.0;          //	use	300 	as default;
	}
//	printf ( "SpecSize = %d Scale =%6.3f\n",SpecSize,Scale);

	size =  SpecSize;
	if ( DEBUG_LEVEL > 0 )
		printf("238	Main	Output size set to %d\n",size);

	RemoveHdr   = true;
	if ( *pOptions->Get_Opt_Arg("-k") )
		RemoveHdr   = false;          // yes keep the headers
	if ( DEBUG_LEVEL > 0 )
		printf("244	Main	RemoveHdr set to %d\n",RemoveHdr);

	/*-----------------	Main processing	----------------------------------*/

	out = pOptions->Get_Opt_Arg("-o");
	*OutPath =  0;
	*DstFile =  0;

	if ( *out ) {
		strcpy( OutPath, out);
		Ptr = pUtility->GetFileName(OutPath);
		strcpy ( DstFile,Ptr);
		*Ptr = 0;
		if ( DEBUG_LEVEL > 1 )
			printf("284	Main OutPath = %s File = %s\n",OutPath,DstFile);
	}
	else {
		strcpy (OutPath,"/tmp/");
	}

//	printf ( " 237	Files[0] = %s\n",(char *) Files[0]);
//	printf ( " 238	Files[1] = %s\n",(char *) Files[1]);

	FilePtr = 0;
	Err_No = 0;
//	mStack = pStack;
//	printf ("Stack = %0x \n",mStack);
//wm	if ( Files[FilePtr].len() > 0 )
	mStack = &pOptions->FileStack;
	if ( !mStack->Stack_Str )
	{
		pOptions->usage();
		goto DONE;
	}
	if ( mStack->Stack_Str->len() > 0 )
	{
		if ( pHeader == NULL )
			pHeader = new HdrClass;

		while ( mStack->Stack_Str->len() > 0 ) {
			//__________________________________________
			// Genererate the header file, Just in case
			//__________________________________________
			if ( DEBUG_LEVEL > 1 )
			printf(
				"307	Main  InputFiles = %s %d\n",
				(char *) mStack->Stack_Str->str_element,FilePtr
			);
			sprintf( HdrFile,"%s%s",OutPath,pUtility->GetFileName((char *) mStack->Stack_Str->str_element ) );
			pUtility->ChangeExt (HdrFile,"hdr");

			if ( pHeader->ProcHdr((char *)(mStack->Stack_Str->str_element) ) )
			{
				printf ("ProcHdr(%s) failed\n",(char *)mStack->Stack_Str->str_element);
				goto	LOOP;
			}
			Aspect = (double) pHeader->ImHdr.Width / (double) pHeader->ImHdr.Height;
			if ( DEBUG_LEVEL > 2 ) {
				printf("318 Got Aspect = %f\n",Aspect);
				printf("319 ImHdr.Width %d ImHdr.Height %d ImHdr.TYPE %d\n",
				pHeader->ImHdr.Width,pHeader->ImHdr.Height,pHeader->ImHdr.TYPE);
			}
			XSize = SpecSize;
			YSize =-1;

			if( Scale > 0.0 )
			{
				XSize = SpecSize = (int)( (double)pHeader->ImHdr.Width * Scale);
			}
			else
			{
				if ( *pOptions->Get_Opt_Arg("-a") ) {
	// if the Height > width, set YSize to SpecSize, and calculate the XSize				
					if (Aspect < 1.0 ) {
						XSize  = (int) ( 0.5 + (double) SpecSize * Aspect );
						YSize = SpecSize;
					}
					else
						XSize =  SpecSize;
				}
			}
//            printf ("316	SpecSize = %d\n",SpecSize);
			Ptr = pOptions->Get_Opt_Arg("-r");
			if ( *Ptr )
				Res = atof(Ptr);
//			if ( Res > 0.0 )
//				GImg->ImgStruct.Res = Res;

			if ( SpecSize == 0 )
				size = pHeader->ImHdr.Width;
			else
				size = SpecSize;
//			printf("327	size = %d X=%d  Y=%d\n",size,XSize,YSize);
//            sprintf ( HdrFile,"%s%s",OutPath,pUtility->GetFileName((char *) Files[FilePtr]) );
//            pUtility->ChangeExt (HdrFile,"hdr");

			if ( DEBUG_LEVEL > 2 )
				printf("37	Main  Writing header %s\n",HdrFile );


			if ( pHeader->WriteHeader(HdrFile) ) {
				stat = -1;
				Err_No++;
				printf ("ERR: %s",Get_Last_Error());
				goto    LOOP;
			}

			if ( *OutPath) {
				sprintf(OutFile,"%s%s",OutPath,pUtility->GetFileName((char *)mStack->Stack_Str->str_element));
								// -t should not return NULL
				strcpy(OutFile,MakeOutFile(OutFile));
			}

			// if ( JpgQual == 0 ) scale to tif
			if ( JpgQual == 0 ) {
				// do the proper scaling of the image

				ptr = pOptions->Get_Opt_Arg("-e");                
				if ( *ptr )
					pUtility->ChangeExt(OutFile,ptr);
				else
					pUtility->ChangeExt(OutFile,"scl");

				if ( DEBUG_LEVEL > 3 )
					printf("382	Main  reading Image  XSize %d %d \n",XSize,pHeader->ImHdr.Width);

				ImgScale = (double) XSize / (double)pHeader->ImHdr.Width;

				if ( DEBUG_LEVEL > 3 )
					printf("387	Main reading Image  Q=%d S=%d %s to %s\n",JpgQual,SpecSize,pHeader->ImHdr.File,OutFile );

				stat = false;
				if ( DEBUG_LEVEL > 3 )
					printf("390	Main	GImg scale  = %f file = %s\n",ImgScale, pHeader->ImHdr.File);

				printf("393	Generating Output  %s from %s\n",OutFile,pHeader->ImHdr.File);

				// Make properly scaled Image
				if (Res ==0 )
					Res = 600.0;
				if ( SlowScaleImage(Compress,pHeader->ImHdr.File, OutFile, ImgScale, -1.0,Res))
				{
					if ( DEBUG_LEVEL > 3 )
						printf("401	Main	CScaleImage(..) returned nonzero\n");
					stat = true;
				}
				if ( DEBUG_LEVEL > 3 )
					printf("404	Main	after CScaleImage(..) returned OK\n");

				if ( GImg )
					GImg->DelImgData();
			}
			else
			{
				ptr = pOptions->Get_Opt_Arg("-e");                
				if ( *ptr )
					pUtility->ChangeExt(OutFile,ptr);
				else
					pUtility->ChangeExt(OutFile,"tnl");
				//producing JPG
				strcpy ( OutFile, MakeOutFile ( OutFile ));
				if ( DEBUG_LEVEL > 2 ) {
					printf("419	Main  generating Tnl Q=%d S=%d %s to %s OrSize = %d Aspect=%f %0x\n",JpgQual,SpecSize,HdrFile,OutFile,SpecSize,Aspect,GImg );
				}	
				printf("421	%d Generating %s from %s\n",FilePtr,OutFile,pHeader->ImHdr.File);
				InputFile = pHeader->ImHdr.File;
//				printf("Qual = %d size = %d Hdr-%s Out=%s Gmaa=%f\n",JpgQual,XSize,HdrFile,OutFile,Gamma);
				if(Make_Local_Tnl(JpgQual, XSize, HdrFile,OutFile,Gamma))
				{
					printf ( " Err: %s\n",Get_Last_Error());
					Err_No++;
					goto LOOP;
				}

				if ( DEBUG_LEVEL > 1 ) {
					printf("427	Main	calling Make_Local_Tnl_Img(%d,%d,%s,%s %0x)\n",JpgQual, SpecSize, HdrFile,OutFile,GImg);
			}

//	Another way of doing this
//			   stat  = Make_Local_Tnl_Img(JpgQual, size, (char*)InputFile,OutFile,GImg);
			}

			if ( DEBUG_LEVEL > 2 )
				printf("436	Main	checking stat %d\n",stat);

			if ( stat )
			{
				if ( DEBUG_LEVEL > 2 )
					printf("441	Main	Make_Local_Tn FAILED\n");

				if ( *DstFile )
					goto    LOOP;
			}
LOOP:
			if ( DEBUG_LEVEL > 2 ) {
				printf("448	Main	LOOP FilePtr = %d\n",FilePtr);
			}
			if ( RemoveHdr ) {
				remove ( HdrFile);
			}
			FilePtr++;
			mStack = mStack->Next;				
//			if ( (char*)Files[FilePtr] == 0 )
			if ( mStack->Stack_Str == 0 )
			{
				if ( DEBUG_LEVEL > 2 )
					printf("456	Main	going to DONE\n");
				goto DONE;
			}
			if(GImg)
			GImg->DelImgData();
//			GImg = NULL;		//clear the image pointer
			if ( DEBUG_LEVEL > 2 ) {
				printf("463	Main	mStack->Stack_Str = %s\n\n",(char *)mStack->Stack_Str->str_element);
			}
			//		printf ( "FILE [ %s ] Processed\n",	Files[FilePtr] );
			//            printf ( "010-b	Generating Output  %s from %s\n",OutFile,pHeader->ImHdr.File);
			//            printf ( " %s processed to %s  size=%d \n",(char *)Files[FilePtr],OutFile,size);
			//                printf ( " %s processed to %s  size=%d \n",Files[FilePtr],OutFile,size);
		}
	}
DONE:
	// remove the loaded classes
	if ( DEBUG_LEVEL > 4 )
		printf("468 pHeadedr = %0x\n",pHeader);

	if ( pHeader ){
		delete  pHeader;
		pHeader = NULL;
	}


	if ( DEBUG_LEVEL > 4 )
		printf("477	pOptions = %0x\n",pOptions);

	
	if (pOptions)
		delete pOptions;
	

	if ( DEBUG_LEVEL > 4 )
		printf("491 TmpImg = %0x\n",TmpImg);

	if (TmpImg)	{
		delete TmpImg;
		TmpImg = NULL;
	}

	if ( DEBUG_LEVEL > 4 )
		printf("493    GImg = %0x\n",GImg);

	if (GImg ) {
		delete  GImg;
		GImg = NULL;
	}

	// if we kept the tmp headers remove them
	remove ( "/tmp/*.hdr");
	if ( DEBUG_LEVEL > 4 )
		printf("503	Main	EXIT\n");
	// clean up the library
	Destroy_ImageLib();
	if ( Err_No > 0 ) {
		printf (" ImgScale completed with %d Erros\n",Err_No);
		return  stat;
	}
	else {
		if ( FilePtr > 0 )
			printf (" ImgScale completed %d images processed\n",FilePtr);
		return  stat;
	}

ERR:
	stat = -1;
	goto    DONE;
}

