// ImgClass.cpp : implementation file
//
#include "copyright.h"
#include <Tii/ImgClass.h>
/*
 * NOTE:
 * Image may be a set of images.
 * The first image has Parent set to NULL
 * if Parent == NULL ImgStruct.Lines is a total no of lines in all images.
 * if NextImage != NULL, SplitImage must be non zero
 *
 * ThisImageLines is a number of lines in the current Image
 * NextImage is pointer to the next image or NULL if none
 * MextImage->Parent is a pointer to the preceeding Image.
 * 
 */
/////////////////////////////////////////////////////////////////////////////
// ImgClass

ImgClass::ImgClass()
{
//	Clear the header
	memset( &ImgStruct,0, sizeof (IMG_t) );
	memset( &ImHdr,0, sizeof (IMAGE_HDR_t) );
	ImgStruct.nBits =8;
	ImgStruct.update = true;
	ImgStruct.Res = 300.0;
	ImgStruct.ResUnit = 2;
	Gamma[0] = Gamma[1] = Gamma[2] = 1.0;
	NextImage   = NULL;
	Parent      = NULL;
	ImgStruct.mod = 0x2;		//allow deletion
	Allocated = 0;
	Access = 0;
	ThisImageLines = 0;
	SplitImage =SPLIT_IMAGE;				//try to allocate chunks for HP
								// 0 will allocate just one big chunk of memory
	RMap = GMap = BMap = NULL;
//	SetMapOneToOne();

}


ImgClass::~ImgClass()
{
	if ( ( Allocated ) ||  (ImgStruct.ImgData != NULL ) )
		DelImgData();
	if ( RMap )
		delete [] RMap;
	if ( GMap )
		delete [] GMap;
	if ( BMap )
		delete [] BMap;
}


/////////////////////////////////////////////////////////////////////////////
static unsigned long Total = 0;
// when allocating ImgData, first allocate m50M chunk of memory
// if allocation fails ERROR
// this will leave at least m50M for the OS
bool ImgClass::SetImgData()
{
	//	static unsigned long Total = 0;
	byte    *dummy = NULL;
	static  int m100MLines;
	static  int NoSubImages;

	int OrigLines = ImgStruct.lines;
	// make sure we are clean
	DelImgData();

	if ( SplitImage == 0 )             // allocate one big chunk of memory
	{
		//		printf ( "ImgClass::SetImgData SplitImage = 0 \n");
		if  (
			( ImgStruct.pixels      < 3 )  ||
			( ImgStruct.lines       < 3 )  ||
			( ImgStruct.LineSize    < 3 )
			)
			return true;
		//50 meg chunk of memory
		dummy = (byte *)    malloc(m50M);		//Leave 50Megs for the OS
		if ( dummy == NULL )
		{
			printf ("86	ImgClass::SetImgData() failed 50M allocation ERROR\n");
			goto    ERR;
		}

		// lets keep 50Megs extra
		ImgStruct.ImgData =  (byte *) malloc (ImgStruct.LineSize * ImgStruct.lines);
		if ( ImgStruct.ImgData == NULL)
		{
			// not enough room
			printf ("95	ImgClass::SetImgData() 50M allocation ERROR\n");
			goto ERR;
		}
		Allocated = ImgStruct.LineSize * ImgStruct.lines;
		ThisImageLines = ImgStruct.lines;
	// free the extra 50M chunk 
		if ( dummy )             // should be true always, but just in case
			free (dummy);        // get rid of the 50M chunk and return OK
		return false;

	}
	// this is to allocate a whole bunch of chunks of image sections.
	// each section will fit into m100M ( 100 megs, or something )    
	// to access individual lines use the GetLinePtr()
	m100MLines = m100M / ImgStruct.LineSize;
	NoSubImages = 0;

	if (
		( ImgStruct.pixels      <= 0 )  ||
		( ImgStruct.lines       <= 0 )  ||
		( ImgStruct.LineSize    <= 0 )
	)   {
	//we don't have all the data to allocate image is too small
		return true;
	}
	
	// try to allocate the 50Meg chunk if we fail, get out
	// Only the first image has no parent
	if ( Parent == NULL )
	{
		//50 meg chunk of memory, allocate it only once
		dummy = (byte *)    malloc(m50M);
		if ( dummy == NULL )
		{
			printf ("129	ImgClass::SetImgData() failed 50M allocation ERROR\n");
			goto    ERR;
		}
	// just to make sure the header has the right image dimensions
		ImHdr.Width = ImgStruct.pixels;
		ImHdr.Height = ImgStruct.lines;
		ImHdr.nCh    = ImgStruct.nCh;
		strcpy(ImHdr.File,ImgStruct.File);
	}
	// Get the no of extra allocation slots
	NoSubImages = 0;
	if ( ImgStruct.lines*ImgStruct.LineSize > m100M )
		NoSubImages = ImgStruct.lines*ImgStruct.LineSize / m100M;

	if ( NoSubImages > 0 )
	{
		// crete next section
		NextImage = new ImgClass;
		//and set this as the parent image
		NextImage->Parent = this;

		NextImage->ImgStruct.pixels =  ImgStruct.pixels;
		NextImage->ImgStruct.LineSize =  ImgStruct.LineSize;
		// allocate the m100M chunk
		// allocate this section
		ImgStruct.ImgData =  (byte *) malloc (ImgStruct.LineSize * m100MLines);
		if ( ImgStruct.ImgData == NULL)
		{
			// Allocation ERROR
//			DelImgData();
			//			printf ("159	ImgClass::SetImgData() Memory allocation ERROR\n");
			goto ERR;
		}
		ThisImageLines = m100MLines;
		/*
		* Each subsection indicates the remaining no of lines,
		* may be greater the m100M,
		* The nain image indicate the total no of image lines, NextImage will have m100M subtracted
		* from the total
		*/
		NextImage->ImgStruct.lines = ImgStruct.lines - m100MLines;
		//allocate the next segment
		NextImage->SetImgData();
		if ( NextImage->ImgStruct.ImgData == NULL )
		{
//			DelImgData();        // we have failed ERROR
			printf ("175	ImgClass::SetImgData() allocation ERROR\n");
			goto    ERR;
		}
	}
	else
	{
		// the image needs les them m100M, allocate the entire image
		//		printf ( "182	ImgClass::SetImgData() No More images\n");
		ImgStruct.ImgData =  (byte *) malloc(ImgStruct.LineSize * ImgStruct.lines);
		ThisImageLines = ImgStruct.lines;
	}
	// If we have allocated space set Allocated
	if ( ImgStruct.ImgData != NULL)
	{
		//		set the total allocate space
		Allocated = ImgStruct.LineSize * ImgStruct.lines;
		//get rid of the 50M chunk and return OK
		if ( dummy )
			free (dummy);
		return false;
	}
	// We dont have the space allocated, ERROR
ERR:
	if ( dummy )
		free (dummy);

	if ( ImgStruct.ImgData != NULL)	{
		DelImgData();
	}
	return true;                 // return BAD, we shpuld not get here
}

// free the image data
// there is no check for update bit 2, just kill the data
// and suffer the consequences :-)
void ImgClass::DelImgData()
{
	if ( ImgStruct.ImgData != NULL )
	{
		free(ImgStruct.ImgData);
		ImgStruct.ImgData = NULL;
	}
	if ( NextImage )     // this is recursive
	{
		delete  NextImage;
		NextImage = NULL;
	}
	if ( RMap ) {
		delete [] RMap;
		RMap = NULL;
	}
	if ( GMap ) {
		delete [] GMap;
		GMap = NULL;
	}
	if ( BMap ) {
		delete [] BMap;
		BMap = NULL;
	}
	ThisImageLines = 0;
	Allocated = 0;
}


/*
* Get the pointer to the Image line
* this should be called only from the main image
* not any of the the NextImage !!!!
*/

byte    *ImgClass::GetLinePtr( int Line )
{
	static  byte    *RetPtr = NULL;
	int mLine = Line;
	int	mTotalLines = 0;
	int	DestLine = mLine;
	// make sure the line is within the range
	mLine = RANGE(Line,0,ImgStruct.lines -1);
	
	// if the image has only one big chunk of memory
	if ( SplitImage == 0 )
	{
		RetPtr = ImgStruct.ImgData + mLine * ImgStruct.LineSize;
		return RetPtr;
	}

	ImgClass    *mImg = this;

	int m100MLines = m100M / ImgStruct.LineSize;

	// if there is no next Image just return the pointer
	if ( NextImage == NULL )
	{
		return( ImgStruct.ImgData + mLine * ImgStruct.LineSize);
	}
	// total line is the no of lines of the first image
	mTotalLines = mImg->ThisImageLines;
	
	//	point to the proper image segment
	if ( mLine >= mTotalLines )
	{
		// are we pointing to the next segment?
		while (mLine >= mTotalLines )
		{
			// subtract the current image lines from total
			DestLine -= mImg->ThisImageLines;
			// point to the next image
			mImg = mImg->NextImage;
			// and increment the total
			mTotalLines += mImg->ThisImageLines;
		}
	}
	// and return the right pointer
	RetPtr = mImg->ImgStruct.ImgData + DestLine * ImgStruct.LineSize;
	return RetPtr;
}


/*
*	perform a (long) bit allignment of the data
*/
int ImgClass::LongAllign(int size)
{
	int j;
	static int kk;
	kk = size;

	j=size & 0x03;               // this should be faster assuming the size of long is 4
	if ( j )
		kk +=  sizeof(long)-j;
	return kk;
}
bool	ImgClass::SetMapOneToOne()
{
	if ( RMap ) {
		delete [] RMap;
		RMap = NULL;
	}
	
	if( GMap ) {
		delete [] GMap;
		GMap = NULL;
	}
	
	if( BMap) {
		delete [] BMap;
		BMap = NULL;
	}
	
	RMap = new int[256];
	GMap = new int[256];
	BMap = new int[256];
	
	int	jj;
	for( jj = 0; jj < 256; jj++)
	{
		RMap[jj] = GMap[jj] = BMap[jj] = jj;
	}
}
// returns true if the Maps are not allocated, or if they are 1:1
bool	ImgClass::IsLut1to1()
{
	register	int jj;
	if ( ( !RMap ) && ( !GMap ) && (!BMap ) )		// No LUTs
		return true;
		
	for ( jj =0; jj < 256; jj++)
	{
		if ( ( RMap[jj] + GMap[jj] + BMap[jj] ) != ( jj + jj +jj ) )
			return false;
	}
	return true;
}
/*
 * Img is just a pointer, don't delete it after calling AddImage!!!
 * return ERRORS:
 * 1:	ImgData is not allocated
 * 2:	Parent is not NULL, this is not the first Image
 * 3:	Differnet no of pixels, we should probably do something here
 * 4:	Different no of Channels, same as above
 */
int	ImgClass::AddImage( ImgClass *Img )
{
	ImgClass *mImg = this;
	
	// No data do nothing, and return ERROR
	if (Img->ImgStruct.ImgData == NULL )
		return 1;
	// if not the first Image return ERROR	
	if (Parent != NULL )
		return 2;
	// if pixels are different, ERROR		
	if (Img->ImgStruct.pixels != this->ImgStruct.pixels )
		return 3;
	// if channels are different return ERROR
	if (Img->ImgStruct.nCh != this->ImgStruct.nCh )
		return 4;
//	printf ( "AddImage NextImage = %0x\n",NextImage);
	if ( NextImage )
	{
		while ( mImg->NextImage != NULL ) {
			mImg = mImg->NextImage;
		}
	}
	SplitImage = 1;
	mImg->NextImage = Img;
	ImgStruct.lines += Img->ImgStruct.lines;
	
	return 0;
}
