#####################################################################
# Copyright (C) 2000 Artur Trzewik
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
######################################################################
# Header
# CVS - $Id
#
# Information:
# Hilfsprozeduren geladen durch Init.tcl
# keine xotcl Erweiterungen

# Hilfsprozeduren fr das Behandeln von tDom 
# spter in einen anderen Modul kappseln
#

# Transferiert eine XML Struktur zu tcl Liste
# <valuelist>
#   <item>list elem 1</item>
#   <item>list elem 2</item>
#   <item>list elem 3</item>
# </valuelist>
proc tdom_getvaluelist domNode {
    set vlist_node [lindex [$domNode selectNodes child::valuelist] 0]
    if {$vlist_node==""} return
    set valuelist {}
    foreach item_node [$vlist_node selectNodes child::item] {
	lappend valuelist [$item_node text]
    }
    return $valuelist
}
proc tdom_setvaluelist {domNode vlist} {
    set rdom_doc [$domNode ownerDocument]
    #Alte valuelist lschen
    foreach vlist_node [$domNode selectNodes child::valuelist] {
	$domNode removeChild $vlist_node
    }
    set vlnode [$rdom_doc createElement valuelist]
    $domNode appendChild $vlnode
    foreach item $vlist {
	set nodeitem [$rdom_doc createElement item]
	$vlnode appendChild $nodeitem
	$nodeitem appendChild [$rdom_doc createTextNode $item]
    }
}
proc tdom_getpername {domNode name} {
    set node [lindex [$domNode selectNodes child::$name] 0]
    if {$node==""} return
    return [$node text]
}
proc tdom_setpername {domNode name value} {
    set rdom_doc [$domNode ownerDocument]
    set node [lindex [$domNode selectNodes child::$name] 0]
    if {$node==""} {
	if {$value==""} return
	set node [$rdom_doc createElement $name]
	$domNode appendChild $node
    } else {
	if {$value==""} {
	    [$node parentNode] removeChild $node
	    return
	}
	foreach cnode [$node childNodes] {
	    $node removeChild $cnode
	}
    }
    $node appendChild [$rdom_doc createTextNode $value]
}
# sucht ein Tag <tagname name="$name"> beginnend mit Wurzelverzeichnis
proc tdom_findpername {domNode tagname name} {
    return [$domNode selectNodes //child::$tagname\[@name=\"$name\"\]]
}
proc tdom_getprimattr {table_node} {
     return [$table_node selectNodes {child::node()[not(self::table)]/descendant-or-self::attr[@primary_key="1"]/attribute::name}]
}
# erzeugt ein Kontext, tag Name oder 
# wenn bereits vorhandel liefert ihn leer
proc tdom_clearKontext {dom_node tagname} {
    set tag_node [lindex [$dom_node selectNodes child::$tagname] 0]
    if {$tag_node!=""} {
	foreach node [$tag_node childNodes] {
	    $tag_node removeChild $node
	}
    } else {
	set tag_node [[$dom_node ownerDocument] createElement $tagname]
	$dom_node appendChild $tag_node
    }
    return $tag_node
}
# Lscht ein child tag falls vorhanden
proc tdom_deleteKontext {dom_node tagname} {
    foreach node [$dom_node selectNodes child::$tagname] {
	$dom_node removeNode $node
    }
}
# Setzt eine TclX Keyed List als tDom Tag Attribute
# in defattr knnen die Default Werte definiert werden,
#  die jodoch nicht gesetzt werden.
# attr definiert nur die Attribute, die gesetzt werden sollen
proc tdom_keyl2attr {domNode keyl {defattr {}} {attr {}}} {
    #puts "k2a $keyl $defattr $attr"
    if {$defattr!=""} {
	set defk [keylkeys defattr]
    } else {
	set defk {}
    }
    #puts "KL $keyl $defattr DEF $defk"
    foreach key [keylkeys keyl] {
	if {$attr!="" && ![lcontain $attr $key]} continue
	if {[lcontain $defk $key] && [keylget defattr $key]==[keylget keyl $key]} {
	    if {[$domNode hasAttribute $key]} {
		# Die Defaultwerte werden entfern
		# Das soll die App. bernehemen
		#puts "entferne $key"
		$domNode removeAttribute $key
	    }
	    continue
	}
	$domNode setAttribute $key [keylget keyl $key]
    }
}
# Liefert tDOM Tag Attribute als Tcl Keyed List in attr knnen die Attribute 
# gesetzt werden, die ausgelesen werden sollen
# wenn keins dann alle
proc tdom_attr2keyl {domNode {attr {}}} {
    set ret {}
    foreach key [$domNode attributes] {
	if {$attr!="" && ![lcontain $attr $key]} continue
	if {[$domNode hasAttribute $key]} {
	    keylset ret $key [$domNode getAttribute $key]
	}
    }    
    return $ret
}
proc tdom_setdefaults {kl_ref defkl} {
    upvar $kl_ref kl
    set klk [keylkeys kl]
    foreach key [keylkeys defkl] {
	if {![lcontain $klk $key]} {
	    keylset kl $key [keylget defkl $key]
	}
    }
}
# berprft zwei tclx keylist auf Gleicheit
# bergabe per Referenc
proc keylequal {kl1 kl2} {
    upvar $kl1 mykl1 $kl2 mykl2
    #puts "$mykl1 $mykl2"
    # berprfen der gleichheit der schlssel
    if {[lsort [keylkeys mykl1]]!=[lsort [keylkeys mykl2]]} {
	return 0
    }
    foreach key [keylkeys mykl1] {
	if {[keylget mykl1 $key]!=[keylget mykl2 $key]} {
	    return 0
	}
    }
    return 1
}
#
# Eigene Implementierung (nach tclx) von Mengen Operationen
#
# eigene intersect tclx Prozedur
proc schnittMenge {list1 list2} {
    set intersectList ""
    set list1 [lsort $list1]
    set list2 [lsort $list2]
    while {1} {
        if {[lempty $list1] || [lempty $list2]} break
        set compareResult [string compare [lindex $list1 0] [lindex $list2 0]]
        if {$compareResult < 0} {
            lvarpop list1
            continue
        }
        if {$compareResult > 0} {
            lvarpop list2
        continue
        }
        lappend intersectList [lvarpop list1]
        lvarpop list2
    }
    return $intersectList
}
# eigene intersect3 erste list
# gib alle Elemente zurck, die in der list1 aber nicht in list2 sind
proc minusMenge {list1 list2} {
    set la1(0) {} ; unset la1(0)
    foreach v $list1 {
        set la1($v) {}
    }
    foreach elem $list2 {
        if {[info exists la1($elem)]} {
            unset la1($elem)
        }
    }
    return [array names la1]
}
proc addMenge {list1 list2} {
    set la1(0) {} ; unset la1(0)
    foreach v $list1 {
        set la1($v) {}
    }
    foreach v $list2 {
        set la1($v) {}
    }
    return [array names la1]
}
   
