CREATE TABLE customer (
  custId int DEFAULT '0' NOT NULL auto_increment,
  name varchar(20),
  street varchar(20),
  postcode varchar(10),
  city varchar(20),
  country varchar(20),
  comment text,
  PRIMARY KEY (custId)
);
CREATE TABLE product (
  productId int DEFAULT '0' NOT NULL auto_increment,
  name varchar(20),
  price int,
  PRIMARY KEY (productId)
);
CREATE TABLE cust_order (
  orderId int DEFAULT '0' NOT NULL auto_increment,
  custId int,
  paid tinyint,
  date date,
  transport enum('unknown','post','ship','air','pizzaboy'),
  PRIMARY KEY (orderId)
);
CREATE TABLE item (
  productId int NOT NULL,
  orderId int NOT NULL,
  count int DEFAULT 1,
  PRIMARY KEY (productId,orderId)
);
