
# Extend Xotcl Library for XotclIDE purposes
# All Classes can belong (be defined) by an Component 
# (or can be extendet by Component)
# There is same Default Component "default" for all Classes,
# which does not belong to any Component
# Class and Object are extended with methods for handlig
# additional metainformation as Component and Method Categories

namespace eval ide {
    proc lremove {list_ref elem} {
	upvar $list_ref list
	if {[set index [lsearch $list $elem]]>=0} {
	    set list [lreplace $list $index $index]
	    return 1
	}
	return 0
    }
    proc lremoveAll {list_ref listr} {
	upvar $list_ref list
        foreach elem $listr {
            lremove list $elem
        }
    }
    proc lcontain {list elem} {
	return [expr [lsearch $list $elem]>=0]
    }
    proc lappendIfNone {list_ref elem} {
	upvar $list_ref list
	if {![lcontain $list $elem]} {
	    lappend list $elem
	    return 1
	}
	return 0
    }
    proc lcollect {var_ref list test} {
	upvar $var_ref var
        set ret {}
        foreach a $list {
            set var $a
	    uplevel $test
            lappend ret $var
	}
        return $ret
    }
    proc lselect {var_ref list test} {
	upvar $var_ref var
        set ret {}
        foreach a $list {
             set var $a
	    if $test {
                lappend ret $var
            }
        }
        return $ret
    }
    proc ldetect {var_ref list test} {
	upvar $var_ref var
        foreach a $list {
            set var $a
	    if $test {
                return $a
            }
        }
        return
    }
}

#
# Tk Setting for Text widget
# 
bind Text <Control-v> {}
event add <<Paste>> <Control-v>
event add <<Paste>> <Button-3>

if {[Object info metadata component]==""} {
  Object metadata add component
  Object metadata add description
  Object metadata add categoriesProcs
  Object metadata add categoriesMethodsProcs
  Class metadata add categories
  Class metadata add categoriesMethods
}

Class instproc addCategory {category} {
    # lazy initialization of metadata
    if {[[self] info metadata categories]==""} {
	[self] metadata categories {}
	[self] metadata categoriesMethods {}
    }
    set categories [[self] metadata categories]
    if {[set index [lsearch $categories $category]]<0} {
	set index [llength $categories]
	lappend categories $category
	[self] metadata categories $categories
	[self] metadata categoriesMethods [concat [[self] metadata categoriesMethods] [list {}]]
    }
    return $index
}
Class instproc moveToCategory {method category} {
    [self] uncategoryFor $method
    if {$category=="_all_categories"} return
    set catindex [[self] addCategory $category]

    set cm [[self] metadata categoriesMethods]
    set category [concat [lindex $cm $catindex] $method]
    set cm [lreplace $cm $catindex $catindex $category]
    [self] metadata categoriesMethods $cm
}
Class instproc renameCategory {oldname newname} {
    return [[self] renameCategoryB $oldname $newname {}]
}
Class instproc deleteCategory {name} {
    return [[self] deleteCategoryB $name {}]
}
Class instproc uncategoryFor {name} {
    return [[self] uncategoryForB $name {}]
}
Class instproc getCategoryForMethod {method} {
    return [[self] getCategoryForMethodB  $method {}]
}
Class instproc getCategories {} {
    return [[self] getCategoriesB {}]
}
Class instproc getMethodsForCategory {category} {
    return [[self] getMethodsForCategoryB $category {}]
}
Class instproc moveToComponent {app} {
    set oldapp [[self] getCompObject]
    $oldapp removeClass [self]
    [self] metadata component $app
    set newapp [IDE::Component getCompObjectForName $app]
    $newapp addClass [self]
}
Class instproc getHeritage {} {
    set hlist [self]
    foreach sclass [[self] info superclass] {
	if {$sclass=="::Object"} continue
	lappend hlist [$sclass getHeritage]
    }
    return [list $hlist]
}
Class instproc getChildrenHierarchy {} {
    set hlist [self]
    foreach sclass [[self] info subclass] {
	lappend hlist [$sclass getChildrenHierarchy]
    }
    return [list $hlist]
}
Class instproc getAllInstMethods { {ignoreList {}} } {
    set methods [[self] info instprocs]
    foreach class [[self] info heritage] {
        if {$ignoreList!="" && [ide::lcontain $ignoreList $class]} continue
	set methods [concat $methods [$class info instprocs]]
    }
    return [lsort -unique $methods]
}
Class instproc getAllFullInstMethods { {ignoreList {}} } {
    set fmethods {}
    foreach m [[self] info instprocs] {
	lappend fmethods [list $m [self]]
        set marr($m) 1
    }
    foreach class [[self] info heritage] {
        if {$ignoreList!="" && [ide::lcontain $ignoreList $class]} continue
        foreach m [$class info instprocs] {
	    if {![::info exist marr($m)]} {
                lappend fmethods [list $m $class]
                set marr($m) 1
            }
        }
    }
    return $fmethods
}

Object instproc getSubobjectsHierarchy {} {
    ::set hlist [self]
    foreach sobject [[self] info children] {
	::lappend hlist [$sobject getSubobjectsHierarchy]
    }
    return [list $hlist]
}
Object instproc inspect {} {
    [self] basicInspect
}
Object instproc basicInspect {} {
    IDE::ObjectBrowser newBrowser [self]
}
Object instproc metadataDefBody {meta} {
    ::set script {}
    if {[[[self] info class] info metadata $meta]=="" && 
	[::Object info metadata $meta]==""
    } {
	::append script "[self] metadata add $meta\n"
    }
    ::append script "[self] metadata $meta [list [[self] metadata $meta]]\n"
    return $script
}
Object instproc metadataBody {meta} {
    return "[string trimleft [self] :] metadata $meta [list [[self] metadata $meta]]\n"
}

Object instproc metadataAsScript {} {
    ::set script {}
    foreach meta [[self] info metadata] {
        if {[ide::lcontain {categoriesMethodsProcs  categoriesProcs categoriesMethods categories} $meta] && [[self] metadata $meta]==""} continue
	::append script [[self] metadataDefBody $meta]
    }
    return $script
}
Object instproc metadataAsScriptPur {} {
    ::set script {}
    foreach meta [[self] info metadata] {
        if {[ide::lcontain {categoriesMethodsProcs  categoriesProcs categoriesMethods categories component} $meta]} continue
	::append script [[self] metadataDefBody $meta]
    }
    return $script
}
Object instproc getComponentName {} {
    if {[[self] info metadata component]==""} {
	return default
    }  else {
	return [[self] metadata component]
    }
}
Object instproc getCompObject {} {
    if {[[self] info metadata component]==""} {
	return [IDE::Component getCompObjectForName default]
    }  else {
	return [IDE::Component getCompObjectForName [[self] metadata component]]
    }
}
Object instproc moveToComponent {app} {
    ::set oldapp [[self] getCompObject]
    $oldapp removeObject [self]
    [self] metadata component $app
    ::set newapp [IDE::Component getCompObjectForName $app]
    $newapp addObject [self]
}
Object instproc renameCategoryB {oldname newname {postFix Procs}} {
    if {[[self] info metadata categories$postFix]==""} {return 0}
    ::set categories [[self] metadata categories$postFix]
    if {[::set index [lsearch $categories $oldname]]<0} {
	return 0
    }
    ::set categories [lreplace $categories $index $index $newname]
    [self] metadata categories$postFix $categories
    return 1
}
Object instproc deleteCategoryB {name {postFix Procs}} {
    if {[[self] info metadata categories$postFix]==""} {return 0}
    ::set categories [[self] metadata categories$postFix]
    if {[::set index [lsearch $categories $name]]<0} {
	return 0
    }
    ::set categories [lreplace $categories $index $index]
    [self] metadata categories$postFix $categories
    [self] metadata categoriesMethods$postFix [lreplace [[self] metadata categoriesMethods$postFix] $index $index]
    return 1
}
Object instproc addCategoryB {category {postFix Procs}} {
    # lazy initialization of metadata
    if {[[self] info metadata categories$postFix]==""} {
	[self] metadata categories$postFix {}
	[self] metadata categoriesMethods$postFix {}
    }
    ::set categories [[self] metadata categories$postFix]
    if {[::set index [lsearch $categories $category]]<0} {
	::set index [llength $categories]
	::lappend categories $category
	[self] metadata categories$postFix $categories
	[self] metadata categoriesMethods$postFix [concat [[self] metadata categoriesMethods$postFix] [list {}]]
    }
    return $index
}
Object instproc moveToCategoryB {method category {postFix Procs}} {
    [self] uncategoryForB $method $postFix
    if {$category=="_all_categories" || $category=="_uncategorized"} return
    ::set catindex [[self] addCategoryB $category]

    ::set cm [[self] metadata categoriesMethods$postFix]
    ::set category [concat [lindex $cm $catindex] $method]
    ::set cm [lreplace $cm $catindex $catindex $category]
    [self] metadata categoriesMethods$postFix $cm
}
Object instproc uncategoryForB {method {postFix Procs}} {
    if {[[self] info metadata categories$postFix]==""} {
	[self] metadata categories$postFix {}
	[self] metadata categoriesMethods$postFix {}
	return
    }
    ::set catindex 0
    foreach cat [::set cm [[self] metadata categoriesMethods$postFix]] {
	if {[::set index [lsearch $cat $method]]>=0} {
	    ::set cat [lreplace $cat $index $index]
	    [self] metadata categoriesMethods$postFix [lreplace $cm $catindex $catindex $cat]
	    return
	}
	::incr catindex
    }
}
Object instproc getCategoryForMethodB {method {postFix Procs}} {
    if {[[self] info metadata categories$postFix]==""} {
	[self] metadata categories$postFix {}
	[self] metadata categoriesMethods$postFix {}
	return
    }
    ::set catindex 0
    foreach cat [[self] metadata categoriesMethods$postFix] {
	if {[::set index [lsearch $cat $method]]>=0} {
	    return [lindex [[self] metadata categories$postFix] $catindex]
	}
	::incr catindex
    }
    return {}
}

Object instproc getCategoriesB {{postFix Procs}} {
    if {[[self] info metadata categories$postFix]==""} {
	[self] metadata categories$postFix {}
	[self] metadata categoriesMethods$postFix {}
	return {_all_categories _uncategorized}
    }
    return [::concat [[self] metadata categories$postFix] _all_categories _uncategorized]
}
Object instproc getMethodsForCategoryB {category {postFix Procs}} {
    if {$category=="_all_categories"} {
        if {$postFix==""} {
	    ::set methods [[self] info instprocs]
	    foreach par [[self] info parameter] {
		::set parname [lindex $par 0]
		if {[::set index [::lsearch $methods $parname]]>=0} {
		    ::set methods [::lreplace $methods $index $index]
		}
	    }
	    return $methods 
	} else {
            return [[self] info procs]
        }
    } elseif {$category=="_uncategorized"} {
        ::set allcategorized {} 
        foreach c [[self] metadata categoriesMethods$postFix] {
            ::set allcategorized [concat $allcategorized $c]
        }
        ::set all [[self] getMethodsForCategoryB _all_categories $postFix]
        ide::lremoveAll all $allcategorized
        return $all
    }
    ::set catindex [[self] addCategoryB $category $postFix]
    return [lindex [[self] metadata categoriesMethods$postFix] $catindex]
}
Object instproc printString {} {
    # please overweite it to specify your Object printSring
    # the return shoul short specify the object contens for
    # displaying in object inspector
    return "[self] instance of [[self] info class] [[self] info mixin]"
}
