#####################################################################
# Copyright (C) 2000 Artur Trzewik
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
######################################################################
# Header
# CVS - $Id: Init.tcl,v 1.6 2001/01/06 14:50:04 artur Exp $
#
# Information:
# Eine Zentrale Datei, die weitere Komponenten des TCL ldt
# Auch ein Punkt fr ntige Systemanpassungen
# XOTcl
# TclX
# tDom
# initieren von postgres und mysql Schnittstellen

package require Tix
package require Tclx
package require tdom

set helpdir /usr/share/doc/xdobry-0.20/docu

# List of Database interfaces
# the sources are loaded only then needed
# {name library XOTcl_class sql_interface_file schema_extract_file}
# Pease addapt 2nd list item for your library
set dbinterfaces {
    {mysql /usr/local/lib/libmysqltcl.so MySql xdobry::mysql xdobry::mysqlExt}
    {postgres /usr/lib/libpgtcl.so PgSql xdobry::pgsql xdobry::pgsqlExt}
    {dbitotcl /home/artur/dbitotcl/libdbitotcl.so DBISql xdobry::dbitotcl xdobry::dbitotclExt}
}


# Find Helpfile dictonary
if {![file exist $helpdir]} {
    if {[file pathtype $progdir]=="relative"} {
	set helpdir [file join [pwd] $progdir docs docu]
    } else {
	set helpdir [file join $progdir docs docu]
    }
}
# 

# Check the database interface libraries
# all interface, that are not fount, are removed from the "dbinterfaces" list
set temp_dbinterfaces {}
foreach interface $dbinterfaces {
    if {[file exist [lindex $interface 1]]} {
	lappend temp_dbinterfaces $interface
    }
}  
set dbinterface $temp_dbinterfaces

# Vorbereite mysql und postgesql Schnittstelle wenn bentigt
# package ifneeded mysqltcl 2.0 {
#     load $lib_mysqltcl
#     set mysqlstatus(nullvalue) NULL
# }
# package ifneeded Pgtcl 2.0 {
#     load $lib_pgtcl
# }

#Setze Image-Verzeichnis
tix addbitmapdir [file join $progdir bitmaps]

# von allen Komponenten benutzte Module
source [file join $progdir util.tcl]

# Are we in normal tcl mode or super xotclIDE
if {[Object info metadata component]==""} {
Object metadata add component

# Every Class can have a description
Object metadata add description

Class metadata add categories
Class metadata add categoriesMethods
Object metadata add categoriesProcs
Object metadata add categoriesMethodsProcs

package require xdobry::Container
package require xdobry::WidgetLib
package require xdobry::Dialog
package require xdobry::Validate
}
