<?php
/*
 *    SALM - SQL Abstraction Library
 Modified
 *           version 0.3
 * Nickolas Grebnev <nick@grebnev.ru.net>
 *
 * - 28/07: Initial version from Gianugo Rabellino <nemorino@opera.it>
 * - 29/04/1999: Modifications from Nickolas Grebnev <nick@sptl.org>
 * - 17/03/2000: Small ODBC fixes from PAUL WIELGOSZ <pwielgosz@home.com>
 * - 18/04/2000: Adabas support from Pierre GUNTZER <guntzer@arkane-media.net>
 * - 11/09/2000: Interbase support from Nickolas Grebnev <nick@grebnev.ru.net>
 * - 23/10/2000: Sybase SQL Server support from Nickolas Grebnev <nick@grebnev.ru.net>
 */

/*
 *
 * Set the variable $dbtype to any of the following
 * values: 
     MySQL,  mSQL, 
     Postgres, PostgreSQL_local,
     ODBC,  ODBC_Adabas,
     Interbase,
     Sybase
  before including
 * this library
 *
 */

/* $dbtype = "MySQL"; */
/* $dbtype = "mSQL"; */
/* $dbtype = "PostgreSQL"; */
/* $dbtype = "PostgreSQL_local";// When postmaster start without "-i" option. */
/* $dbtype = "ODBC"; */
/* $dbtype = "ODBC_Adabas"; */
/* $dbtype = "Interbase"; */
/* $dbtype = "Sybase"; */

if($sql_debug) $errlevel=7;
else $errlevel=5;
error_reporting($errlevel);
//error_reporting(15);

/*
 * SQL_connect($host, $user, $password, $db)
 * returns the connection ID
 */

function SQL_connect($host, $user, $password, $db)
{
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        $conn=@mysql_pconnect($host, $user, $password);
        @mysql_select_db($db);
        return $conn;
    break;;

    case "mSQL":
         $conn=@msql_pconnect($host);
         @msql_select_db($db);
         return $conn;
    break;;

              
    case "PostgreSQL":
         $conn=@pg_pconnect("host=$host user=$user password=$password port=5432 dbname=$db");
         return $conn;
    break;;
  
    case "PostgreSQL_local":
         $conn=@pg_pconnect("user=$user password=$password dbname=$db");
         return $conn;
    break;;
  
    case "ODBC":
         $conn=@odbc_pconnect($db,$user,$password);
         return $conn;  
    break;;

    case "ODBC_Adabas":
         $conn=@odbc_pconnect($host.":".$db,$user,$password);
	 return $conn;  
    break;;

    case "Interbase":
#         $conn=@ibase_pconnect($host.":".$db,$user,$password);
         $conn=@ibase_connect($host.":".$db,$user,$password);
         return $conn;
    break;;

    case "Sybase":
        $conn=@sybase_connect($host, $user, $password);
        @sybase_select_db($db,$conn);
        return $conn;
    break;;

    default:
    break;;
    }

}

function SQL_logout($id)
{
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        $conn=@mysql_close($id);
        return $conn;
    break;;

    case "mSQL":
         $conn=@msql_close($id)
;
         return $conn;
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
         $conn=@pg_close($id);
         return $conn;
    break;;
  
    case "ODBC":
    case "ODBC_Adabas":
         $conn=@odbc_close($id);
         return $conn;  
    break;;

    case "Interbase":
         $conn=@ibase_close($id);
         return $conn;
    break;;

    case "Sybase":
        $conn=@sybase_close($id);
        return $conn;
    break;;
  
    default:
    break;;
    }
}


/* 
 * SQL_query($query, $id)
 * executes an SQL statement, returns a result identifier
 */
  
function SQL_query($query, $id)
{
global $dbtype;
global $sql_debug;
if($sql_debug) echo "SQL query: ".str_replace(",",", ",$query)."<BR>";
switch ($dbtype) {

    case "MySQL":
        $res=@mysql_query($query, $id);
        return $res;
    break;;
    
    case "mSQL":
        $res=@msql_query($query, $id);
        return $res; 
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
        $res=@pg_exec($id,$query);
        return $res;
    break;;
    
    case "ODBC":
    case "ODBC_Adabas":
//        $rid=@odbc_prepare($id,$query);
//        $res=@odbc_execute($rid);
        $res=@odbc_exec($id,$query);
        return $res;  
    break;;
  
    case "Interbase":
        $res=@ibase_query($id,$query);
        return $res;
    break;;

    case "Sybase":
        $res=@sybase_query($query, $id);
        return $res;
    break;;

    default:
    break;;
    
    }   
}       
        
/*  
 * SQL_num_rows($res
)
 * given a result identifier, returns the number of affected rows
 */  

function SQL_num_rows($res)
{
global $dbtype;
switch ($dbtype) {
 
    case "MySQL":
        $rows=@mysql_num_rows($res);
        return $rows;
    break;;

    case "mSQL":  
        $rows=@msql_num_rows($res);
        return $rows;
    break;;
        
    case "PostgreSQL":
    case "PostgreSQL_local":
        $rows=@pg_numrows($res);
        return $rows;
    break;;
        
    case "ODBC":
    case "ODBC_Adabas":
        $rows=@odbc_num_rows($res);
        return $rows; 
    break;;
        
    case "Interbase":
#        $rows=ibase_numrows($res);
	echo "<BR>Error! PHP dosen't support ibase_numrows!<BR>";
        return $rows; 
    break;;

    case "Sybase":
        $rows=@sybase_num_rows($res);
        return $rows; 
    break;;

    default:
    break;;                          
    }                                
}                                    
                                     
/*                                   
 * SQL_fetch_row($res,$row)           
 * given a result identifier, returns an array with the resulting row  
 * Needs also a row number for compatibility with PostgreSQL           
 */                                  
                                     
function SQL_fetch_row($res, $nr)    
{                                    
global $dbtype;                      
switch ($dbtype) {                   
                                     
    case "MySQL":                    
        $row = @mysql_fetch_row($res);
        return $row;
    break;;                          
                                     
    case "mSQL":                     
        $row = @msql_fetch_row($res); 
        return $row;                 
    break;;                          
                                     
    case "PostgreSQL":               
    case "PostgreSQL_local":
        $row = @pg_fetch_row($res,$nr);
        return $row;                 
    break;;                          
                                     
    case "ODBC":                     
    case "ODBC_Adabas":
        $row = array();              
        $cols = @odbc_fetch_into($res, $nr, &$row);                     
        return $row;                 
    break;;                          
                                     
    case "Interbase":
        $row = @ibase_fetch_row($res);
        return $row;                 
    break;;                          

    case "Sybase":
        $row = @sybase_fetch_row($res);
        return $row;                 
    break;;                          

    default:                         
    break;;                          
    }                                
}                                    
                                     
/*                                   
 * SQL_fetch_array($res,$row)        
 * given a result identifier, returns an associative array             
 * with the resulting row using field names as keys.                   
 * Needs also a row number for compatibility with PostgreSQL.          
 */                                  
                                     
function SQL_fetch_array($res, $nr)  
{                                    
global $dbtype;                      
switch ($dbtype) 
    {
    case "MySQL":                    
        $row = array();              
        $row = @mysql_fetch_array($res);
        return $row;                 
    break;;                          
                                     
    case "mSQL":                     
        $row = array();              
        $row = @msql_fetch_array($res);
        return $row;                 
    break;;                          
                                     
    case "PostgreSQL":               
    case "PostgreSQL_local":
        $row = array();              
        $row = @pg_fetch_array($res,$nr);
        return $row;                 
    break;;                          
                                     
/*                                   
 * ODBC doesn't have a native _fetch_array(), so we have to            
 * use a trick. Beware: this might cause HUGE loads!                   
 */                                  
                                     
    case "ODBC":                     
        $row = array();              
        $result = array();           
        $result = @odbc_fetch_row($res, $nr);                           
//        $nf = count($result)+2; /* Field numbering starts at 1 */      
//        for($count=1; $count < $nf; $count++) 
	$nf = @odbc_num_fields($res); /* Field numbering starts at 1 */
        for($count=1; $count < $nf+1; $count++) 
	{                        
            $field_name = @odbc_field_name($res, $count);
            $field_value = @odbc_result($res, $field_name);
            $row[$field_name] = $field_value;
        }                        
        return $row;                 
    break;;                          

    case "ODBC_Adabas":                     
        $row = array();              
        $result = array();           
        $result = @odbc_fetch_row($res, $nr);                           

        $nf = count($result)+2; /* Field numbering starts at 1 */
	for($count=1; $count < $nf; $count++) {
	    $field_name = @odbc_field_name($res, $count);
	    $field_value = @odbc_result($res, $field_name);
	    $row[$field_name] = $field_value;
	}
        return $row;                 
    break;;                          

    case "Interbase":
	$orow=@ibase_fetch_object($res);
	$row=get_object_vars($orow);
        return $row;
    break;;                          

    case "Sybase":
        $row = @sybase_fetch_array($res);
        return $row;                 
    break;;                          

    }                                
}

function SQL_fetch_object($res, $nr)
{                                    
global $dbtype;                      
switch ($dbtype) 
    {
    case "MySQL":                    
        $row = @mysql_fetch_object($res);
	if($row) return $row;
	else return false;
    break;;                          
                                     
    case "mSQL":                     
        $row = @msql_fetch_object($res);
	if($row) return $row;
	else return false;
    break;;                          
                                     
    case "PostgreSQL":
    case "PostgreSQL_local":
        $row = @pg_fetch_object($res,$nr);
	if($row) return $row;
	else return false;
    break;;

    case "ODBC":                     
        $result = @odbc_fetch_row($res, $nr);                       
	if(!$result) return false;    
//        $nf = count($result)+2; /* Field numbering starts at 1 */
//        for($count=1; $count < $nf; $count++) 
	$nf = @odbc_num_fields($res); /* Field numbering starts at 1 */
        for($count=1; $count < $nf+1; $count++) 
	{                        
            $field_name = @odbc_field_name($res, $count);
            $field_value = @odbc_result($res, $field_name);             
            $row->$field_name = $field_value;
        }                        
        return $row;                 
    break;;                          

    case "ODBC_Adabas":                     
        $result = @odbc_fetch_row($res, $nr);                           
	if(!$result) return false;    

        $nf = count($result)+2; /* Field numbering starts at 1 */
	for($count=1; $count < $nf; $count++) {
	    $field_name = @odbc_field_name($res, $count);
	    $field_value = @odbc_result($res, $field_name);
	    $row->$field_name = $field_value;
	}
        return $row;                 
    break;;                          

    case "Interbase":
        $orow = @ibase_fetch_object($res);
	if($orow)
	{
	    $arow=get_object_vars($orow);
	    while(list($name,$key)=each($arow))
	    {
		$name=strtolower($name);
		$row->$name=$key;
	    }
    	    return $row;
	}else return false;
    break;;                          

    case "Sybase":
        $row = @sybase_fetch_object($res);
        return $row;                 
    break;;                          

    }                                
}

function SQL_result($res_id, $row, $mix)
{
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        $res=@mysql_result($res_id, $row, $mix);
        return $res;
    break;;
    
    case "mSQL":
        $res=@msql_result($res_id, $row, $mix);
        return $res; 
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
        $res=@pg_Result($res_id, $row, $mix);
        return $res;
    break;;
    
    case "ODBC":
        $rid=@odbc_prepare($id,$query);
        $res=@odbc_execute($rid);
        return $res;  
    break;;
  
    case "ODBC_Adabas":
        $temp = @odbc_fetch_into($res_id,$row+1,&$arr) ;
        while( list($clef,$valeur)=each($arr) ) {
	    $fieldname = @odbc_field_name($res_id,$clef+1) ;
    	    if ($fieldname == strtoupper($mix)) $res = $valeur ;
        }
        return $res;  
    break;;

    
    case "Interbase":
	echo "<BR>Error! PHP dosen't support ibase_result!<BR>";
        return false;
    break;;                          

    case "Sybase":
        $res=@sybase_Result($res_id, $row, $mix);
        return $res;
    break;;                          

    default:
    break;;
    
    }   
}

function SQL_error($id,$sql_string)
{
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string<BR> Error message from SQL-server: ".mysql_error()."</B><BR>";
    break;;

    case "mSQL":
         return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string</B><BR> Error message from SQL-server: <B>".msql_error()
."</B><BR>"
;
    break;;

              
    case "PostgreSQL":
    case "PostgreSQL_local":
         return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string</B><BR>Error message from SQL-server: <B>".pg_errormessage($id)."</B><BR>";
    break;;
  
    case "ODBC":
    case "ODBC_Adabas":
         return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string</B><BR> Error message from SQL-server: "."This is ODBC , edit module for error messages<BR>";  
    break;;

    case "Interbase":
         return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string</B><BR>Error message from SQL-server: <B>".ibase_errmsg()."</B><BR>";
    break;;

    case "Sybase":
         return "<BR><CENTER><B>Error!</B></CENTER><BR>SQL string: <B>$sql_string</B><BR>Error message from SQL-server: <B>"."This is Sybase , edit module for error messages<BR>";
    break;;

    default:
    break;;
    }
}


// Exporter une requete au format CSV
function SQL_csv($csv, $csvfile, $f) {
	
	global $dbtype ;
	
	switch ($dbtype) {
	
	case "MySQL":
		$query = stripslashes($csv) ;
		$file = fopen($csvfile,"w") ;
		
		list($left, $etc) = explode("FROM",$query) ;
		list($right, $end) = explode("LIMIT",$etc) ;
		
		// echo "left : $left, right : $right<br>" ;
		
		$left = ereg_replace(",", ",\"\t\",", $left) ;
		$left = ereg_replace("SELECT", "SELECT CONCAT(", $left) ;
		
		$query = $left.") FROM ".$right ;
		
		$result = SQL_query($query, $f) ;
		// echo "result : $result<br>" ;
		
		$num = SQL_num_rows($result) ;
		
		for ( $i = 0 ; $i < $num ; $i++ ) fputs($file, mysql_result($result,$i)."\n") ;
		
		fclose($file) ;
		
		break ;
		
	default :
		echo "Fonctionnalit export CSV non implment pour le type de base $dbtype<br>" ;
		break ;
		
	}
}

function SQL_fetch_cols($res, $id_col, $name_col)
{
	global $dbtype;
	$tmp_sel=array();
    if($dbtype=="Interbase")
    {
	$i=0;
	while($tmp_obj=@SQL_fetch_object($res,$i++))
	{
	    $tmp_sel[$tmp_obj->$id_col]=$tmp_obj->$name_col;
	}
    }
    else
    {
	for ($i = 0; $i < @SQL_num_rows($res); $i++)
	{
	    $tmp_name=@SQL_result($res,$i,$id_col);
	    $tmp_sel[$tmp_name]=@SQL_result($res,$i,$name_col);
	}
    }
        return $tmp_sel;                 
}	

function SQL_fetch_col($res, $name_col)
{
	global $dbtype;
	$tmp_sel=array();
    if($dbtype=="Interbase")
    {
	$i=0;
	while($tmp_obj=@SQL_fetch_object($res,$i++))
	{
	    $tmp_sel[]=$tmp_obj->$name_col;
	}
    }
    else
    {
	for ($i = 0; $i < @SQL_num_rows($res); $i++)
	{
	    $tmp_sel[]=@SQL_result($res,$i,$name_col);
	}
    }
        return $tmp_sel;
}	

function SQL_get_inserted_id($id, $res, $table_name, $id_name)
{
global $dbtype,$auto_increment;
switch ($dbtype) {

    case "MySQL":
	if($auto_increment)
	{
    	    $iid=@mysql_insert_id($id);
    	    return $iid;
	}    
    break;;
    
    case "mSQL":
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
        $iid=@pg_GetLastOid($res);
        $sql_string="SELECT $id_name FROM $table_name WHERE oid=$iid";
        $result=@SQL_query($sql_string,$id);
        return @SQL_result($result,0,$id_name);
    break;;
    
    case "ODBC":
    break;;
  
    case "ODBC_Adabas":
    break;;

    
    case "Interbase":
    break;;

    
    }   

    $sql_string="SELECT MAX($id_name) AS maxval FROM $table_name";
    $result=@SQL_query($sql_string,$id);
    $ores=@SQL_fetch_object($result,0);
    return $ores->maxval;
}	

?>