;
; Scale image
; Tested on Gimp 1.1.xx

(define (script-fu-simg size infile outfile jp) 
    (
	(let* 
	    (
		(img (car (gimp-file-load 1 infile infile)))
		(width (car (gimp-image-width img)))
		(height (car (gimp-image-height img)))
		(cx (/ width size))
		(cy (/ height size))
	    )
	    (if (<= cx cy) (set! cres cy) )
	    (if (>= cx cy) (set! cres cx) )
	    (set! reswidth (/ width cres))
	    (set! resheight (/ height cres))
	    (gimp-image-scale img reswidth resheight)
	    (set! lr (car (gimp-image-active-drawable img)))
	    (if (= jp 0) (gimp-file-save 1 img lr outfile outfile))
	    (if (= jp 1) (file-jpeg-save 1 img lr outfile outfile 0.75 0.00 1 0 "PHPGem http://phpgem.ru.net" 0 1 0 1))
	    (gimp-quit 0)
	)
    )
)

(script-fu-register "script-fu-simg"
		    _"<Toolbox>/Xtns/Script-Fu/Utils/Scale image to icon"
		    "Scale image to icon"
		    "Nickolas Grebnev <nick@grebnev.ru.net>"
		    "Nickolas Grebnev"
		    "17 Sep 2000"
		    ""
		    SF-ADJUSTMENT _"Size" '(100 0 1024 1 10 0 1)
		    SF-FILENAME   _"Input file" (string-append "" "" "")
		    SF-FILENAME   _"Output file" (string-append "" "" "")
		    SF-ADJUSTMENT _"Jpeg/Not" '(1 0 1 1 10 0 1)
		    )
