DROP PROCEDURE select_section_images;
DROP PROCEDURE select_images;
DROP PROCEDURE select_section;

SET TERM !! ;
CREATE PROCEDURE select_images (im_id int)
    RETURNS (select_images varchar(32000))
    AS
	DECLARE VARIABLE i integer;
	DECLARE VARIABLE image varchar(500);
    BEGIN
	select_images = '';
	i = 0;
	FOR select images_image from images_tbl where images_subsection_id = :im_id
	INTO :image
	DO 
	    BEGIN
		IF (i>0) THEN select_images = select_images || ',';
		select_images = select_images || image;
		i = i+1;
	    END
	suspend;
    END !!

CREATE PROCEDURE select_section_images (ss_id int)
    RETURNS (select_section_images varchar(32000))
    AS
	DECLARE VARIABLE i integer;
	DECLARE VARIABLE ss integer;
	DECLARE VARIABLE ssi varchar(32000);
    BEGIN
	select_section_images = '';
	i = 0;
	FOR select subsection_id from subsection_tbl where subsection_section_id = :ss_id
	INTO :ss
	DO 
	    BEGIN
		IF (i>0) THEN select_section_images = select_section_images || ',';
		execute procedure select_images(:ss) returning_values (:ssi);
		select_section_images = select_section_images || ssi;
		i = i+1;
	    END
	suspend;
    END !!

CREATE PROCEDURE select_section (ss_id int)
    RETURNS (select_section varchar(32000))
    AS
	DECLARE VARIABLE i integer;
	DECLARE VARIABLE ss integer;
	DECLARE VARIABLE ssi varchar(32000);
	DECLARE VARIABLE ssn varchar(100);
    BEGIN
	select_section = '';
	i = 0;
	FOR select subsection_id,subsection_name from subsection_tbl where subsection_section_id = :ss_id
	INTO :ss,:ssn
	DO 
	    BEGIN
		IF (i>0) THEN select_section = select_section || ',';
		select_section = select_section || :ss || ',' || :ssn;
		i = i+1;
	    END
	suspend;
    END !!
SET TERM ; !!

