#!/usr/bin/perl
#
# Table handler
#
# (c) 1995 Globewide Network Academy
#
# This software is distributed under the terms of the GNU Public License.
#
# THIS FILE IS OBSOLETE AND EXISTS ONLY FOR BACKWARD COMPATIBILITY
#
# This is the driver to create text database files which are compatible
# with the /rdb software produced by Revolutionary Software (ejs@rsw.com)
#
# In fact this is an obsolete file that is a wrapper for the 
# 
# DBStorage::RDB perl modules
#
# The file format is
#
# field1 (tab) field2
# ------ (tab) ------
# value1 (tab) value2


#  &gna_rdb_open - Opens an rdb file
#  &gna_rdb_read - Reads an entries in an rdb file
#  &gna_rdb_close - Closes an rdb file

#  &gna_rdb_append - Appends to an rdb file
#  &gna_rdb_delete - Deletes rows from an rdb file
#  &gna_rdb_delete_by_key - Replace by key from an rdb file
#  &gna_rdb_replace - Replace by condition from an rdb file
#  &gna_rdb_replace_by_key - Replace by key from an rdb file

#  &gna_rdb_count_subtopics - Count subtopic instances

#  &gna_rdb_edit 

require 'gna-config.pl';
use DBstorage::RDB;

$ENV{'RDB'} = $config{'rdb_dir'};
$ENV{'PATH'} .= ":" . $ENV{'RDB'} . "/bin";
$ENV{'AWK'} = $config{'awk'};

$checkout_program = $config{'co'};
$checkin_program = $config{'ci'};

%fileref_list = ();
$dbh = DBstorage::RDB->new();

$dbh->{'CO'} = $config{'co'};
$dbh->{'CI'} = $config{'ci'};


sub gna_rdb_open {
    local($filehandle, $filename, *fields, *type) = @_;
    local($return_val);
    local($file) = DBstorage::RDB->new();
    $fileref_list{$filehandle} = $file; 
    $return_val = $file->open($filename, $filehandle);
    @fields = $file->fields();
    $type{'type'} = $file->type();
    return $return_val;
}

sub gna_rdb_read {
    local ($filehandle, *fields, *f) = @_;
    return $fileref_list{$filehandle}->read(\%f);
}



sub gna_rdb_close {
    local ($filehandle) = @_;
    my($local_value) = $fileref_list{$filehandle}->close();
    undef($fileref_list{$filehandle});
    return $local_value;
}
    
sub gna_rdb_append {
    local($file, %inarray) = @_;
    &gna_rdb_append_by_array($file, *inarray);
}

sub gna_rdb_attrib {
    local($file, *type, *fields) = @_;
    %type = $dbh->attrib($file);
    @fields = @{$type{'fields'}};
}

sub gna_rdb_append_by_array {
    local ($file, *inarray) = @_;
    $dbh->append($file, \%inarray);
}


sub gna_rdb_replace_by_array {
    local ($table, *keys, *replace_values, $replace_all,
	   *cookie) = @_;
    $dbh->replace($table, \%keys, \%replace_values, $replace_all);
}


sub gna_rdb_replace_regexp_by_array {
    local ($filename, *keys, *replace_values, $replace_all) = @_;
    $dbh->replace_regexp($filename, \%keys, \%replace_values, $replace_all);
}

sub gna_rdb_delete_by_array {
    local ($filename, *keys, $delete_all) = @_;
    local (%type, @fields, $_);
    $dbh->delete($filename, \%keys, $delete_all);
}


sub gna_rdb_checkin {
    local ($filename, $options, $message) = @_;
    `echo '$message' | $checkin_program $options $filename 2> /dev/null`;
}

sub gna_rdb_checkout {
    local ($filename, $options) = @_;
    `$checkout_program $options $filename 2> /dev/null`;
}

sub gna_rdb_checkin_command {
    return $dbh->checkin(@_);
}

sub gna_rdb_checkout_command {
    return $dbh->checkout($filename, $options);
}

sub gna_rdb_commit {
    my ($filename, $newfilename) = @_;
    $dbh->commit($filename, $newfilename);

}

sub gna_rdb_get_nth {
    local($filename, *last, $record, *found) = @_;
    return $dbh->get_nth($filename, $record, \%found, \$last);
}

sub gna_rdb_find {
    local ($filename, *last, *key, *found) = @_;
    local ($dbh) = DBstorage::RDB->new();
    return $dbh->find($filename, \%key, \%found, \$last);
}


sub gna_rdb_table_header {
    local($header, $return_value);
    $header = join("\t", @_);
    $return_value .= $header;
    $return_value .= "\n";
    $header =~ s/\S/\-/g;
    $return_value .= $header;
    $return_value .= "\n";
    return $return_value;
}


sub gna_rdb_count_subtopics {
    local ($input, $topic_field, $new_field, $separator, $prefix, 
	   $new_date, *counter, *new) = @_;
    if ($prefix ne "") {
	$prefix .= $separator;
    }
    local ($prefix_length) = length($prefix);
    local (*fields, *f);
    &gna_rdb_open(COUNT_FILE, $input, *fields);
    while(&gna_rdb_read(COUNT_FILE, *fields, *f)) {
	($item, $date_added) = @f{$topic_field, $new_field};
	# Get the first tag after the semicolon
	if ($item =~ /^$prefix/) {
	$semicolon_pos = index($item, $separator, $prefix_length+1);
	$_ =  ($semicolon_pos == -1) ?
	    substr($item, $prefix_length) :
		substr($item, $prefix_length, 
		       $semicolon_pos - $prefix_length);
	$counter{$_}++;
	$date_added ne "" && 
	    $date_added >= $new_date
		&& $new{$_}++;
    }
    }
    &gna_rdb_close("COUNT_FILE");
}

sub gna_rdb_boolean_search_string {
    local ($field, $search_string) = @_;
    local ($_, $return_value);
    local($implicit) = 0;
    foreach (split(/([\s\(\)]+)/, $search_string)) {
	if (/^[\s*\(\)]+$/) {
    if ($implicit) {
   $return_value .= " && ";
   $implicit = 0;
} else {
	    $return_value .= $_;
}	} elsif (/^and$/i) {
	    $return_value .= "  && ";
	    $implicit = 0;
	} elsif (/^or$/i) {
	    $return_value .= " || ";
	    $implicit = 0;
	} elsif (/^not$/i) {
	    $return_value .= " ! ";
	    $implicit = 0;
	} else {
	    s/([A-Z])/\[\l\1\u\1\]/ig;
	    $return_value = " $field ~ /$_/ ";
	    $implicit = 1;
	}
    }
return $return_value;
}

1;
