#!/usr/bin/perl
#
# Copyright (c) 1995-1997 - Globewide Network Academy
#
# This library is distributed under the terms of the Library GNU Public
# License.


$CODE_DIR = "/var/local/gna/uu-gna/forms";
$TABLE_DIR = "/var/local/gna/uu-gna/tables";
push (@INC, $CODE_DIR);

require 'gna-lib.pl';
require 'gna-fill-form.pl';

use CGI qw(:cgi-lib);
use DBstorage::RDB;

%default_params = ("scan_marker", "*",
		   "scan_header_marker", "Scan all records",
		   "append_marker", "Append record",
		   "search_marker", "Search record",
		   "submit_append_marker", "Do append",
		   "submit_search_marker", "Do search",
		   "submit_form_marker", "Do it",
                   "scan_page_size", 0,
		   "storage", DBstorage::RDB->new());

sub gna_rdb_edit {
    local($table, $template_file, *keycols, 
	  *scancols, *attrib, *params) = @_;
    local ($_);
    foreach (keys %default_params) {
	($params{$_} eq "") &&
	    ($params{$_} = $default_params{$_});
    }
    local ($scan_table) = $params{'scan_table'} eq "" ? 
	$table : $params{'scan_table'};

    my($dbh) = $params{'storage'};

    defined(%in) || &ReadParse(*in);


    if ($in{'RDBscan_page_size'} != 0) {
        $params{'scan_page_size'} = $in{'RDBscan_page_size'};
   }
    if ($params{'scan_page_size'} != 0 &&
	$in{'RDBscan_page_start'} < 1) {
	$in{'RDBscan_page_start'} = 1;
    }

 
    $template_file ne "" && require $template_file;
    ($action, $record, $last) = @in{"RDBaction", "RDBrecord", "RDBlast"};

    $script = $ENV{'SCRIPT_NAME'} . "?";
    $script .= "RDBdate=";
    $script .= &gna_rdb_edit_get_time;
    $script .= "&";

    foreach (keys %attrib) {
	$script .= "$_=$attrib{$_}&";
    } 

    
# w is for write permission
# a is for append permission
# d is for delete permission

    $permission = defined (&gna_rdb_edit_permissions) ? 
	&gna_rdb_edit_permissions : "wad";
    $permission{"write"} = ($permission =~ /w/);
	$permission{'append'} = ($permission =~ /a/);
	$permission{'delete'} = ($permission =~ /d/);

    print &PrintHeader;

    print $params{'page_header'};

#
# Note that the switches between %f and %in are solely for backward 
# compatibility.  In the new regime, the %in associative array is passed
# to the procedure
#
# In the future, we should perform the switches between %f and %in only when
# we note an old version.
#
    %f= %in;

    if ($action eq "do_append" && $permission{"append"}) {
	defined (&gna_rdb_edit_process_append) &&
	    &gna_rdb_edit_process_append(*f);

	$dbh->append($table, \%f);

	defined (&gna_rdb_edit_postprocess_append) &&
	    &gna_rdb_edit_postprocess_append(*f);

	$action="find_key_only";
    %in = %f;
    } elsif ($action eq "do_replace" && $permission{"write"}) {
	defined (&gna_rdb_edit_process_replace) &&
	    &gna_rdb_edit_process_replace(*f);
	%in = %f;
						
	foreach (@keycols) {
	    $keys{$_} = $in{"$_.old"};
	}
	$dbh->replace($table, \%keys, \%f, 0);

	defined (&gna_rdb_edit_postprocess_replace) &&
	    &gna_rdb_edit_postprocess_replace(*f);

	$action = "find_key_only";
            %in = %f;
    } elsif ($action eq "do_delete" && $permission{"delete"}) {
	defined (&gna_rdb_edit_process_delete) &&
	    &gna_rdb_edit_process_delete(*f);
	%keys = "";
	foreach (@keycols) {
	    $keys{$_} = $in{"$_.old"};
	}
	$dbh->delete($table, \%keys);

	defined (&gna_rdb_edit_postprocess_delete) &&
	    &gna_rdb_edit_postprocess_delete(*f);
	$last--;
	if ($record > $last) {
	    $record = $last;
	}
	$action="";
        %in = %f;
    } elsif ($action eq "do_search") {
	&gna_rdb_edit_scan($dbh, \%in, $connector, $type, $case);
    } elsif (!-r $table) {
	&gna_rdb_edit_show_form($template_file, \%in, "append");
	return;
    };


    if ($action eq "append") {
	&gna_rdb_edit_show_form($template_file, \%in, "append");
	return;
    } elsif ($action eq "search") {
	&gna_rdb_edit_show_form($template_file, \%in, "search");
	return;
    } elsif ($action eq "scan" || ($record == 0 && $action eq "")) {
	&gna_rdb_edit_scan($dbh);
	return;
    } elsif ($action eq "find_key_only") {
	(@key{@keycols}) = (@in{@keycols});
	$record = $dbh->find($scan_table, \%key, \%found, \$last);
    } elsif ($action eq "find") {
	foreach (keys %in) {
	    if (!/^RDB/) {
		$key{$_} = $in{$_};
	    }
	}
	$record = $dbh->find($scan_table, \%key, \%found, \$last);
    } elsif ($action eq "last") {
	$dbh->open($scan_table, "FILE") || die;
	while ($dbh->read(\%found)) {
	    $last++; 
	}
	$dbh->close();
	$record = $last;
    } else {
	$record = $dbh->get_nth($scan_table, $record, \%found, \$last);
    }

    $record ?
	&gna_rdb_edit_show_form($template_file, \%found, "replace") :
	    print "Cannot find record $record";
}

sub gna_rdb_edit_show_form {
    local($tempate_file, $fref, $action) = @_;
    my (%insert);
    local($_, $next, $prev);
    my($noedit);
    $insert{'header'} = "<TITLE>Table: $table</TITLE>";

    if ($action eq "replace") {
	$next=$record+1;
	$prev=$record-1;	# 

	($record==$last) && ($next=1);
	($record==1) && ($prev=$last);

	$insert{'top'} = "Record $record of $last\n<hr>\n";

    
	if ($menu_hide != 1 && !$params{"menu_hide"}) {
	    $insert{'top'} .= "
<A HREF=\"${script}RDBaction=scan#record$record\">Scan</a> 
<A HREF=\"${script}RDBaction=search\">Search</a> 
<A HREF=\"${script}RDBrecord=1\">First</a> 
<A HREF=\"${script}RDBrecord=$prev\">Previous</a>
<A HREF=\"${script}RDBrecord=$next\">Next</a>
<A HREF=\"${script}RDBrecord=$last\">Last</a>";
	}


        $permission{"append"} &&
	    ($insert{'top'} .= " <A HREF=\"". $script . 
	     "RDBaction=append\">Append</a>");

        $insert{'top'} .= "<HR>\n";

        if ($permission{"write"} || $permission{"delete"}) {
	    $insert{'top'} .= "<FORM METHOD=POST>
<INPUT TYPE=hidden NAME=RDBrecord VALUE=$record>
<INPUT TYPE=hidden NAME=RDBlast VALUE=$last>
";

            foreach (keys %attrib) {
		$insert{'top'} .= 
		    "<INPUT TYPE=\"hidden\" NAME=\"$_\" VALUE=\"$attrib{$_}\">";
            }

	    foreach (@keycols) {
		$insert{'top'} .= '<input type="hidden" name="'. $_ . '.old" value="'.
		    &gna_entity_quote($f{$_}) . '">'. "\n";
	    }		 
	    $insert{'bottom'} .= "<p>";
	    $permission{"write"} && ($insert{'bottom'} .=
				     '<input type="radio" name="RDBaction" value="do_replace" CHECKED>Replace');
	    $permission{"delete"} && ($insert{'bottom'} .=
				      '<input type="radio" name="RDBaction" value="do_delete">Delete');
	    $insert{'bottom'} .= "<br>\n" 
		. '<input type="submit" name="RDBsubmit" value="'. 
		    $params{'submit_form_marker'} . '">'. '</FORM>';
	    $noedit = 0;
	} else {
	    $noedit=1;
	}
    } elsif ($action eq "append") {
	(!$permission{"append"}) && exit;
	$insert{'top'} = "<hr>";

	if (!$params{"menu_hide"}) { 
	    $insert{'top'} .= "<A HREF=\"${script}RDBaction=scan\">Scan</a>
<hr>
";
	}
	if ($permission{"append"}) {
	    $insert{'top'} .= "Appending record<br>
<FORM METHOD=POST>
<INPUT type=hidden name=RDBaction value=do_append>";
	    foreach (keys %attrib) {
		$insert{'top'} .= '<INPUT TYPE="hidden" NAME="' .
		    $_ . '" VALUE="' .
			$attrib{$_} . '">';
	    }

	    $insert{'bottom'} = "<hr>
<input type=submit name=RDBsubmit value=\"$params{'submit_append_marker'}\">
</FORM>
";
	}
    } elsif ($action eq "search") {
	$insert{'top'} = "<hr>";

	if (!$params{"menu_hide"}) { 
	    $insert{'top'} .= "<A HREF=\"${script}RDBaction=scan\">Scan</a>
<hr>
";
	}
	$insert{'top'} .= "Search record<br>
<FORM METHOD=POST>
<INPUT type=hidden name=RDBaction value=do_search>";
	foreach (keys %attrib) {
	    $insert{'top'} .= '<INPUT TYPE=hidden NAME="' .
		$_ . '" VALUE="' .
		    $attrib{$_} . '">';
	}

	$insert{'bottom'} = "<hr>
<input type=submit name=RDBsubmit value=\"$params{'submit_search_marker'}\">
</FORM>
";
    }

    if (defined (&gna_rdb_edit_form_with_inserts)) {
	print &gna_rdb_edit_form_with_inserts($fref, \%params,
					  \%insert, $noedit); # 
    } else { 
	local(%f) = %{$fref};
	print $insert{'header'};
	print $insert{'top'};
	if (!defined($params{'form_file'})) {
	    (defined (&gna_rdb_edit_print_form) && $noedit==0) && 
		&gna_rdb_edit_print_form(*f);
	    (defined (&gna_rdb_edit_print_form_noedit) && $noedit==1) && 
		&gna_rdb_edit_print_form_noedit(*f);
	} else {
	    defined (&gna_rdb_edit_process_print_form) &&
		&gna_rdb_edit_process_print_form(*f);
	    print &gna_fill_form($params{'form_file'}, *f, $noedit);
	}
	print $insert{'bottom'};
    }
    &gna_rdb_edit_print_ack;
}


if (!defined (&gna_rdb_edit_print_scan_line) && 
    !defined (&gna_rdb_edit_print_scan_line1)) {
   sub gna_rdb_edit_print_scan_line {
	print join("   ", @f{@scancols}) , "<br>";
   };
}

sub gna_rdb_edit_scan {
    my ($dbh, $keyref) = @_;
  
    local (%f); # Using my is incompatible with the use of namespaces

    $dbh->open($scan_table, "FILE") || die;
    (@scancols == 0) &&	(@scancols = @fields);
  
    print "<br><a href=\"${script}RDBaction=scan\">$params{'scan_header_marker'}</a>";
    print "<br><a href=\"${script}RDBaction=search\">$params{'search_marker'}</a>";

    $permission{"append"} && print "<br><A HREF=\"" , $script, 
	"RDBaction=append\">$params{'append_marker'}</A>";
    print "<p>";
    

    defined (&gna_rdb_edit_print_scan_header) &&
	&gna_rdb_edit_print_scan_header;
    defined (&gna_rdb_edit_print_scan_header) ||
	print join("   ", @scancols) , "<hr>";

    $j = 1;

loop:
    while ($dbh->read(\%f)) {
	if ($params{'scan_page_size'} == 0 ||
	    ($in{'RDBscan_page_start'} <= $j &&
	     $j < $in{'RDBscan_page_start'} + $params{'scan_page_size'})) {

	    if ($keyref ne "") {
		my($key);
		foreach $key (keys %{$keyref}) {
		    if ($key !~ /^RDB/ && $keyref->{$key}  !~ /^\s*$/) {
			if (		    $f{$key} !~ /$keyref->{$key}/i) {
			    next loop;
			}
		    }
		}
		
	    }
	    $href = $script;
	    $href .= "RDBaction=find";
	    foreach (@keycols) {
		$href .= "&$_=" . &gna_htquote($f{$_});
	    }

	    if(defined(&gna_rdb_edit_print_scan_line1)) {
		&gna_rdb_edit_print_scan_line1("record$j", $href, *f);
	    } else {
		print "<A name=record$j HREF=\"$href\">", $params{'scan_marker'}, '</A> ';
		&gna_rdb_edit_print_scan_line(*f);
		print "\n";
	    }
	}
	$j++;
    }

    $dbh->close();
    
    defined (&gna_rdb_edit_print_scan_footer) &&
	&gna_rdb_edit_print_scan_footer;

    if ($params{'scan_page_size'} > 0) {
	my ($number_of_pages) = int(($j-1)/$params{'scan_page_size'}) + 1;
	my ($page_start) = $in{'RDBscan_page_start'};
	my ($page_size) = $params{'scan_page_size'};
	my ($page_prev_start) = $page_start - $page_size;
	my ($page_next_start) = $page_start + $page_size;
	my ($page_cur_page) = int ($page_start / $page_size) + 1;
	my ($i);
	my($script_root) = $script;
        print "<center>";

	foreach (keys %in) {
            if ($_ ne "RDBaction" && $_ ne "RDBscan_page_size" &&
                $_ ne "RDBscan_page_start") {
             $script_root .= "$_=" . &gna_cgi_quote($in{$_}) . "&";
            }
        }

	if ($page_prev_start > 0) {
	    print "<a href=${script_root}RDBaction=scan&RDBscan_page_size=${page_size}&RDBscan_page_start=${page_prev_start}>[Prev Page]</a>";
	}
	foreach $i (1..$number_of_pages) {
            my ($page_link_start) = 
                ($i-1) * $page_size + 1;
		    print " ";
            if ($i == $page_cur_page) {
                  print "<b>";
            } else {
        	    print "<a href=${script_root}RDBaction=scan&RDBscan_page_size=${page_size}&RDBscan_page_start=${page_link_start}>";
}
	    print "[$i]";
            if ($i == $page_cur_page) {
                  print "</b>";
            } else {
	print "</a>";
}
print " ";

	}

	if ($page_next_start <= $j) {
	    print "<a href=${script_root}RDBaction=scan&RDBscan_page_size=${page_size}&RDBscan_page_start=${page_next_start}>[Next Page]</a>";
	}
        print "</center>";
    }
    
    &gna_rdb_edit_print_ack;
    print $params{"page_footer"};
}


sub gna_rdb_edit_print_ack {
    print <<EOP;
<p>
This form is produced by 
<a href="http://admin.gnacademy.org:8001/HyperNews/get/tech/dbedit.html">DBedit
</a>, a product of the <a href=http://www.gnacademy.org/>Globewide Network 
Academy</a>.
EOP
}

sub gna_rdb_edit_print_yn {
    local($header, $name, $checked) = @_;
    if ($checked =~ /^[Yy]/) {
	$checked = "Yes";
    } elsif ($checked =~ /^[Nn]/) {
	$checked = "No";
    }
    &gna_rdb_edit_print_radio($header, $name, $checked, "Yes", "No");
}

sub gna_rdb_edit_print_radio {
    local($header, $name, $checked, @values) = @_;
    print $header;
    foreach (@values) {
	print '<input type="radio" name="' , $name , '" value="', $_ , '" ';
	$checked eq $_ && print "CHECKED";

	print ">", $_ , ' ';
    }
    print "<br>";
}

sub gna_rdb_edit_print_radio_button {
    local($name, $value, $checked, $description) = @_;
    print '<input type="radio" name="', $name, '" value="', $value, '" ';
    $checked eq $value && print "CHECKED";
    print ">", $description, '<br>', "\n";
}

sub gna_rdb_edit_print_select {
    local($name, $value, @options) = @_;
    local($_);
    print '<select name=', $name, ">\n";
    foreach (@options) {
         print '<option ', $value eq $_ ? ' selected ' : '', '>', $_, "\n";
    }
    print "</select>\n";
}


sub gna_rdb_edit_print_date_box {
    local($header, $name, $value) = @_;
    print $header , '<input name="' , $name , '" value="' , $value , '" size=8 maxlength=8>';
}

sub gna_rdb_edit_date_box {
    local($name, $value) = @_;
    return join("", '<input name="' , $name , '" value="' , $value , '" size=8 maxlength=8>');
}

sub gna_rdb_edit_process_file {
    local($file, *in, $tag) = @_;
    if ($action eq "do_replace" || $action eq "do_append"
	&& $in{$tag} ne "") {
	    &gna_rdb_checkout($file, "-l");
	    open(FILE, ">$file");
	    print FILE $in{$tag};
	    close FILE;
	    &gna_rdb_checkin($file, "-u");
	}

	if  (-e $file) {
	    $in{$tag} = `cat $file`;
	}
}

sub gna_rdb_edit_get_time {
    return &gna_get_time;
}


sub gna_rdb_edit_show_table {
    local($table, $string, $input_script, @keys) = @_;
    local($output) = "";
    local(*FILE, *f, *fields);
    local($href, $_);
    my ($dbh) = DBstorage::RDB->new();
    $dbh->open($table, FILE);
    while($dbh->read(\%f)) {
	$href = $input_script . "?RDBaction=find";
	foreach(@keys) {
	    $href .=  "&" . "$_" . "=" . &gna_cgi_quote($f{$_});
	}
	local($substring) = $string;
	$substring =~ s/%%dbedit_edit_href%%/$href/g;
	foreach (keys %f) {
	    $substring =~ s/%%$_%%/$f{$_}/g;
	}
	    $output .= $substring;
    }
    $dbh->close();
    return ($output);
}

1;
