#!/usr/bin/perl
# Various subroutines for CGI scripts
#
# Copyright (c) 1995 - Globewide Network Academy
#
# This library is distributed under the terms of the Library GNU Public 
# License.  

# Included in this package

#  &gna_send_mail
#  &gna_send_file
#  &gna_send_url
#  &gna_send_mail_replyto
#  &gna_send_file_replyto
#  &gna_send_url_replyto

#  &gna_get_id - Given a file, it returns the current id, and then increments
#                the id number.
#  &gna_change_passwd - Edits a passwd file
#  &gna_print_header - Prints the GNA header

#  Routines to handle time
#  &gna_get_date
#  &gna_get_date_yyyymmdd
#  &gna_compute_date
#  &gna_wordwrap - Do wordwrap
#  &gna_extract_email - Extract an e-mail address from a string
#  &gna_htquote - Converts a string into something that is cgi-able

#package "gna-lib";
require "timelocal.pl";
require 'gna-config.pl';



# Routines to handle mail


sub gna_send_mail {
   local($from, $to, $subject, $message) = @_;
   &gna_send_mail_replyto($from, $to, $from, $subject, $message);
}

sub gna_send_file {
   local($from, $to, $subject, $filename) = @_;
   &gna_send_file_replyto($from, $to, $from, $subject, $filename);
}

sub gna_send_url {
    local($from, $to, $subject, $url) = @_;
    &gna_send_url_replyto($from, $to, $from, $subject, $url);
}

sub gna_send_mail_replyto {
   local($from, $to, $reply_to, $subject, $message) = @_;
   $errors_to = ($config{'bounce_address'} ne "") ?
       $config{'bounce_address'} : $from;
   &gna_send_mail_with_headers({"From"=>$from,
				"To"=>$to,
				"Reply-To"=>$reply_to,
				"Errors-To"=>$errors_to,
				"Subject"=>$subject},
			       $message);
}

sub gna_send_mail_with_headers {
    local($headerref, $message) = @_;
    local($header);
    local(%headers) = %{$headerref};
    open(MAIL, "|$config{'sendmail'}") || die "sending-mail: $1\n";
    foreach $header (keys %headers) {
   print MAIL <<EOM;
${header}: $headers{$header}
EOM
}
    print MAIL <<EOM;

$message

.
EOM
   close(MAIL);
}

sub gna_send_file_replyto {
   local($from, $to, $reply_to, $subject, $filename) = @_;
   $errors_to = ($config{'bounce_address'} ne "") ?
       $config{'bounce_address'} : $from;

   open(MAIL, "|$config{'sendmail'}") || die "sending-mail: $1\n";
   print MAIL <<EOM;
From: $from
To: $to
Reply-To: $reply_to
Errors-To: $errors_to
Subject: $subject
EOM
   open(FILE, "<$filename") || die "couldn't open ($filename): $!\n";
   while (<FILE>) {
       print MAIL;
   }
   close(FILE);
   print MAIL "\n\n.\n";
   close(MAIL);
}

sub gna_send_url_replyto {
   local($from, $to, $reply_to, $subject, $url) = @_;
   $errors_to = ($config{'bounce_address'} ne "") ?
       $config{'bounce_address'} : $from;
   open(MAIL, "| $config{'sendmail'}") || die "sending-mail: $1\n";
   print MAIL <<EOM;
From: $from
To: $to
Reply-To: $reply_to
Errors-To: $errors_to
Subject: $subject
EOM

    print MAIL `$config{'web_command'} $url`;
   print MAIL "\n\n.\n";
   close(MAIL);
}

# USE OF GNA_GET_DATE IS DISCOURAGED.  USE GNA_GET_DATE_YYYYMMDD INSTEAD
# FIELDS IN YYYYMMDD FORMAT CAN BE SORTED EASILY

sub gna_get_date {
    @MofY = ('January', 'February', 'March', 'April', 'May', 
             'June', 'July', 'August', 'September', 'October', 
             'November', 'December');
    local ($sec, $min, $hour, $mday, $mon, $year) = gmtime(time);
    $year += 1900;
    return sprintf("%d %s %d", $year, @MofY[$mon], $mday);
}

sub gna_get_date_yyyymmdd {
    local ($sec, $min, $hour, $mday, $mon, $year) = gmtime(time);
    $year += 1900;
    $mon++;
    return ($year * 10000 + $mon * 100 + $mday);
}

sub gna_get_time {
    $date = &gna_get_date_yyyymmdd;
    local ($sec, $min, $hour) = gmtime(time);
    return sprintf("%06d%02d%02d%02d", $date, $hour, $min, $sec);
}

sub gna_compute_date {
    local ($date, $difference) = @_;
    local ($year, $mon, $mday, @timearray);
    $mday = $date % 100;
    $date -= $mday;
    $date /= 100;
    $mon = $date % 100;
    $date -= $mon;
    $date /= 100;
    $year = $date;
    $mon--;
    $year -= 1900;
    $gmtime = &timegm(0, 0, 0, $mday, $mon, $year);
    $gmtime += $difference * 24 * 60 * 60;
    ($sec, $min, $hour, $mday, $mon, $year) = gmtime($gmtime);
    $year += 1900;
    $mon++;
    return ($year * 10000 + $mon * 100 + $mday);
}

sub gna_get_id {
    local($idfile) = @_;
    local($id, $head, $tail);

# Open file and get number
    open(IDFILE, $idfile);
    while (<IDFILE>) {
	/^(\S+)/ && do {$id = $1; last;};
    }
    close(IDFILE);

    $id eq "" && do {$id = "1";};


# Increment pid
    $head = ""; $tail = $id;
    $id =~ /^(.*-)([a-zA-Z]*[0-9]*)$/ && do {
	$head = $1; $tail=$2;
    };
    ++$tail;
    
    open(IDFILE, ">$idfile") || die "Unable to open current.pid file";
    print IDFILE "$head$tail\n";
    close(IDFILE);
    return ($id);
}

# Backward compatibility 
sub gna_htquote {
    local($_) = @_;
    return &gna_cgi_quote($_);
}

sub gna_cgi_quote {
    local($_) = @_;
     s/\%/%25/g;
     s/\+/%2b/g;
    s/ /%20/g;
     s/&/%26/g;
     s/</%3c/g;
     s/>/%3e/g;
    s/\;/%3b/g;
     s/!/%41/g;
     s/#/%23/g;
    s/\"/%22/g;

    s/([\x00-\x1f]|[\x80-\xff])/"%" . sprintf("%x", ord($1)) /ge;

# Next line not strictly necessary but may break some browsers if not done
    s/\//%2f/g;
    return $_;
}

sub gna_entity_quote {
    local ($_) = @_;
    s/\&/&amp\;/g;
    s/\>/&gt\;/g;
    s/\</&lt\;/g;
    s/\"/&quot\;/g;

    return $_;
}

sub gna_change_passwd {
    local($filename, $username, $password) = @_;
    local($tmpfile) = "/tmp/passwd.$$";

    if ($gna_change_passwd_seeded != 1) {
	srand(time|$$);
	$gna_change_passwd_seeded = 1;
    }

    open (PASSWD, $filename);
    open (TMPFILE, ">$tmpfile") || die "Unable to open tmp file";

    $i1 = rand(64) + 64;
    $i2 = rand(64) + 64;
    $salt = pack("cc", $i1, $i2);
    $enpass = crypt($password, $salt);

    $found = 0;
    while(<PASSWD>) {
	/^$username:/ && do {
	    print TMPFILE "$username:$enpass\n";
	    $found = 1;
	    next;
	};
	print TMPFILE;
    }

    if ($found != 1) {
	print TMPFILE "$username:$enpass\n";
    }
    close TMPFILE;
    close PASSWD;
    `mv $tmpfile $filename`;
}

sub gna_has_passwd {
    local($filename, $username) = @_;
    open (PASSWD, $filename) || die "Password file unable to open";
    $found = 0;
    while(<PASSWD>) {
	/^$username:/ && do {
	    $found = 1;
	    last;
	};
    }
    close (PASSWD);
    return $found;
}

sub gna_passwd_create {
        local($password_file, $mailto, $username, $password,
	      $password_announce_file) = @_;
       &gna_change_passwd($password_file,
			  $username,
			  $password);
	$password_announce_file = $password_announce_file eq "" ?
	    $config{'password_announce_file_default'} :
		$password_announce_file;

	local($pass_announce) = "";
	open (PASSANNOUNCE, $password_announce_file) ||
	    die 'Cannot open password file';
	while (<PASSANNOUNCE>) {
	    $password_announce .= $_;
	}
	close(PASSANNOUNCE);
	$password_announce =~ s/%username/$username/gi;
	$password_announce =~ s/%password/$password/gi;

	&gna_send_mail ($config{'password_address'}, $mailto, 
			"GNA Web Server Password",
			$password_announce);
}

sub gna_print_header {
    local($title, $header, $options) = @_;
    print <<EOP;
<TITLE>$title</title>
<h1><IMG SRC=/uu-gna/admin/emblems/gna-logo-small.gif width=96 height=92> $header</h1>
| <a href=/uu-gna/index.html>GNA Home Page</a> | $options <p>
EOP
}


sub gna_extract_email {
    local($string) = @_;
    local(@nlist) = split(/[\s\<\>]+/, $string);
    foreach (@nlist) {
	/@/	 && do {$string = $_; last;};
    }
    $string =~ s/[\(\)\<\>]//g;
    return $string;
}

sub gna_wordwrap {
    local($indent, $begin, $end, $items) = @_; 
    local($output) = "";
    local($first) = 1;  
    $output = " " x $indent;

    foreach (split(/\\par/, $items)) {
	$item = $_;
	if ($first) {
	    $length = $indent; $first = 0;
	} else {
	    $length = $begin; 
	    $output .= "\n\n";
	    $output .= " " x $begin;
	}
	foreach (split(/\s+/, $item)) {
	    $length += length;
	    $length++;
	    if ($length > $end) {
		$output .= "\n";
		$output .= " " x $begin;
		$output .= "$_ ";
		$length = 1 + $begin + length;
	    } else {
		$output .= "$_ ";
	    }
	}
    }
    return $output;
}

sub gna_print_time {
    ($user,$system,$cuser,$csystem) = times;
    print "Time used: user ", sprintf("%5.2f", $user), "s sys", 
    sprintf("%5.2f", $system), "s cuser", sprintf("%5.2f", $cuser), 
    "s csys", sprintf("%5.2f", $csystem), "s";
}

# ************************************************************************
# Obsolete routines
# The following are obsolete routines which are included solely for 
# compatiblity purposes
# ************************************************************************


# NOTE THE FOLLOWING ROUTINES ARE OBSOLETE AND ARE INCLUDED ONLY FOR
# BACKWARD COMPATIBILITY
#
# USE THE NEW ONES IN gna-rdb.pl TO MANIPULATE /rdb FILES
#
# Routines to read and write files
#  &gna_read_assoc_array
#  &gna_write_assoc_array
#
#  &gna_read_rdb_file - Reads and writes rdb tables into a PERL data structure
#  &gna_write_rdb_file


# THIS ROUTINE IS OBSOLETE, USE gna_rdb_read

sub gna_read_assoc_array {
    local($filename) = @_;
    local(%inarray);
    open (FILE, "$filename");
    while(<FILE>) {
	/^(\S+)\s+(\S.*)$/ && do {$inarray{$1} = $2;};
    }
    close (FILE);
    return %inarray
}

# THIS ROUTINE IS OBSOLETE, USE gna_rdb_append

sub gna_write_assoc_array {
    local($filename, %inarray) = @_;
    open (FILE, ">>$filename") || open (FILE, ">$filename") ||
        die "Cannot open $filename";
    print FILE "\n";
    foreach (sort keys %inarray) {
#	remove forward and trailing space
	$inarray{$_} =~ s/^\s+(.*)/$1/g;
	$inarray{$_} =~ s/(.*)\s+$/$1/g;
	$inarray{$_} =~ s/\s+/ /g;
	print FILE "$_\t$inarray{$_}\n";
    }
    close(FILE);
}

# DO NOT USE INCLUDED ONLY FOR COMPATIBILITY
# THIS ROUTINE IS OBSOLETE, USE gna_rdb_read
# This reads an rdb file into a data structure
# $rdb{'ncols'} is the number of columns
# $rdb{'nrows'} is the number of rows
# $rdb{"col.$i"} is the name of the ith colum
# $rdb{"item.$field.$j"} is the value of the jth row field $field

sub gna_read_rdb_file {
    local($filename) = @_;
    local(%rdb);
    open (FILE, "$filename");

# Read the header
    $_ = <FILE>;
    s/^(.*)\s+$/$1/; # Chop trailing whitespace
    @items = split(/\t/);
    $rdb{'ncols'} = @items;
    for ($i=0; $i < $rdb{'ncols'}; $i++) {
	$rdb{"col.$i"} = $items[$i];
    }

# Skip the line of hyphens
    $header = <FILE>;

# Read in the data
    $rdb{'nrows'} = 0;
    while (<FILE>) {
	s/^(.*)\s+$/$1/; # Chop trailing whitespace
	$header = $_;
	/\S/ && do {
	    @items = split(/\t/, $header);
	    $j = $rdb{'nrows'};
	    $rdb{'nrows'}++;
	    for ($i=0; $i < $rdb{'ncols'}; $i++) {
		$rdb{"item." . $rdb{"col.$i"} . ".$j"} = $items[$i];
	    }
	}
    }
    return %rdb;
}

# DO NOT USE.  THIS ROUTINE IS OBSOLETE.  USE gna_rdb_append  INSTEAD

sub gna_write_rdb_file {
    local($filename, %rdb) = @_;
    open (FILE, ">$filename");

# Write header names
    for ($i=0; $i < $rdb{'ncols'}; $i++) {
	$colname = $rdb{"col.$i"};
	print FILE "$colname\t";
    }
    print FILE "\n";

# Write hyphens
    for ($i=0; $i < $rdb{'ncols'}; $i++) {
	$colsize = length($rdb{"col.$i"});
	for($j=0; $j<$colsize; $j++) {
	    print FILE "-";
	}
	print FILE "\t";
    }
    print FILE "\n";

    for ($j=0; $j < $rdb{'nrows'}; $j++) {
	for($i=0; $i < $rdb{'ncols'}; $i++) {
	    $colname = $rdb{"col.$i"};
	    $search = "item.$colname.$j";
	    $item = $rdb{$search};
	    print FILE "$item\t";
	}
	print FILE "\n";
    }
    close FILE;
}

sub gna_agent_has_tables {
    return ($ENV{'HTTP_USER_AGENT'} =~ /Mozilla/);
}

# WARNING!!!!
# I am not a cryptographer.  The following routines are intended to provide
# an extremely low level of security against nuisance attacks.  YOU SHOULD
# NOT TRUST THEM AT ALL.
#
# Things that could go wrong!!!
#
# 1) Padding at the end of the message
# 2) Bad random number generators
# 3) Perl bugs
#
# I have not seriously tried to attack these routines.

sub gna_crypt_encrypt_fields {
    my($hashref, $fieldref, $encryptor) = @_;
    my ($field);
    if ($encryptor ne "") {
	foreach $field (@{$fieldref}) {
	    $hashref->{$field} =
		&gna_encrypt_string($encryptor, $hashref->{$field});
	    $hashref->{$field} = s/\n//i;
	}
    }
}

sub gna_crypt_decrypt_fields {
    my($hashref, $fieldref, $encryptor) = @_;
    my ($field);
    if ($encryptor ne "") {
	foreach $field (@{$fieldref}) {
	    $hashref->{$field} = 
		&gna_decrypt_string($encryptor, $hashref->{$field});
	}
    }
}

# Attempts to encrypt and decrypt strings using cypher block chaining

sub gna_crypt_encrypt_string {
    my($encryptor, $string) = @_;
    my ($vector, $i);
    my ($block_size) = $encryptor->blocksize();
    my $cipher_block = &gna_crypt_get_initial_vector($block_size);
    my $cipher_text = $cipher_block;

    for ($i = 0; $i < length($string); $i += $block_size) {
	$cipher_block = 
	    $encryptor->encrypt($cipher_block ^ pack("a$block_size", 
					    substr($string, $i, $block_size)));
	$cipher_text .= $cipher_block;
    }
    
    $cipher_text = pack("u", $cipher_text);
    $cipher_text =~ s/\n//gi;
    return $cipher_text;
}


sub gna_crypt_decrypt_string {
    my($encryptor, $string) = @_;
    my ($string1) = unpack("u", $string);
    my ($block_size) = $encryptor->blocksize();
    my ($i);
    my ($prev_cipher_block) = substr($string1, 0, $block_size);

    for ($i = $block_size; $i < length($string1); $i += $block_size) {
	$cipher_block = substr($string1, $i, $block_size);
	$plaintext .= unpack("a$block_size",
			      $encryptor->decrypt($cipher_block)) ^ 
				  $prev_cipher_block;
	$prev_cipher_block = $cipher_block;
    }
    $plaintext =~ s/\0+$//g;
    return $plaintext;
}

# WARNING!!!!  I have NO idea how good Perl's random number generators are

sub gna_crypt_get_initial_vector {
    my($block_size) = @_;
    my (@vector) = ();
    my ($i);
    for ($i = 0; $i < $block_size; $i++) {
	push(@vector, int(rand(256)));
    }
    return pack("C$block_size", @vector);
}

sub gna_hash_to_email_body {
    my($hashref, $encryptor) = @_;
    my ($field, $body, $body_text);
    my (@fields) = keys %{$hashref};
    $body_text = "";
    foreach $field (@fields) {
	$body_text .= "$field\t$hashref->{$field}\n";
    }
    if ($encryptor ne "") {
	$body_text = &gna_crypt_encrypt_string($encryptor, $body_text);
    } 
    $body = "------\n" . pack("u", $body_text);
    return $body;
}

sub gna_email_body_to_hash {
    my($body, $encryptor) = @_;
    my(%f) = ();
    my($line, $field, $in_hash);
    $in_hash = 0;
    $field = "";
    $body_text = "";
    foreach $line (split(/\n/, $body)) {
	if ($in_hash) {
	    $body_text .= $line;
	} else {
	    if ($line =~ /^\-\-\-\-/) {
		$in_hash = 1;
	    }
	}
    }
    
    $body_text = unpack("u", $body_text);
    if ($encryptor ne "") {
	$body_text = &gna_crypt_decrypt_string($encryptor, $body_text);
    } 

    foreach $line (split(/\n/, $body_text)) {
	if ($line =~ /^(\S+)\s*(.*?)$/) {
	    $field = $1;
	    $f{$field} = $2;
	} elsif ($field ne "" && $line =~ /^\s*(.*?)$/) {
	    $f{$field} .= " ";
	    $f{$field} .= $1;
	}
    }

    return \%f;
}

1;
