

sub gna_fill_form {
    local($file, *f, $noedit) = @_;
    local(*FILE, $_);
    open (FILE, $input);
    while (<FILE>) {
     $foo .= $_;
    } 
    close (FILE);
    return &gna_fill_form_string_with_ref($foo, \%f, $noedit);
}

sub gna_fill_form_with_ref {
    my($input, $fref, $noedit) = @_;
    my ($foo) = "";
    local(*FILE, $_);
    open (FILE, $input);
    while (<FILE>) {
     $foo .= $_;
    } 
    close (FILE);

    return &gna_fill_form_string_with_ref($foo, $fref, $noedit);
}

sub gna_fill_form_string {
    local($input, *f, $noedit) = @_;
    return &gna_fill_form_string_with_ref($input, \%f, $noedit);
}

sub gna_fill_form_string_with_ref {
    my($input, $fref, $noedit) = @_;
    local($output) = "";
    while ($input =~ /\<([^\>]*)\>/) {
	$fulltag = $1;
	$output .= $`;
	$input = $';

	($tag, %args) = &split_tag($fulltag);
	defined ($fref->{$args{"NAME"}}), $fref->{$args{"NAME"}}, "<br>\n";


	if (defined ($args{"NAME"}) && defined($fref->{$args{"NAME"}})) {

	    if ($tag eq "INPUT") {
		if ($args{"TYPE"} =~ /^radio/i || 
		    $args{"TYPE"} =~ /^check/i) {
		    if ($fref->{$args{"NAME"}} =~
			/(^|\\0)$args{"VALUE"}($|\\0)/) {
			    $output .= $noedit ? "(x)" :
				"<$fulltag checked>";
		    } else {
			delete $args{"CHECKED"};
			$output .= $noedit ? "( )" :
			    "<" . &make_tag($tag, %args) . ">";
		    }
		} elsif ($args{"TYPE"} !~ /SUBMIT/i &&
			 $args{"TYPE"} !~ /RESET/i) {
		    $args{"VALUE"} = $fref->{$args{"NAME"}};
		    $output .= $noedit ? $args{"VALUE"} :
			"<" . &make_tag($tag, %args) . ">";
		}		# 
	    } elsif ($tag eq "TEXTAREA") {
		$output .= $noedit ? "" : "<$fulltag>";
		$output .= $fref->{$args{'NAME'}};
		
	    } else {		# 
		$output .= "<$fulltag>";
	    }
	} elsif ($args{"CHECKED"} ne "") {
	    delete $args{"CHECKED"};
	    $output .= "<" . &make_tag($tag, %args) . ">";
	} elsif (!($tag eq "FORM" || $tag eq "/FORM" ||
		   $tag eq "HEAD" || $tag eq "/HEAD" ||
		   $tag eq "/BODY" ||
		   ($tag eq "INPUT" && $args{'TYPE'} =~ /SUBMIT/i))) {
	    $output .= "<$fulltag>";
	}
    }

    $output .= $input;
    return $output;
}


sub split_tag {
    local($fulltag)=@_;
    local($tagname,$etc,$var,$quote,$arg,$value,@tagargs);
    undef $etc;
    ($tagname,$etc)=$fulltag=~/\s*(\S+)\s*(.*)$/;
    while ($etc!~/^\s*$/) {
	($arg,$var,$value,$etc)=$etc=~/\s*([^=\s]+)\s*(=)?\s*(\S+)?(.*)$/;
	($value,$etc)=((undef),$value.$etc) unless $var=~/^=$/;
	($quote)=$value=~/^([\"\'])/;
	if ($quote) {
	    if ($value!~/.$quote$/) {
		($_,$etc)=$etc=~/^([^$quote]*)$quote?(.*)$/;
		$value.=$_.$quote;
	    }
	    $value=~s/$quote\s*(.*)\s*$quote$/$1/;
	    $value=~s/\s*$//;
	}
	$arg="\U$arg\E";
	$arg =~ y/a-z/A-Z/;
	push(@tagargs,$arg,$value);
    }
  
    $tagname="\U$tagname\E";
    $tagname =~ y/a-z/A-Z/;
    ($tagname,@tagargs);
}

sub make_tag {
    local($tag, %args) = @_;
    local($_, $output);
    $output = "$tag ";
    foreach (keys %args) {
	$output .= "$_=\"$args{$_}\" ";
    }
    return $output;
}
1;

