#!/usr/bin/perl
# This procedure allows you to edit a file over the web
#
# Copyright &copy; 1995 Globewide Network Academy
#
# This library is distributed under the terms of the Library GNU Public
# License.
#

require 'gna-rdb.pl';
require 'gna-lib.pl';
require 'cgi-lib.pl';
require 'gna-config.pl';

# gna_edit_file
#
# arguments - *params - Parameters
#             *in - Data
#
# Params - filename - name of filename to be edited
#          rows - Number of rows in filename
#          cols - Number of columns for filename
#          default_text - Text is there is no file
#          forward - e-mail address to forward text
#          notify - e-mail address to notify changes

sub gna_edit_file {
    local(*params, *in) = @_;

    $is_html =  ($params{'filename'} =~ /\.html$/);

    print &PrintHeader;
    if ($in{"data"} ne "") {

	$in{"data"} =~ s/\r//g;
	&gna_rdb_checkout($params{'filename'}, "-l");
	open(FILE, ">$params{'filename'}");
	print FILE $in{"data"};
	close(FILE);
	&gna_rdb_checkin($params{'filename'}, "-u", 
			 "Checked in by $ENV{'REMOTE_USER'} -- $params{'log_message'}");
	if ($params{'notify'} ne "") {
	    $docname = &gna_edit_file_get_docname(*params);
	    $message = <<EOP;
The document $docname has been modified by $ENV{'REMOTE_USER'}.

EOP
    ($params{'url'} ne "") && ($message .= <<EOP);
What has changed:
$params{'log_message'}

To see changes, look at:
$params{'url'}
EOP
	    &gna_send_mail($config{'from_address'}, $params{'notify'},
			   "Changed: $docname",
			   $message);
	}

	if ($params{'forward'} ne "") {
	    $docname = &gna_edit_file_get_docname(*params);
	    $message = $in{'data'};
    ($params{'url'} ne "") && ($message .= <<EOP);
To see document, look at:
$params{'url'}
EOP
	    &gna_send_mail($config{'from_address'}, $params{'forward'},
			   "Forwarded: $docname",
			   $message);
	}

    }
    ($params{'rows'} eq "") && ($params{'rows'} = 12);
    ($params{'cols'} eq "") && ($params{'cols'} = 72);



    print <<EOP;
<title>$params{"title"}</title>
$params{'header'}
<hr>
EOP

    if ($in{"data"} eq "") {
	print <<EOP;
<form method=post>
    $params{'form_header'}
<input type=submit value="Save file"><br>
<textarea name="data" rows=$params{'rows'} cols=$params{'cols'}>
EOP
    } elsif (!$is_html) {
	print "<pre>\n";
    }

    if (-e $params{'filename'}) {
	open(FILE, $params{'filename'}) || print "Cannot find file!!!";
	if ($in{"data"} eq "") {
	    while (<FILE>) {
		print &gna_entity_quote($_);
	    }
	} else {
	    while (<FILE>) {
		print $_;
	    }
	}
	close(FILE);
    } else {
	print $params{'default_text'};
    }

    if ($in{"data"} eq "") {
    print <<EOP;
</textarea>
</form>
EOP
} 


if (!$is_html) {
    print "</pre>\n";
}
}

sub gna_edit_file_get_docname {
    local (*params) = @_;
    return $params{'title'} ne "" ? $params{'title'} : 
		$params{'url'} ne "" ? $params{'url'} :
		    $params{'filename'};
}
1;


