#!/usr/bin/perl
# 
# This is a template file for the program dbedit.  It contains a set of 
# procedures which are called when the database is asked to perform 
# certain functions.  
#

# Space for local definitions

# ************************************************************************
#    Set permissions
# ************************************************************************

# &gna_rdb_edit_permissions
# This procedure sets the permission of the database.  It returns a string
# contains zero or more of the following characters
#
#     r - read permission (This flag currently does nothing)
#     w - write permission
#     a - append permission
#     d - delete permission

sub gna_rdb_edit_permissions {
    return "rwad";
}

# ************************************************************************
#    Process database entry
# ************************************************************************

# &gna_rdb_edit_process_append
# &gna_rdb_edit_process_replace
# &gna_rdb_edit_process_delete
#
# These procedures are called when a request to append, replace, or delete
# a database entry is made

sub gna_rdb_edit_process_append {
    local (*f) = @_;
    $f{'customer_address'} =~ s/\n/<br>/gi;
}

sub gna_rdb_edit_process_replace {
    local (*f) = @_;
    $f{'customer_address'} =~ s/\n/<br>/gi;
}

sub gna_rdb_edit_process_delete {
    local (*f) = @_;
}


# ************************************************************************
#    Postprocess database entry
# ************************************************************************

# &gna_rdb_edit_postprocess_append
# &gna_rdb_edit_postprocess_replace
# &gna_rdb_edit_postprocess_delete
#
# These procedures are called after a request to append, replace, or delete
# a database entry is made.  They are typically used to regenerate an
# index

sub gna_rdb_edit_postprocess_append {
    local (*f) = @_;
}

sub gna_rdb_edit_postprocess_replace {
    local (*f) = @_;
}

sub gna_rdb_edit_postprocess_delete {
    local (*f) = @_;
}
    
# ************************************************************************
#    Scan table
# ************************************************************************

# These routines control the display of the scanning table


# &gna_rdb_edit_print_scan_header 
#    Prints the scan table header

sub gna_rdb_edit_print_scan_header {

}

# &gna_rdb_edit_print_scan_line1
#    Prints the scan line

sub gna_rdb_edit_print_scan_line1 {
    local($name, $href, *f) = @_;
    print "<a name=\"$name\" href=\"$href\">(edit) </a>";
    print "$f{'customer_email'} - $f{'customer_amount'}<br>"

}
    
# ************************************************************************
#    Print forms
# ************************************************************************

sub gna_rdb_edit_print_form {
    local(*f) = @_;
    if ($params{'form_type'} eq "input") {
	$f{'customer_address'} =~ s/<br>/\n/gi;
    }
    if ($f{'invoice_number'} eq "") {
	$f{'invoice_number'} = &gna_get_time;
	$f{'date_issued'} = &gna_get_date_yyyymmdd;
    }
    print <<EOP;
<h1><img src="/uu-gna/admin/emblems/gna-logo-small.gif" align=bottom width=96 height=92>Invoice</h1>
EOP
    if ($params{'form_type'} eq "input") {
	print <<EOP;
<p>The purpose of this form is to enable GNA workers to raise an invoice for goods or services provided by the GNA or GNP Ltd.</p>
<p>Please complete the form below and Finance will raise the invoice and send a copy to the customer.</p>
<hr>
<ol>
EOP
} else {
    if ($legal_entity eq "GNA") {
print "Please name checks payable to:<br>
Globewide Network Academy<br>
600 West 26th Street B216<br>
Austin, Texas 78705<br>
UNITED STATES OF AMERICA<p>";
} else {
print "Please name checks payable to:<br>
Globewide Network Publications Ltd.<br>
600 West 26th Street B216<br>
Austin, Texas 78705<br>
UNITED STATES OF AMERICA<p>
Please do address the check to <b>Globewide Network Publications Ltd.</b> and <b>NOT</b> Globewide Network Academy<p>";
}
}
    print &gna_fill_form_string(<<EOP, *f, $params{'form_type'} ne "input");
<em>Invoice Number</em><input type=text size=15 name=invoice_number><br>
<em>Issuer  Name </em><input type=text size=35 maxlength=256 name="issuer_name"><br>
<em>          E-mail </em><input type=text size=25 maxlength=256 name="issuer_email"><br>
<em>Date issued</em><input type=text size=8 maxlength=8 name=date_issued>
</pre>
</li>
<li>Invoice to be raised by:
<input type=radio name=legal_entity value="GNA">GNA
<input type=radio name=legal_entity value="GNP Ltd">GNP Ltd
<input type=radio name=legal_entity value="other">other
</li>
<li>Name and address to which this invoice should be sent: <p><textarea name="customer_address" rows=5 cols=35></textarea> <br>
</p>
</li>
<li>Customer\'s email address: <p><input type=text size=35 maxlength=256 name="customer_email" value="$f{'customer_email'}"> <br>
</p>
</li>
<li>Description of goods and services supplied, including dates: <p><textarea name="description" rows=5 cols=65></textarea> <br>
</p>
</li>
<li>Amount due: <input type=text size=10 maxlength=10 name="amount" value="$f{'amount'}"> </p>
</li>
<li>Date due: <input type=text size=8 maxlength=8 name="date_due" value="$f{'date_due'}"> </p>
</li>
</ol>
<hr>

EOP

if ($params{'form_type'} eq "input") {
    print &gna_fill_form_string(<<EOP, *f, $params{'form_type'} ne "input");
Comments:
<textarea name=comments rows=5 cols=65></textarea><p>
<a href="$ENV{'SCRIPT_NAME'}?form_type=print&invoice_number=$f{'invoice_number'}">Print invoice</a>
EOP
}
print <<EOP
<h5><br>
EOP
}

sub gna_rdb_edit_print_noedit {
    local(*f) = @_;
print <<EOP;
amount $f{'amount'}<br>
customer_email $f{'customer_email'}<br>
legal_entity $f{'legal_entity'}<br>
description:<br>
EOP
    print &gna_wordwrap(0,0,72,$f{'description'});
    print <<EOP;
customer_address:<br>
EOP
    print &gna_wordwrap(0,0,72,$f{'customer_address'});
    print <<EOP;
EOP
}
1;
