#!/usr/bin/perl
# 
# This is a template file for the program dbedit.  It contains a set of 
# procedures which are called when the database is asked to perform 
# certain functions.  
#

# Since this script allows writing of files, be aware of security holes.
# 1) Make sure this script can only write to certain directories

# Space for local definitions

# ************************************************************************
#    Set permissions
# ************************************************************************

# &gna_rdb_edit_permissions
# This procedure sets the permission of the database.  It returns a string
# contains zero or more of the following characters
#
#     r - read permission (This flag currently does nothing)
#     w - write permission
#     a - append permission
#     d - delete permission

sub gna_rdb_edit_permissions {
    if ((defined $params{'administrator'} && $params{'administrator'} eq "") 
	|| $ENV{'REMOTE_USER'} eq $params{'administrator'}) {
	return "rwad";
    }
}

# ************************************************************************
#    Process database entry
# ************************************************************************

# &gna_rdb_edit_process_append
# &gna_rdb_edit_process_replace
# &gna_rdb_edit_process_delete
#
# These procedures are called when a request to append, replace, or delete
# a database entry is made

sub gna_rdb_edit_process_append {
    local (*f) = @_;
}

sub gna_rdb_edit_process_replace {
    local (*f) = @_;
}

sub gna_rdb_edit_process_delete {
    local (*f) = @_;
}
    
# ************************************************************************
#    Scan table
# ************************************************************************

# These routines control the display of the scanning table


# &gna_rdb_edit_print_scan_header 
#    Prints the scan table header

sub gna_rdb_edit_print_scan_header {
}

# &gna_rdb_edit_print_scan_line
#    Prints the scan line

sub gna_rdb_edit_print_scan_line1 {
    local($name, $href, *f) = @_;
    $link = &gna_edit_documents_get_link($f{'document_id'});
    print $f{"document_title"}, "<br>\n",
    "<a href=\"$f{'document_file'}\">(view file)</a>\n",
    "<a name=\"$name\" href=\"$href\">(view information)</a>\n",
     &gna_edit_documents_can_edit_file(*f) ?
	"<a href=\"$link\">(edit file)</a>\n" : "", 
	 "<p>\n";
}
    
# ************************************************************************
#    Print forms
# ************************************************************************

sub gna_rdb_edit_print_form {
    local(*f) = @_;
print <<EOP;
document_id <INPUT NAME="document_id" value="$f{'document_id'}" size=72><br>
document_file <INPUT NAME="document_file" value="$f{'document_file'}" size=72><br>
document_title <INPUT NAME="document_title" value="$f{'document_title'}" size=72><br>
document_notify <INPUT NAME="document_notify" value="$f{'document_notify'}" size=72><br>
editor_list <INPUT NAME="editor_list" value="$f{'editor_list'}" size=72><br>
EOP
}

sub gna_rdb_edit_print_noedit {
    local(*f) = @_;
print <<EOP;
document_file $f{'document_file'}<br>
document_id $f{'document_id'}<br>
document_title $f{'document_title'}<br>
document_notify $f{'document_notify'}<br>
editor_list $f{'editor_list'}<br>
EOP
}

sub gna_edit_documents_edit_file {
    local($table, *in) = @_;
    if (!&gna_edit_documents_can_edit_file(*in)) {
	print  &PrintHeader, <<EOP;
You are not allowed to edit this file
EOP
    exit;
    }

    $key{"document_id"} = $in{'document_id'};
    if (&gna_rdb_find($table, *last, *key, *f)) {
	$params{"filename"} = $file_root . $f{'document_file'};
	$params{"title"} = "Editing $f{'document_title'}";
	$notify_field = $in{'document_notify'} ne "" ?
	    $in{'document_notify'} : $f{'document_notify'};
	$params{"form_header"} = <<EOP;
<input type="checkbox" name="announce_change" value="Yes"> Announce change to
<input name="document_notify" value="$notify_field" size=60><br>
<input type="checkbox" name="forward_document" value="Yes"> Forward document to
<input name="document_forward" value="$notify_field" size=60><br>
Enter description of changes: <br>
<textarea name="log_message" rows=3 cols=72></textarea><br>
<input type="hidden" name="RDBaction" value="edit_file">
<input type="hidden" name="document_id" value="$f{'document_id'}">
EOP

    $params{'rows'} = 66;
    $params{'header'} = <<EOP;
<a href="$ENV{'SCRIPT_NAME'}">Return to documents menu</a><br>
EOP
    $params{'url'} = $url_root . $f{"document_file"};
	$link = &gna_edit_documents_get_link($f{'document_id'});
	$params{'header'} .= ($in{"data"} eq "") ? <<EOP : <<EOQ;
<a href="$params{'url'}">View Document</a><br>
EOP
<a href="$link">Edit Document</a><br>
EOQ

	($in{'announce_change'} eq "Yes") && 
	    ($params{'notify'} = $in{'document_notify'});
	($in{'forward_document'} eq "Yes") &&
	    ($params{'forward'} = $in{'document_forward'});
	$params{'log_message'} = $in{'log_message'};
 	&gna_edit_file(*params, *in);
    } else {
	print &PrintHeader;
	print "Cannot edit file $in{'document_id'}\n";
    }
    exit;
}

sub gna_edit_documents_get_link {
    local($document_id) = @_;
    $time = &gna_rdb_edit_get_time;
    return "$ENV{'SCRIPT_NAME'}?RDBdate=$time&document_id=$document_id&RDBaction=edit_file";
}

sub gna_edit_documents_can_edit_file {
    local(*f) = @_;
    local($_);
    ($f{'editor_list'} =~ /^\s*$/) && return 1;
    foreach (split(/[,\s]+/, $f{'editor_list'})) {
	($ENV{'REMOTE_USER'} eq $_) && return 1;
    }
    return 0;
}
1;
