package DBstorage::SQL;
use DBstorage;
use DBI;

@ISA = qw(DBstorage);

sub new {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = {};
	$self->{'FILEHANDLE'} = undef;
	$self->{'TYPE'} = {};
	$self->{'DBH'} = undef;
	$self->{'STH'} = undef;
	bless ($self, $class);

	if (@_) {$self->connect(@_)};
	return $self;
}

sub connect {
    my $self = shift;
    $self->{'DBH'} = DBI->connect(@_);
}

sub open {
    my $self = shift;
    my $command = shift;

    my $dbh = $self->{'DBH'};
    if ($command !~ /^select/i) {
	$command = "select * from $command;";
    }
    $self->{'STH'} = $dbh->prepare($command);
    $self->{'STH'}->execute();
}

sub dbh {
    my $self = shift;
    return $self->{'DBH'};
}

sub read {
    my $self = shift;
    my $hashref = shift;
    my @rows;
    if ($listref = $self->{'STH'}->fetch()) {
	@{$hashref}{@{$self->{STH}->{NAME}}} =  @{$listref};
	return 1;
    } else {
	return 0;
    }
}

sub close {
    my $self = shift;
    $self->{'STH'}->finish();
}

sub disconnect {
    my $self = shift;
    $self->{'DBH'}->disconnect;
    $self->{'DBH'} = undef;
}

sub fields {
    my $self = shift;
    return @{$self->{'STH'}->{NAME}};
}

sub type {
    my $self = shift;
    return %{$self->{'TYPE'}};
}

sub find {
}

sub get_nth {
}

sub attrib {
}

sub create {
    my $self = shift;
    my $table = shift;
    my $fields = shift;
    my $type = shift;
    my $value;
    my $command = "create table $table (";
    my @field_list;
    foreach $value ($fields) {
	my $field_type = shift $type;
	push (@field_list, "$value $field_type");
    }
    $command .= join(", ", @field_list);
    $command .= ")";
    $self->{'DBH'}->do($command);
}

sub delete {
}

sub append {
    my $self = shift;
    my $table = shift;
    my $hashref = shift;

    my $command = "INSERT INTO $table ";
    my @fields = keys %{$hashref};
    $command .= "(" . join(",", @fields) . ") ";
    foreach $value (@_) {
	$command .= "values (". join (", ", {$hashref}{@fields}) . ") ";
    }
    print $command;
    $self->{'DBH'}->do($command);
}


sub replace {
}

sub commit {
}

1;


