
/* qddb/Utils/query.c
 * Print values of all rows matching the query.  Values are specified in
 * the form AttributeName:width (example: 'Name.First:20').
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

#if defined(USE_TCL)
#include "tcl.h"
#endif

Boolean TCLprint = False;
Boolean DontPrintRows = False;

/* Boolean AllRowMarked _ANSI_ARGS_((InCoreEntry *, RowList *, int *, int));*/
void UnmarkEntry _ANSI_ARGS_((InCoreEntry *));
char *PrintRowInstances _ANSI_ARGS_((Schema *, InCoreEntry *, RowList *));
void PrintRow _ANSI_ARGS_((Schema *, KeyList *, InCoreEntry *, RowList *, char *, int *, int *, int, int *, int));
int PrintKeyList _ANSI_ARGS_((Schema *, KeyList *, char *, char **, int *, int, char **, int, Boolean));
void QueryParseAttribute _ANSI_ARGS_((char *, char **, size_t *));

void main(argc, argv)
    int				argc;
    char			**argv;
{
    Schema			*schema;
    char			Relation[BUFSIZ], Buffer[BUFSIZ], *rel;
    size_t			*AttrWidth, AttrTop = 0, AttrsUsedTop = 0;
    char			**AttrName, **AttrsUsed;
    KeyList			*list, *LastList = NULL;
    char			*SepString = ":", *str;
    int				StartPrint, i;
    size_t			n;
    Boolean			Some = False, Any = False, OnceThrough;
    
    if (argc < 4) {
	fprintf(stderr, "Usage: %s RelationDir [-tcl] [-norows] [-all] \
[-sep SepString] [-any Value] AttributeName Value [AttributeName Value ...] \
-print AttributeName:width [AttributeName:width ...]\n", argv[0]);
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL)
	PANIC("Cannot find relation, please set QDDBDIRS");
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    AttrWidth = (size_t *)Malloc(sizeof(size_t)*argc);
    AttrName  = (char **)Malloc(sizeof(char *)*argc);
    AttrsUsed = (char **)Malloc(sizeof(char *)*argc);
    StartPrint = False;
    LastList = NULL;
    for (i = 2; i < argc; i++) {
	if (strcmp(argv[i], "-print") == 0) {
	    StartPrint = True;
	    continue;
	} else if (strcmp(argv[i], "-sep") == 0) {
            SepString = argv[i+1];
            i++;
            continue;
        } else if (strcmp(argv[i], "-tcl") == 0) {
	    TCLprint = True;
	    continue;
	} else if (strcmp(argv[i], "-norows") == 0) {
	    DontPrintRows = True;
	    continue;
	}
	if (StartPrint == True) {
	    QueryParseAttribute(argv[i], AttrName+AttrTop, AttrWidth+AttrTop);
	    AttrTop++;
	} else {
	    KeyList		*tmplist = NULL;
	    char		*val;
	    Qddb_SearchArg	search_args;

	    if (strcmp(argv[i], "-all") == 0) {
		search_args.UpperExists = 0;
		search_args.LowerExists = 0;
		search_args.Type = ALPHARANGE;
		LastList = Qddb_Search(schema, &search_args, &n, -1);
	    } else {
		if (strcmp(argv[i], "-any") == 0) {
		    Any = True;
		} else if (Qddb_ConvertAttributeNameToNumber(schema, argv[i]) < 0) {
		    fprintf(stderr, "Attribute %s doesn't exist\n", argv[i]);
		    fflush(stderr);
		    exit(1);
		} else
		    AttrsUsed[AttrsUsedTop++] = argv[i];
		if (i+1 >= argc) {
		    fprintf(stderr, "%s: no value specified for %s\n", argv[0], argv[i]);
		    exit(1);
		}
		strcpy(Buffer, argv[i+1]);
		tmplist = NULL;
		OnceThrough = False;
		for (str = Buffer; str != NULL;) {
		    while ((val=strsep(&str,"\t ")) != NULL && *val == '\0');
		    if (val == NULL || val[0] == '\0') {
			fprintf(stderr, "No query specified!");
			exit(1);
		    }
		    search_args.Alpha = val;
		    search_args.Type  = ALPHA;
		    list = Qddb_Search(schema, &search_args, &n, -1);
		    if (Any == False) {
			list = (KeyList *)Qddb_KeyListProcess(schema, list, argv[i],
					    QDDB_KEYLIST_PROC_PRUNE,
					    QDDB_KEYLIST_FLAG_PRUNEBYATTR);
			Some = True;
		    }
		    if (tmplist == NULL && OnceThrough == False) {
			tmplist = list;
			OnceThrough = True;
		    } else {
			tmplist = Qddb_KeyListOp(schema, tmplist, list, 
						 QDDB_KEYLIST_OP_INTERSECTION, 0);
		    }
		}
		if (LastList == NULL) {
		    LastList = tmplist;
		} else {
		    LastList = Qddb_KeyListOp(schema, tmplist, LastList, 
					      QDDB_KEYLIST_OP_INTERSECTION, 0);
		}
	    i++;
	    Any = False;
	    }
	}
    }
    if (AttrsUsedTop > 0) {
	Qddb_PruneArgs		prune_args;

	prune_args.attrs = AttrsUsed;
	prune_args.attr_len = AttrsUsedTop;
	LastList = (KeyList *)Qddb_KeyListProcess(schema, LastList, &prune_args, 
						  QDDB_KEYLIST_PROC_PRUNE,
						  QDDB_KEYLIST_FLAG_PRUNEBYROW);
    }
#if defined(USE_TCL)
    Qddb_RowListQuery(NULL, schema, LastList, SepString, AttrName, AttrWidth, 
		      AttrTop, AttrsUsed, AttrsUsedTop, Any, TCLprint, DontPrintRows,
		      False, False);
#else
    Qddb_RowListQuery(schema, LastList, SepString, AttrName, AttrWidth, 
		      (size_t)AttrTop, AttrsUsed, (size_t)AttrsUsedTop, Any, TCLprint);
#endif
    exit(0);
}

void QueryParseAttribute(arg, attr_name, attr_width)
    char		*arg, **attr_name;
    size_t		*attr_width;
{
    char		*place;

    place = strtok(arg, ":");
    place = strtok(NULL, ":");
    if (place == NULL) {
	*attr_name = arg;
	*attr_width = 0;
	return;
    }
    *attr_name = arg;
    *attr_width = atoi(place);
}


void UnmarkEntry(ThisEntry)
    InCoreEntry			*ThisEntry;
{
    while (ThisEntry->SequenceNumber != 0) {
	ThisEntry->Marked = False;
	ThisEntry++;
    }
}

#if defined(DEBUG)
debug_printlist(list, str)
    KeyList			*list;
    char			*str;
{
    int				i;

    for (i = 0; list != NULL; list = list->next, i++)
	printf("\t(%d,%d,%d,%s),", list->Start, list->Length, list->Attribute, list->Instance);
    printf("\n%s: %d nodes\n", str, i);
}
#endif
