
/* qddb/Utils/query.c
 * Print values of all rows matching the query.  Values are specified in
 * the form AttributeName:width (example: 'Name.First:20').
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int				argc;
    char			**argv;
{
    Schema			*schema;
    char			Relation[BUFSIZ], *rel, *out;
    Entry			ThisEntry = NULL;
    KeyList			Key;
    
    if (argc != 6) {
	fprintf(stderr, "Usage: %s RelationDir Start Length Number Type", argv[0]);
	fprintf(stderr, "\tNote: this program is meant to be used by TCL/TK scripts.\n");
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL)
	PANIC("Cannot find relation\n");
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    Key.Start = atoi(argv[2]);
    Key.Length = atoi(argv[3]);
    Key.Number = atoi(argv[4]);
    Key.Type = atoi(argv[5]);
    Key.next = NULL;
    if (Qddb_ReadEntryByKeyList(-1, Relation, &ThisEntry, &Key, True) != 0) {
	fprintf(stderr, "ERROR: problem reading entry %d %d %d %d\n",
		(int)Key.Start, (int)Key.Length, (int)Key.Number, (int)Key.Type);
	PANIC("ReadEntryByKeyList");
    }
    Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
#ifndef DEBUG
    out = Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_TCLEXTERNAL);
    printf("%s\n", out);
#else
    {
	DataTree **d;
	Entry	 ch;

	d = Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_DATATREE);
	ch = Qddb_Convert(schema, QDDB_ENTRYTYPE_DATATREE, d, QDDB_ENTRYTYPE_EXTERNAL);
	while (*ch != NULL)
	    printf("%s\n", *ch++);
    }
#endif
    exit(0);
}
