
/* qddb/Utils/qnum.c
 * Print number of entries matching the query.  
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void main(argc, argv)
    int				argc;
    char			**argv;
{
    Schema			*schema;
    char			Relation[BUFSIZ], Buffer[BUFSIZ];
    char			*rel;
    int				*AttrWidth, AttrTop = 0, AttrsUsedTop = 0;
    char			**AttrName, **AttrsUsed;
    KeyList			*list, *LastList = NULL;
    char			*str;
    int				StartPrint, i;
    size_t			n, num;
    Boolean			Some = False, Any = False, OnceThrough = False;
    void			QueryParseAttribute();
    
    if (argc < 4) {
	fprintf(stderr, "Usage: %s RelationDir [-any Value] AttributeName Value [AttributeName Value ...]\n",
		argv[0]);
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    rel = Qddb_FindRelation(argv[1]);
    if (rel == NULL) {
	fprintf(stderr, "%s: cannot find relation %s, please set QDDBDIRS\n", argv[0], argv[1]);
	exit(1);
    }
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    AttrWidth = (int *)Malloc(sizeof(int)*argc);
    AttrName  = (char **)Malloc(sizeof(char *)*argc);
    AttrsUsed = (char **)Malloc(sizeof(char *)*argc);
    StartPrint = False;
    LastList = NULL;
    for (i = 2; i < argc; i++) {
	if (StartPrint == True) {
	    QueryParseAttribute(argv[i], AttrName+AttrTop, AttrWidth+AttrTop);
	    AttrTop++;
	} else {
	    KeyList		*tmplist = NULL;
	    char		*val;

	    if (strcmp(argv[i], "-any") == 0) {
		Any = True;
	    } else if (Qddb_ConvertAttributeNameToNumber(schema, argv[i]) < 0) {
		fprintf(stderr, "Attribute %s doesn't exist\n", argv[i]);
		fflush(stderr);
		exit(1);
	    } else
		AttrsUsed[AttrsUsedTop++] = argv[i];
	    strcpy(Buffer, argv[i+1]);
	    tmplist = NULL;
	    for (str = Buffer; str != NULL;) {
		Qddb_SearchArg		arg;

		while ((val=strsep(&str,"\t ")) != NULL && *val == '\0');
		if (val == NULL || val[0] == '\0') {
		    fprintf(stderr, "No query specified!");
		    exit(1);
		}
		arg.Alpha = val;
		arg.Type = ALPHA;
		list = Qddb_Search(schema, &arg, &n, -1);
#if defined(DEBUG)
		fprintf(stderr, "Search done\n");
		fflush(stderr);
#endif
		if (Any == False) {
		    list = (KeyList *)Qddb_KeyListProcess(schema, list, argv[i], QDDB_KEYLIST_PROC_PRUNE,
							  QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    Some = True;
		}
#if defined(DEBUG)
		fprintf(stderr, "Processing done\n");
		fflush(stderr);	
#endif
		if (tmplist == NULL && OnceThrough == False) {
		    tmplist = list;
		    OnceThrough = True;
		} else
		    tmplist = (KeyList *)Qddb_KeyListOp(schema, tmplist, list, 
							QDDB_KEYLIST_OP_INTERSECTION, 0);
#if defined(DEBUG)
		fprintf(stderr, "Intersection done\n");
		fflush(stderr);
#endif
	    }
	    if (LastList == NULL)
		LastList = tmplist;
	    else {
		LastList = (KeyList *)Qddb_KeyListOp(schema, tmplist, LastList, 
							QDDB_KEYLIST_OP_INTERSECTION, 0);
#if defined(DEBUG)
		fprintf(stderr, "Intersection done\n");
		fflush(stderr);
#endif
	    }
	    i++;
	}
    }
    if (Any == False) {
	Qddb_PruneArgs		prune_args;

	prune_args.attrs = AttrsUsed;
	prune_args.attr_len = AttrsUsedTop;
	LastList = (KeyList *)Qddb_KeyListProcess(schema, LastList, &prune_args, QDDB_KEYLIST_PROC_PRUNE,
						  QDDB_KEYLIST_FLAG_PRUNEBYROW);
#if defined(DEBUG)
	fprintf(stderr, "PRUNEBYROW done\n");
	fflush(stderr);
#endif
    }
    num = 0;
    LastList = (KeyList *)Qddb_KeyListProcess(schema, LastList, NULL, QDDB_KEYLIST_PROC_NULLOP,
					  QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
#if defined(DEBUG)
    fprintf(stderr, "DELDUP_SAMEENTRY done\n");
    fflush(stderr);
#endif
    while (LastList != NULL) {
	num++;
	LastList = LastList->next;
    }
    printf("%u\n", (unsigned int)num);
    exit(0);
}

void QueryParseAttribute(arg, attr_name, attr_width)
    char		*arg, **attr_name;
    int			*attr_width;
{
    char		*place;

    place = strtok(arg, ":");
    place = strtok(NULL, ":");
    if (place == NULL) {
	*attr_name = arg;
	*attr_width = 0;
	return;
    }
    *attr_name = arg;
    *attr_width = atoi(place);
}

