
/* qddb/Utils/qcat.c
 * Cat the entire relation.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void PrintKeyList _ANSI_ARGS_((Schema *, KeyList *));

void main(argc, argv)
    int				argc;
    char			**argv;
{
    char			Relation[BUFSIZ], *rel;
    KeyList			*LastList = NULL;
    Schema			*schema;
    
    if (argc < 2) {
	fprintf(stderr, "Usage: qcat RelationDir\n");
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    if ((rel = Qddb_FindRelation(argv[1])) == NULL) {
	fprintf(stderr, "%s: cannot find relation %s\n", argv[0], argv[1]);
	exit(1);
    }
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    LastList = CatRelation(schema, Relation);
    PrintKeyList(schema, LastList);
    exit(0);
}



void PrintKeyList(schema, list)
    Schema		*schema;
    KeyList		*list;
{
    Entry		ThisEntry = NULL;
    char		*RelationFN = schema->RelationName;
    char		*buf;
    int			DBFile;

    DBFile = OpenDatabase(RelationFN, 0);
    while (list != NULL) {
	if (Qddb_ReadEntryByKeyList(DBFile, RelationFN, &ThisEntry, list, True) == -1) { /* invalid entry */
	    list = list->next;
	    continue;
	}
	Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
	buf = (char *)Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_TCLEXTERNAL);
	if (buf == NULL) {
	    PANIC("Failed to convert entry\n");
	}
	write(fileno(stdout), buf, strlen(buf));
	putchar('\n');
	list = list->next;
    }
    close(DBFile);
}

