
/* qddb/Utils/qadd.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

int PrintSchema _ANSI_ARGS_((Schema *, char *));

void main(argc, argv)
    int			argc;
    char		*argv[];
{
    Schema		*schema;
    InCoreEntry		*CurrentEntry;
    static char		TmpFileName[MAXFILENAMELEN], *EditorType;
    char		Relation[MAXFILENAMELEN];
    char		*getenv(), *rel;
    Entry		ThisEntry = NULL;
    FILE		*fopen();
    int			TCL_flag = 0;
    struct stat		StatBuf;
    time_t		LastMod;

    if (argc < 2 || argc > 3) {
	fprintf(stderr, "Usage: %s [-tcl] RelationDirectory\n", argv[0]);
	exit(1);
    }
    if (argc == 3 && strcmp(argv[1], "-tcl") == 0) {
	TCL_flag = 1;
	argv++;
    }
    Qddb_Init();
    if ((rel = Qddb_FindRelation(argv[1])) == NULL) {
	fprintf(stderr, "%s: cannot find relation %s\n", argv[0], argv[1]);
	exit(1);
    }
    strcpy(Relation, rel);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    if (TCL_flag == 1) {
	char		*buf = Qddb_GetFile(0);

	/* -tcl instructs qadd to expect TCLExternal format on stdin */
	if ((CurrentEntry = (InCoreEntry *)Qddb_Convert(schema, QDDB_ENTRYTYPE_TCLEXTERNAL, buf, 
							QDDB_ENTRYTYPE_INTERNAL)) == NULL) {
	    fprintf(stderr, "Illegal tclexternal entry, addition aborted\n");
	    exit(1);
	}
	Qddb_SortInCoreEntries(schema, CurrentEntry); /* Just in case the TCL program didn't */
	if ((ThisEntry = (Entry)Qddb_Convert(schema, QDDB_ENTRYTYPE_INTERNAL, CurrentEntry, 
					     QDDB_ENTRYTYPE_EXTERNAL)) == NULL) {
	    PANIC("Illegal InCoreEntry");
	}
	Qddb_AddEntry(schema, NULL, False, ThisEntry);
	exit(0);
    }
    sprintf(TmpFileName, "/tmp/qddbadd.%d", (int)getpid());
    if (PrintSchema(schema, TmpFileName) == -1) {
#if !defined(DIAGNOSTIC)
	unlink(TmpFileName);
#endif
	PANIC("Cannot open tmp file");
    }
    if (stat(TmpFileName, &StatBuf) == -1) {
#if !defined(DIAGNOSTIC)
	unlink(TmpFileName);
#endif
	PANIC("qadd: cannot stat tmpfile");
    }
    LastMod = StatBuf.st_mtime;
retry:
    EditorType = getenv("EDITOR");
    if (EditorType == NULL)
	EditorType = LOCAL_DEFAULT_EDITOR;
    if (vfork() == 0) {
	execlp(EditorType, EditorType, TmpFileName, (char *)0);
	PANIC("Exec of editor failed..\n***Please set your EDITOR environment variable.***\n");
    }
    wait((int *)0);
    stat(TmpFileName, &StatBuf);
    if (StatBuf.st_mtime > LastMod) { /* entry was modified */
	char		line[BUFSIZ], *filebuf;
	int		fd, num;
	
	filebuf = Malloc((size_t)(StatBuf.st_size+1)*sizeof(char));
	if ((fd = open(TmpFileName, O_RDONLY, 0)) == -1) {
	    fprintf(stderr, "ERROR: cannot open temp file %s\n", TmpFileName);
	    unlink(TmpFileName);
	    exit(1);
	}
	if ((num = read(fd, filebuf, (size_t)StatBuf.st_size)) == -1) {
	    fprintf(stderr, "ERROR: cannot read temp file %s\n", TmpFileName);
	    unlink(TmpFileName);
	    exit(1);
	}
	close(fd);
	filebuf[StatBuf.st_size] = '\0';
	if ((CurrentEntry = (InCoreEntry *)Qddb_Convert(schema,QDDB_ENTRYTYPE_READABLE, filebuf,
					 QDDB_ENTRYTYPE_INTERNAL)) == NULL) {
	    fprintf(stderr, "Try again? (y/n) ");
	    gets(line);
	    if (line[0] == 'n') 
		goto out;
	    Free(filebuf);
	    goto retry;
	}
	Qddb_SortInCoreEntries(schema, CurrentEntry);
	if ((ThisEntry = (Entry)Qddb_Convert(schema, QDDB_ENTRYTYPE_INTERNAL, CurrentEntry, 
					     QDDB_ENTRYTYPE_EXTERNAL)) == NULL) {
	}
	if (Qddb_AddEntry(schema, NULL, False, ThisEntry) == -1) {
	    fprintf(stderr, "Could not obtain lock for addition.\n\
You may be running over NFS without a lockd.\n");
	}
    }
out:
    unlink(TmpFileName);
    exit(0);
}

int PrintSchema(MySchema, TmpFileName)
    Schema		*MySchema;
    char		*TmpFileName;
{
    Schema		*csp = MySchema;
    unsigned int	i, Level;
    FILE 		*fopen(), *TmpFilePtr = fopen(TmpFileName, "w");
    char		*Tabs();
    
    if (TmpFilePtr == NULL)
	return -1;
    fprintf(TmpFilePtr, "$NUMBER$ = \"1\";\n");
    Level = 1;
    for (i = 1; i <= csp->NumberOfAttributes; i++) {
	if (csp->Entries[i].IsLeaf == True) {
	    fprintf(TmpFilePtr, "%s%s = \"\"\n", Tabs(Level-1),
		    csp->Entries[i].Name);
	} else {
	    fprintf(TmpFilePtr, "%s%s (\n", Tabs(Level-1),
		    csp->Entries[i].Name);
	}
	if (i == csp->NumberOfAttributes)
	    continue;
	if (csp->Entries[i+1].Level > Level)
	    Level++;
	else if (csp->Entries[i+1].Level < Level) {
	    while (csp->Entries[i+1].Level < Level) {
		Level--;
		fprintf(TmpFilePtr, "%s)\n", Tabs(Level-1));
	    }
	}
    }
    while (Level-- > 1)
	fprintf(TmpFilePtr, "%s)\n", Tabs(Level-1));
    fclose(TmpFilePtr);
    return 0;
}


char *Tabs(Number)
    int		Number;
{	
    int		i;
    static char	buf[BUFSIZ];
    
    if (Number <= 0)
	return "";
    strcpy(buf, "\t");
    for (i = 1; i < Number; i++)
	strcat(buf, "\t");
    return buf;
}
