
/* qddb/Utils/Edit.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

Boolean			StopLists = False;

void EditKeyList(schema, TheList)
    Schema		*schema;
    KeyList		*TheList;
{
    char		*RelationFN = schema->RelationName;
    static char		TmpFileName[BUFSIZ];
    char		*output;
    int			fd;
    static KeyList	*TmpList;
    Entry		ThisEntry = NULL;
    InCoreEntry		*entry;
    void		Handlit();

    fd = OpenDatabase(RelationFN, 0);
    TmpList = TheList;
    while (TmpList != NULL) {
	static char	*EditorType;
	char		*getenv(), *newbuf;
	size_t		newbuflen;
	int		newbufcomp;
	struct stat	StatBuf;
	time_t		LastMod;
	unsigned int	LastSize;
	FILE		*fp;

	if (Qddb_ReadEntryByKeyList(fd, RelationFN, &ThisEntry, TmpList, True) == -1) { 
	    /* Invalid entry */
	    TmpList = TmpList->next;
	    continue;
	}
	Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
	sprintf(TmpFileName, "/tmp/qddb.%d.%d", (int)getpid(), 
		(int)TmpList->Number);
	output = (char *)Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_READABLE);
	fp = fopen(TmpFileName, "w");
	if (fp == NULL) {
	    fprintf(stderr, "EditKeyList: cannot open tmp file %s\n", TmpFileName);
	    PANIC("");
	}
	fprintf(fp, "%s", output);
	fclose(fp);
	stat(TmpFileName, &StatBuf);
	LastMod = StatBuf.st_mtime;
	LastSize = StatBuf.st_size;
retry:
	if (StopLists == True) {
	    int		ch;
	    
	    fprintf(stderr, "Signal received, Continue? (y/n) ");
	    fflush(stderr);
	    ch = getchar();
	    if (ch == 'n' || ch == 'N')
		exit(1);
	    StopLists = False;
	}
	EditorType = getenv("EDITOR");
	if (EditorType == NULL)
	    EditorType = LOCAL_DEFAULT_EDITOR;
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	if (vfork() == 0) {
	    execlp(EditorType, EditorType, TmpFileName, (char *)0);
	    exit(1);
	}
	wait((int *)0);
	signal(SIGINT, Handlit);
	signal(SIGQUIT, Handlit);
	stat(TmpFileName, &StatBuf);
	fp = fopen(TmpFileName, "r");
	if (fp == NULL) {
	    fprintf(stderr, "EditKeyList: cannot open tmp file %s\n", TmpFileName);
	    PANIC("");
	}
	newbuflen = strlen(output);
	newbuf = Malloc((size_t)newbuflen+1);
        fread(newbuf, sizeof(char), newbuflen, fp);
	newbuf[newbuflen] = '\0';
	fclose(fp);
	newbufcomp = strcmp(output, newbuf);
	Free(newbuf);
	/* entry was modified */
	if (StatBuf.st_mtime > LastMod || StatBuf.st_size != LastSize || newbufcomp != 0) {
	    char		line[BUFSIZ], *filebuf;
	    int			fd, num;
	
	    filebuf = Malloc((size_t)(StatBuf.st_size+1)*sizeof(char));
	    if ((fd = open(TmpFileName, O_RDONLY, 0)) == -1) {
		fprintf(stderr, "ERROR: cannot open temp file %s\n", TmpFileName);
		unlink(TmpFileName);
		exit(1);
	    }
	    if ((num = read(fd, filebuf, (size_t)StatBuf.st_size)) == -1) {
		fprintf(stderr, "ERROR: cannot read temp file %s\n", TmpFileName);
		unlink(TmpFileName);
		exit(1);
	    }
	    close(fd);
	    filebuf[StatBuf.st_size] = '\0';
	    if ((entry = (InCoreEntry *)Qddb_Convert(schema,QDDB_ENTRYTYPE_READABLE, filebuf,
							    QDDB_ENTRYTYPE_INTERNAL)) == NULL) {
		if (qddb_errmsg != NULL)
		    fprintf(stderr, "%s\n", qddb_errmsg);
		fprintf(stderr, "Try again? (y/n) ");
		gets(line);
		if (line[0] == 'n') 
		    goto out;
		Free(filebuf);
		goto retry;
	    }
	    Free(filebuf);
	    Qddb_SortInCoreEntries(schema, entry);
	    if ((ThisEntry = (Entry)Qddb_Convert(schema, QDDB_ENTRYTYPE_INTERNAL, entry, 
						 QDDB_ENTRYTYPE_EXTERNAL)) == NULL) {
	    }
	    Qddb_ChangeEntry(schema, -1, False, ThisEntry, QDDB_KEYLIST_TYPE(TmpList));
	    if (QDDB_KEYLIST_TYPE(TmpList) == ORIGINAL)
		Qddb_InvalidateEntry(schema, TmpList->Start, TmpList->Length);
	}
out:
	TmpList = TmpList->next;
	unlink(TmpFileName);
    }
    close(fd);
}

void Handlit()
{
    extern Boolean 		StopLists;

    StopLists = True;
}
