#!/usr/bin/awk -f
# Usage: qckhash < HashTable
# Example: qckhash < MyRelation/HashTable
#
# Check the number of collisions in a Qddb HashTable  
BEGIN {
	max = 0
}
{
	if ($1 > max) {
		max = $1
	}
	if ($1 in array) {
		array[$1]++
	} else {
		array[$1] = 1
	}
}
END {
	printf("Collisions | Number colliding slots\n")
	printf("----------   ----------------------\n")
	for (i = 0; i <= max; i++) {
		if (i in array)
			printf("%10d:  %10d\n", i, array[i])
	}
}
