'\"
'\" qddb/ManPages/man1/qddb_util.n
'\" 
'\" Copyright (C) 1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_util 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
qddb_util \- Miscellaneous utility functions.
.SH SYNOPSIS
.ft B
.nf
qddb_util isdate <date string>
qddb_util formatdate <format string> <date string>
qddb_util datestyle ?us|european?
qddb_util isregexp <regexp string>
qddb_util flock <file desc> LOCK_SH|LOCK_EX|LOCK_NB|LOCK_UN 

.SH DESCRIPTION
.TP
\fIisdate\fR accepts a date string and determines whether
Qddb can parse it.   If it is a valid date string, 
\fIqddb_util isdate\fR returns \fB1\fR; \fB0\fR is returned
otherwise.

.TP
\fIformatdate\fR accepts a format string (see strftime(3))
and a date string and returns the formatted string.   If
Qddb cannot parse the date string, an error is returned.
Note: the format string "%s" returns the number of seconds
since the epoch.

.TP
\fIdatestyle\fR with no argument returns the current
date style.   With an argument of "us" or "european",
the date style is set appropriately (us is "%m/%d/%y"
and european is "%d/%m/%y").

.TP
\fIisregexp\fR accepts a string and determintes whether the
string is a valid V8-style regular expression.   If it is a
valid regular expression, \fIqddb_util isregexp\fR returns
\fB1\fR; \fB0\fR is returned otherwise.

.TP
\fIflock\fR locks or unlocks a file associated with the
given file descriptor.   The file descriptor must be
the result of a previous Tcl "open" command.   The options are a 
set of tokens separated by '|'.   If LOCK_SH is given, a shared
(read) lock is attempted.   If LOCK_EX is given, an exclusive
(write) lock is attempted.   The presence of LOCK_NB in
the options list indicates that the operation should not
block.   LOCK_UN unlocks the file if the lock exists.   For
example:
.nf
    set fd [open /tmp/ho.txt w]
    if {![qddb_util flock $fd LOCK_EX|LOCK_NB]} {
        puts "Warning: cannot set lock on '/tmp/ho.txt'"
    }
.fi

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n), qddb_schema(n), 
qddb_search(n), qddb_table(n), qddb_tuple(n), qddb_view(n)

.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
