'\"
'\" qddb/ManPages/man1/qddb_table.n
'\" 
'\" Copyright (C) 1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_table 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
qddb_table \- Generic table abstraction
.SH SYNOPSIS
.ft B
.nf
qddb_table define <rows> <columns> ?-variable <variable>? \\
    ?-order row|column? ?-autoeval on|off? \\
    ?-name <table name>? ?-title <title>? ?-comment <comment>?
qddb_table delete <table_desc>|all
qddb_table clear <table_desc>
qddb_table copy <table_desc>
qddb_table expr <expression>
qddb_table expr_ok <expression>
qddb_table eval <table_desc>
qddb_table getval <table_desc> ?-format list|text|rows? \\
    ?-rowtitles on|off? ?-coltitles on|off?
qddb_table setval <table_desc> <list>
qddb_table cget <table_desc> ?options?
qddb_table configure <table_desc> <option> <value>
qddb_table sort <table_desc> ?-start <row name>? ?-end <row name>? \\
    ?-ascending <column list>? ?-sortby <column list>?
qddb_table summary <table_desc> <x_col> <y_col> <range> <format> <function>
Available table options:
    -order, -autoeval, -name, -title, -comment, -variable

qddb_table row insert <table_desc> ?-before <row name>? ?-numrows number?
qddb_table row delete <table_desc> <row name>
qddb_table row clear <table_desc> <row name>
qddb_table row copy <table_desc> <from> <to>
qddb_table row eval <table_desc> <row name>
qddb_table row maxnum <table_desc>
qddb_table row getval <table_desc> <row name>
qddb_table row setval <table_desc> <row name> <value list>
qddb_table row cget <table_desc> <row name> ?<option> <value>?
qddb_table row configure <table_desc> ?<option> <value>?
Available row options:
    -comment, -title, -name, -variable

qddb_table col insert <table_desc> ?-before <col name>? ?-numcols number?
qddb_table col delete <table_desc> <col name>
qddb_table col clear <table_desc> <col name>
qddb_table col copy <table_desc> <from> <to>
qddb_table col eval <table_desc> <col name>
qddb_table col maxnum <table_desc>
qddb_table col getval <table_desc> <col name>
qddb_table col setval <table_desc> <col name> <value list>
qddb_table col cget <table_desc> <col name> <option>
qddb_table col configure <table_desc> <col name> ?<option> <value>?
Available col options:
    -comment, -title, -name, -variable, -type, -calc,
    -justify, -width, -precision, -separator

qddb_table cell clear <table_desc> <row name> <col name>
qddb_table cell copy <table_desc> <from row> <from col> <to row> <to col>
qddb_table cell eval <table_desc> <row name> <col name>
qddb_table cell getval <table_desc> <row name> <col name>
qddb_table cell setval <table_desc> <row name> <col name> <value>
qddb_table cell cget <table_desc> <row name> <col name> <option>
qddb_table cell configure <table_desc> <row name> <col name> \\
    ?<option> <value>? \\
Available cell options:
    -comment, -title, -name, -variable, -type, -calc,
    -justify, -width, -precision, -separator

.SH GENERIC TABLE COMMANDS
\fIqddb_table\fR provides a table abstraction useful for building
reports and spreadsheets.
The \fIqddb_table\fR command manipulates tables produced by the 
\fIqddb_rows\fR command, or with \fIqddb_table define\fR.

.TP 
\fIqddb_table define\fR
defines a new table and sets up the initial state of the table.
All options provided in a \fIqddb_table define\fR command can be
changed later with \fIqddb_table configure\fR, \fIqddb_table row insert|delete\fR
and \fIqddb_table col insert|delete\fR.

.TP
\fIqddb_table delete\fR
deletes the given table from memory.   Tables produced with \fIqddb_rows\fR
may need to be processed to delete tuple and row descriptors before deleting
the table.

.TP 
\fIqddb_table clear\fR
clears all contents from the table, leaving the number of rows and columns
intact.    All options and values are cleared and reset to the defaults.

.TP 
\fIqddb_table copy\fR
returns a new table descriptor referencing a copy of the given table.   All
settings, values, comments, etc. are copied.

.TP
\fIqddb_table eval\fR
recalculates all calculated cells in the given table.   The calculations
are performed in either row or column order, depending on the setting of
the table's \fI-order\fR option.    If \fI-autoeval\fR is \fIon\fR, this
command usually has no effect.

.TP 
\fIqddb_table expr\fR
evaluates an arbitrary expression with no implicit table or cell association.
All range functions must provide an explicit table reference.

.TP 
\fIqddb_table expr_ok\fR
checks the syntax of the given expression without concern for whether
the expression can be properly evaluated on any given table.

.TP 
\fIqddb_table getval\fR
returns the contents of the table in one of several formats.   In each
format, the user can select to display row and/or column titles.  If
row and column titles are not set, the number of the row or column is
shown.    The available formats are:

.ft C
.nf
    list - an unformatted list of rows; each row is a list
           of cell values
    text - a formatted string, suitable for printing
    rows - a list of formatted rows, suitable for displaying
           in a listbox
.fi
.ft R

.TP 
\fIqddb_table setval\fR
accepts a list of rows, where each row is a list of cell values.
\fIqddb_table setval\fR sets the given table to contain those values.
The number of
elements in the list must equal the number of rows in the table.
Each element in the list must be a list where the number of elements
equals the number of columns in the table, and the type of each
element must correspond to the type of the column.
For example, a 3x3 table of column types

.ft C
.nf
    real string real
.fi
.ft R

requires an argument similar to the following:

.ft C
.nf
    {
        {3.0  {hello world}       211.00}
        {2.01 {some string}       121.00}
        {1.0  {some third string} 1.212}
    }
.fi
.ft R

.TP 
\fIqddb_table cget\fR
retrieves the current value of the given option for the given
table.   The available options are:

.ft C
.nf
    -variable - a variable name to use as for quick access 
                to cell values
    -name     - a symbolic name for the table; must be of 
                the form "[a-zA-Z][a-zA-Z0-9\.\_\-]*"
    -autoeval - whether autoevaluation is on or off
    -order    - the default re-calculation order used when 
                cell values change
    -title    - a symbolic title for the table
    -comment  - a general comment for the table
.fi
.ft R

.TP 
\fIqddb_table configure\fR
changes the value of the given option (see above) for the given table.
Multiple options may be given in a single command.

.TP 
\fIqddb_table sort\fR
sorts the table according to the \fI-sortby\fR and \fI-ascending\fR
options.     Column names provided with \fI-sortby\fR and \fI-ascending\fR
may be given either their default numeric names (beginning with '1')
or assigned symbolic names.

.TP
\fIqddb_table summary\fR
returns a new table suitable for building barcharts and graphs.   The
new table is a summary of each row in the given table.   The format
and range are on the <x_col>:

.ft C
.nf
    Type         Range           Format
    --------     -------------   ---------------
    string       ignored         ignored
    date         sorting order   display format
    real         range           precision
    integer      range           ignored
.fi
.ft R

The <function> is an operation of like values in the <x_col>
(specified by the range) on the values in the <y_col>.   <function>
can be any one of \fIavg\fR, \fIsum\fR,
\fIstddev\fR, \fImin\fR, \fImax\fR, \fIcount\fR, or \fIprod\fR.


.SH SECONDARY ROW COMMANDS
\fIqddb_table row\fR
executes a secondary row command on the given table and row.   

.TP
\fIqddb_table row insert\fR
appends one new row to the table by default.   If the \fI-before\fR
option is given, then the row is inserted before the given row.   If
the \fI-numrows\fR option is given, the given number of
rows are inserted or appended to the table.   The default number of
rows is one.

.TP
\fIqddb_table row delete\fR
completely deletes the given row from the table.

.TP
\fIqddb_table row clear\fR
clears the given row values and options, leaving the row
in place.  All options and values are cleared and reset to the defaults.

.TP
\fIqddb_table row copy\fR
copies the given row and places the copy in the
specified location.   If the destination ('to') row exists,
it is overwritten; if it doesn't exist, it is created.
The source ('from') row must exist or an error is returned.

.TP
\fIqddb_table row eval\fR
recalculates all calculated cells in the given row.   The calculations
are performed from left to right, first column to last column.

.TP
\fIqddb_table row maxnum\fR
returns the number of rows in the given table.

.TP
\fIqddb_table row getval\fR
returns a list containing the cell values for the
specified row.

.TP
\fIqddb_table row setval\fR
accepts a list containing the cell values for the
specified row.   The list must contain the same
number of elements as the number of columns in the
table.

.TP
\fIqddb_table row cget\fR
retrieves the current value of the given row option.  Available
row options are: 

.ft C
.nf
    -comment  - a general comment for the row
    -name     - a symbolic name for the row; must be of 
                the form "[a-zA-Z][a-zA-Z0-9\.\_\-]*"
    -title    - a title for the row
    -variable - an array variable that can be used for direct
                access to cell values in the row, using the
                column name as the index
.fi
.ft R

.TP
\fIqddb_table row configure\fR
sets the row option to the given value. Multiple options may be
given in a single command.

.SH SECONDARY COLUMN COMMANDS
\fIqddb_table col\fR
executes a secondary column command on a table.   

.TP
\fIqddb_table col insert\fR
appends one new column to the table by default.   If the \fI-before\fR
option is given, then the column is inserted before the given column.   If
the \fI-numcols\fR option is given, the given number of
columns are inserted or appended to the table.   The default number of
columns is one.
	     
.TP	     
\fIqddb_table col delete\fR
deletes the given column from the table.

.TP	     
\fIqddb_table col clear\fR
clears the given column of all values and options, leaving the column intact.
All options and values are cleared and reset to the defaults.

.TP	     
\fIqddb_table col copy\fR
copies the given column and places the copy in the
specified location.   If the destination ('to') column exists,
it is overwritten; if it doesn't exist, it is created.
The source ('from') column must exist or an error is returned.

.TP
\fIqddb_table col eval\fR
recalculates all calculated cells in the given column.   The calculations
are performed from top to bottom, first row to last row.

.TP	     
\fIqddb_table col maxnum\fR
returns the number of columns in the given table.

.TP	     
\fIqddb_table col getval\fR
returns a list containing the unformatted cell values of 
the given column.

.TP	     
\fIqddb_table col setval\fR
accepts a list containing the cell values for the
specified column.   The list must contain the same
number of elements as the number of columns in the
table.

.TP	     
\fIqddb_table col cget\fR
retrieves the current value of the given row option.  Available
row options are: 

.ft C
.nf
    -comment   - a general comment for the column
    -name      - a symbolic name for the column; must be of 
                 the form "[a-zA-Z][a-zA-Z0-9\.\_\-]*"
    -title     - a title for the column
    -variable  - an array variable that can be used for direct
                 access to cell values in the column, using the
                 column name as the index
    -type      - the default type of the given column
                 (string, real, integer, date, or calc)
    -justify   - the default justification of the column for
                 output purposes; may be one of 'left', 'right'
                 'center', or 'none'.   The 'none' option provides
                 no padding between separators.
    -width     - the default width of the column for output
                 purposes
    -precision - the default precision (to the right of the
                 decimal) of the column if the column is of
                 type real
    -separator - the default separator to append to the column
                 for printing purposes (default: space)
.fi
.ft R

.TP	     
\fIqddb_table col configure\fR
sets the value of the given option to the given value (see
above).   Multiple options may be
given in a single command.

.SH SECONDARY CELL COMMANDS
\fIqddb_table cell\fR
executes a secondary cell command on a table.   

.TP	     
\fIqddb_table cell clear\fR
clears the given cell of any options and values.

.TP	     
\fIqddb_table cell copy\fR
copies the given cell's values and options to the
provided destination.   Both source (from) and
destination (to) cells must exist or an error
is returned.   The value of the name option
is not copied.

.TP
\fIqddb_table cell eval\fR
recalculates the given calculated cell.

.TP	     
\fIqddb_table cell getval\fR
returns the unformatted value of the given cell.

.TP	     
\fIqddb_table cell setval\fR
sets the given cell to the specified value.  The
value should be of the appropriate type.

.TP	     
\fIqddb_table cell cget\fR
returns the current value of the specified
option for the given cell.   The available
options are the same as those available for
columns plus the following:

.ft C
.nf
    -calc      - formula for calculating the field if the 
                 cell is type 'calc'; if the field is not type
                 'calc', an error is returned.
.fi
.ft R

.TP	     
\fIqddb_table cell configure\fR
sets the value of the specified option to
the given value.   If the option is '-calc' and
the type of the cell is not type 'calc', then
the field is redefined as a calculated field and
its value set to zero before evaluating the calculated
expression.

Multiple options may be given in a single command.

.SH VARIABLES
\fIqddb_table\fR can bind Tcl variables to a table,
row, column, or cell(s).   When you specify a variable
name for a table, the cells are available as 
\fIvariable(row,column)\fR:

.ft C
.nf
    var(1,1) var(1,2) var(1,3)
    var(2,1) var(2,2) var(2,3)
    var(3,1) var(3,2) var(3,3)
.fi
.ft R

Row and column variables are bound as one-dimensional
arrays.   Cell variables are scalar Tcl variables.

If a name has been associated with a row, column or cell, then
the variable is available in several forms:

.ft C
.nf
    tablevar(1,1)
    tablevar(row_name,1)
    tablevar(1,column_name)
    tablevar(row_name,column_name)
    tablevar(cell_name)
.fi
.ft R

Row and column variables use their respective names in
the one-dimensional array as well as numbers.

.SH EXPRESSIONS
\fIqddb_table\fR provides calculated fields for spreadsheet-style
operations.    Calculated fields have the type \fIcalc\fR and
any value assigned to the field is automatically calculated based
on the provided expression.    

You can also evaluate arbitrary
expressions that are not associated with a particular cell or table with
\fIqddb_table expr\fR.    You must provide an explicit table argument
to any range functions (or to each range).

There are four types of subexpressions:
numeric constants/expressions, ranges, range functions, and 
numeric functions.   Ranges can only
be used as arguments to a range function.   Range functions take
ranges as arguments and produce real numbers; numeric functions take
numbers as arguments and produce real numbers.

\fBAll calculations and values are represented in double precision
floating point.\fR

.TP
Numeric expressions
may include any of the following operators and
may be fully parenthesized.   Precedence is the same as the C programming
language.

.ft C
.nf
   - + * / %
.fi
.ft R

For example, the following are all valid numeric expressions:

.ft C
.nf
    (2+3)/4
    2+3/4
    97*2+98*2/3-42.0
.fi
.ft R

.TP
\fBRanges\fR 
A range can be any of the following

.ft C
.nf
    @range(row,col:row,col)
    @range(tablename,row,col:row,col)
    @row(row)
    @row(tablename,row)
    @col(col)
    @col(tablename,col)
    @cell(row,col)
    @cell(tablename,row,col)
    @(row,col?:row,col?)
    @(tablename,row,col?:row,col?)
.fi
.ft R

The optional \fItablename\fR may be either the explicit name
of a table, or the table descriptor returned by \fIqddb_table define\fR.
Each range must have an associated table, either explicit or implicit.
\fIqddb_table expr\fR has no implicit table, so all range functions (see below)
or ranges
must specify a table explicitly.    When a range function has a
table argument, all ranges used as arguments to that function have
an implicit table.    Implicit tables do not propagate to subexpressions
used within arguments to range functions.

Row and column names may be used as arguments to ranges,
as well as numeric expressions and the following constants: \fI@thisrow\fR,
\fI@thiscol\fR, \fI@maxrow\fR, and \fI@maxcol\fR.   The constants
are evaluated in the current table context (that is, the
calculated field's implicit table).

Each range produces a list of cells to be evaluated by a range function.
\fI@range\fR produces a list of all cells in the rectangular region
specified by the four numeric arguments (row,col:row,col).
Ranges have no meaning by themselves and must be used as arguments to
a range function.   Cell and cell ranges (\fI@range\fR and \fI@cell\fR) may be
abbreviated with just '@'.

.TP
\fBRange functions\fR
A range function accepts a list of ranges separated by commas
and produces a numeric result.
The result of a range function is a numeric value that can be
used in any expression, or as the argument to a numeric function.
All range functions have the form 

.ft C
.nf
    range_func(?tablename,? range1 ?, range2, ...?)
.fi
.ft R

The range functions are:

.ft C
.nf
    @sum        sum
    @prod       product 
    @avg        average (mean)
    @stddev     standard deviation
    @count      num of cells in range
    @min        minimum cell value
    @max        maximum cell value
.fi
.ft R

Here is an example:

.ft C
.nf
    set t [qddb_table define 10 10]
    set t2 [qddb_table define 10 10]
    # insert some values here
    set sum [qddb_table expr "
        @sum($t, # set up implicit table for ranges
            @range(1,1:@maxrow,@maxcol),
            # now override implicit table $t with $t2
            @cell($t2,@maxrow,@maxcol)
        ) * 42
    "]
.fi
.ft R

.TP
\fBNumeric functions\fR
A numeric function accepts numeric values as arguments
and produces a numeric result.   No table context is required
for numeric functions.   The numeric functions accept any numeric
expression as an argument.

.ft C
.nf
    @cellval(?t,?e1,e2) cell value @(e1,e2) in table 't'
                        (equivalent to "@sum(?t,? @(e1,e2))")
    @sqrt(e)            square root of 'e'
    @exp(e)             exponential function of 'e'
    @ln(e)              natural log of 'e'
    @log(e)             log base 10 of 'e'
    @floor(e)           largest integer not greater than 'e'
    @ceil(e)            smallest integer not less than 'e'
    @rnd(e)             round 'e' to nearest integer
    @round(e,n)         round 'e' to 'n' decimal places
    @abs(e)             absolute value of 'e'
    @pow(e1,e2)         'e1' raised to the power of 'e2'
    @pi                 a constant close to pi
    @degrees(e)         convert 'e' radians to degrees
    @radians(e)         convert 'e' degrees to radians
    @sin(e)             sin of 'e'
    @cos(e)             cos of 'e'
    @tan(e)             tan of 'e'
    @asin(e)            asin of 'e'
    @acos(e)            acos of 'e'
    @atan(e)            atan of 'e'
    @atan2(e1,e2)       atan of e1/e2
    @hypot(e1,e2)       computes sqrt(e1*e1 + e2*e2) in 
                        such a way that underflow will 
                        not happen
.fi
.ft R

.TP
\fBLogical expressions\fR
A logical expression performs various logical operations
and returns the numeric value 1.0 if true, and 0.0 if false.
Logical operations may be fully parenthesized.

.ft C
.nf
    =       equal to
    <       less than
    <=      less than or equal to
    >       greater than
    >=      greater than or equal to
    !=      not equal to
    &       logical and
    |       logical or
    !       logical not (unary)
.fi
.ft R

Logical expressions are used as the first argument to the \fI@if\fR
function.    If the logical expression is true, then \fI@if\fR 
evaluates to the second argument.   If the logical expression is
false, it evaluates to the third argument.

.TP
\fBExamples\fR

.ft C
.nf
    set t [qddb_table define 10 10]
    set t2 [qddb_table define 10 10]
    # insert some values here
    set stddev [qddb_table expr "
        @stddev($t, @range(1,1:@maxrow,@maxcol))
    "] ;# standard deviation of all cells
    set num [qddb_table expr "
        (@if(@avg($t, @row(1)) < @avg($t2, @row(2)),
            @avg($t, @row(1)), @avg($t2, @row(2)))
        +
        @if(@avg($t, @col(1)) < @avg($t2, @col(2)),
            @avg($t, @col(1)), @avg($t2, @col(2)))
        ) / 2
    "]
.fi
.ft R

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n), 
qddb_schema(n), qddb_search(n), qddb_tuple(n), 
qddb_view(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi

.SH DIAGNOSTICS
Tables produced by qddb_rows(n) contain row and/or tuple
descriptors
in their row comment fields; these should be explicitly
deleted from memory before deleting the table.   Failure
to do so will result in a memory leak.

When setting an expression for a calculated field containing
a reference to a non-existent table, the calculation is
delayed until the table exists.

.SH BUGS
Table names reside in a single namespace, that is, no two tables
can have the same name.    We will resolve this in the near future.

