'\"
'\" qddb/ManPages/man1/qddb_search.n
'\" 
'\" Copyright (C) 1993-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_search 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
qddb_search \- Search in a Qddb database.
.SH SYNOPSIS
.ft B
.nf
qddb_search <schema_desc> ?-prunebyattr <attr>? key
qddb_search <schema_desc> ?-prunebyattr <attr>? \\
    ?-parsing on|off? word key
qddb_search <schema_desc> ?-prunebyattr <attr>? word_range \\
    ?lower-bound key? - ?upper-bound key?
qddb_search <schema_desc> ?-prunebyattr <attr>? numeric_key
qddb_search <schema_desc> ?-prunebyattr <attr>? numeric_range \\
    ?lower-bound key? - ?upper-bound key?
qddb_search <schema_desc> ?-prunebyattr <attr>? date_range \\
    ?lower-bound key? - ?upper-bound key?
qddb_search <schema_desc> ?-prunebyattr <attr>? regexp key

.SH DESCRIPTION
\fIqddb_search\fR searches a Qddb database described by \fI<schema_desc>\fR
for a key or range of keys and returns
a token for the resulting keylist.   The keylist may be
used in subsequent calls to qddb_keylist and other Qddb
TCL commands.  With no search type specified, qddb_search
defaults to "word."   
.PP
If \fB-prunebyattr\fR is specified,
then the resulting keylist is pruned by the specified attribute
while the keylist is being built.  Specifying \fB-prunebyattr\fR
in a \fBqddb_search\fR is much faster than doing it later, especially
for regular expressions, ranges, and numbers.
.PP
\fBNOTE:\fR all range searches include the end points.

.TP
\fIword\fR and \fIword_range\fR (abbreviated \fIw\fR and \fIwr\fR, respectively)
find instances of full words, delimited by white space
or punctuation.   By default, \fBword\fR automatically parses words
based on an attributes separators (or the default separators in the
case of an unattributed search).   If \fB-parsing off\fR is specified,
\fBword\fR does not parse the given word before performing the search.
\fBword_range\fR searches for all words lexicographically between the 
lower-bound and upper-bound keys.  Either (or both) the lower-bound 
and upper-bound keys can be omitted indicating an open-ended search.

.TP
\fInumeric\fR and \fInumeric_range\fR (abbreviated \fI n\fR and \fI nr\fR, respectively)
find instances of numeric words (real or integer) treated as real
numbers (double), delimited by white space or punctuation.
\fB numeric_range\fR searches for all numeric words numerically between the lower-bound
and upper-bound keys.   Either (or both) the lower-bound and upper-bound
keys can be omitted indicating an open-ended search.

.TP
\fIdate_range\fR (abbreviated \fIdr\fR)
find instances of type date in the range specified.
Dates may be specified in any legal form (See "A Guide to QDDB").

.TP
\fIregexp\fR
(abbreviated \fBr\fR)
finds all words matching a regular expression (using Henry Spencer's
V8 regexp package).   This option can be expensive depending on the
number of unique words in the database.

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n), qddb_schema(n), 
qddb_tuple(n), qddb_view(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH BUGS
None known.
