'\"
'\" qddb/ManPages/man1/qddb_schema.n
'\" 
'\" Copyright (C) 1993-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_schema 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
qddb_schema \- open/close and view characteristics of a Qddb schema.
.SH SYNOPSIS
.ft B
.nf
qddb_schema open Relation
qddb_schema leaves <schema_desc> ?<attribute>?
qddb_schema option type|verbosename|alias|isexpandable|exclude| \\
	<schema_desc> <attr name>
qddb_schema path <schema_desc>
qddb_schema print <schema_desc>
qddb_schema secondarycaching <schema_desc> on|off
qddb_schema datestyle <schema_desc> us|european
qddb_schema excludewords <schema_desc>
qddb_schema close <schema_desc>
.SH DESCRIPTION
.TP
\fIqddb_schema open\fR
returns a descriptor <schema_desc> referring to a Qddb schema.   
This token may be used with other Qddb TCL commands.
It will search for the relation in the directories specified
by \fBQDDBDIRS\fR after looking in the current directory.   QDDBDIRS is of the
same format as the PATH environment variable, for example,
.nf
        /usr/local/qddb/databases:/u/eric/databases
.fi
is a valid path.   A file with the name 'HashTable' is
required in the Relation directory (qnewdb(1) builds this
file).

.TP
\fIqddb_schema leaves\fR
returns a list of all leaves in the Schema in the dot-separated
form required by all Qddb TCL commands.   If the optional
?<attribute>? field is specified, then all leaves at or below 
that point in the schema are returned.   Using the following 
schema:
.nf
    Name (
       First verbosename "Client's First Name" *
       Middle *
       Last verbosename "Client's Middle Name"
    ) *
    Address  
.fi
an example might be:
.nf
    % set s [qddb_schema open MyRelation]
    % qddb_schema leaves $s
    Name.First
    Name.Middle
    Name.Last
    Address
    % qddb_schema leaves $s Name
    Name.First
    Name.Middle
    Name.Last
    % qddb_schema leaves $s Address
    Address
.fi

.TP
\fIqddb_schema option\fR
returns the value of the option specified for the
given schema attribute.   The \fBtype\fR option
requires a leaf attribute and will give an TCL error
otherwise.   The possible type strings are
\fBinteger\fR, \fBreal\fR, \fBdate\fR, and \fBstring\fR.
If the type is unspecified in the Schema, it defaults to
\fBstring\fR.  The \fBexclude\fR option returns \fB1\fR or
\fB0\fR depending on whether the exclude option is specified
for the given leaf attribute.  The \fBisexpandable\fR option
returns \fByes\fR or \fBno\fR depending on whether the 
given attribute is expandable.
The \fBformat\fR option returns
the format string, and the \fBseparators\fR option
returns the separators string for the given leaf attribute.
The other options will accept an attribute at any level.

.TP
\fIqddb_schema path\fR
prints the full pathname of the Qddb schema from the directory
given on \fIqddb_schema open\fR.  An absolute path is always
returned.

.TP
\fIqddb_schema print\fR
prints the schema in a list format.   For example, the schema
defined above will be printed as:
.nf
        { Name { "" yes } {
               { First { "Client's First Name" yes } {} }
               { Middle { "" yes } {} }
               { Last { "Client's Middle Name" no } {} }
        }
.fi
This list may be traversed to build generic
interfaces, (see nxqddb(1)).   Each list consists of (1) an
attribute name, (2)) a list of characteristics for that attribute,
and (3) a list containing any subattributes.  (2)
consists of the verbosename (if any) and yes/no for whether
the attribute is expandable.

.TP
\fIqddb_schema secondarycaching\fR
allows you to temporarily turn on or off secondary caching.   This
option is primarily for temporarily turning off the 
\fIUse cached secondary search\fR schema option which slows down the writing
of tuples significantly while maintaining search speed.
Temporarily disabling secondary caching allows you to make
mass additions or changes to an existing or new database (if
you plan to immediately stabilize afterward) without changing
the option in the schema.   Please note that you should perform
any searching before disabling secondary caching, disable
the cache, make your modifications and write them to disk, then
immediately stabilize the database.   This option is intended
to be used on idle databases only; use it only if you understand
what you are doing.

.TP
\fIqddb_schema datestyle\fR
changes the default date style for input purposes.   No in-memory
tuples are automatically converted, so this should be one of the first
commands in the script after \fIqddb_schema open\fR.

.TP
\fIqddb_schema excludewords\fR
returns a list containing all words in the ExcludeWords file, or
the null string if the ExcludeWords schema option is off.

.TP
\fIqddb_schema close\fR
closes the Qddb schema associated with \fI<schema_desc>\fR.
Other Qddb structures that require the closed schema
will not be deleted (keylists, etc.) and cannot
be used after the schema is closed.
Multiple schemas may be open simultaneously and the
same schema may be open more than once.   Qddb does
not understand the relationship between two different
schema descriptors that are opened on the same relation.
.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n)
qddb_search(n), qddb_tuple(n), qddb_view(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS
.B qddb_schema
will report an error if it cannot find the Qddb schema
specified.
.SH BUGS
None known.
