'\"
'\" qddb/ManPages/man1/qddb_rows.n
'\" 
'\" Copyright (C) 1993-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_rows 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 97
.SH NAME
qddb_rows \- Row operations on tuples and keylists.
.SH SYNOPSIS
.ft B
.nf
qddb_rows all ?-format rows? ?-instance attr,inst? ?-rowdescs on|off? \\
    ?<options>? <tuple_desc>
Return value:
    { <row_desc> "row values" }
    { <row_desc> "row values" }
    ...
qddb_rows all ?-format table? ?-instance attr,inst? ?-rowdescs on|off? \\
    ?<options>? <tuple_desc>
Return value: a <table desc>

qddb_rows select ?-format rows? ?<options>? <keylist_desc> (default)
->Return value:
    { <tuple_desc> <row_desc> "row value" }
    { <tuple_desc> <row_desc> "row value" }
    ...
qddb_rows select -format query ?<options>? <keylist_desc>
->Return value:
    { { row value } { Start Length Number Type } { attr,inst ... } }
    { { row value } { Start Length Number Type } { attr,inst ... } }
    ...
qddb_rows select -format table ?<options>? <keylist_desc>
->Return value: a <table desc>

qddb_rows get <row_desc>
qddb_rows getval <attribute list> <row_desc>
qddb_rows sort ?-ascending <attribute list>? <attribute list> <row_desc list>
qddb_rows tuplename <row_desc>
qddb_rows delete <row desc>|all

<options>:
    -attrs <attribute list> - unordered list of significant attributes
                              ('qddb_rows select' only, obsolete)
    -print <print list>     - ordered list of attributes to print
                              (format: { attr[:width] attr[:width] ... })
    -sortby <attr list>     - ordered list of attributes selected from the
                              '-print' option's list
    -ascending <attr list>  - unordered subset of list supplied by 
                              '-sortby' to be sorted in ascending order
    -sep string             - use the supplied string as a column separator
    -norows on|off          - suppress printing of attr,inst pairs when using
                              '-format query'
                              (default: off) 
    -suppress on|off        - suppress printing of row values
                              (default: off)
    -tclelements on|off     - return row values as Tcl elements
                              (default: off)
    -flush on|off           - flush each tuple from memory after producing
                              rows to save memory
                              (default: off)
    -deldup_rows on|off     - delete duplicate rows from those produced by
                              the same tuple
                              (default: off)

.SH DESCRIPTION
<tuple_desc> is a tuple descriptor like that returned by a
\fIqddb_tuple read\fR command.   <keylist desc> is a keylist 
descriptor, generally returned by a \fIqddb_search\fR or
some combination of \fIqddb_keylist\fR commands.
<attribute list> is a list of attributes that matched a
query, for example:

.nf
    { Name.First Name.Last Address.Street Address.City }	
.fi

specifies that we want only rows that matched in those attributes.
An example command sequence might be:
.nf
    set s [qddb_schema open Family]	
    set k0 [qddb_search $s George]
    set k1 [qddb_search $s Harris]
    set k2 [qddb_search $s Rosemont]
    set k3 [qddb_search $s Richmond]
    set k0 [qddb_keylist process prune -prunebyattr Name.First     $k0]
    set k1 [qddb_keylist process prune -prunebyattr Name.Last      $k1]
    set k2 [qddb_keylist process prune -prunebyattr Address.Street $k2]
    set k3 [qddb_keylist process prune -prunebyattr Address.City   $k3]
    foreach i [list $k1 $k2 $k3] {
        set k0 [qddb_keylist op intersection $k0 $i]
    }
    set r [qddb_rows select -format rows -deldup_rows on \\
         -attrs {Name.First Name.Last Address.Street Address.city} \\
         -print {Name.First:10 Name.Last:15 Address.Street} $k0]
    puts $r
    qddb_schema close $s
    qddb_keylist delete all
    qddb_rows delete all
    qddb_tuple delete all
.fi
This sequence (1) searches for the keys, (2) prunes the keylists of any nodes
not pertaining to the desired attributes, (3) performs an intersection
on the resulting lists, and (4) selects the rows from the keylist, and (5)
prints out the result.

<print list> is of the same form as <attribute list>, but with an
optional width field:
.nf
    { Name.First:10 Name.Last:15 Address.Street:20 Address.City:15 }
.fi
If the width field is absent, the attribute's value is not truncated and
each field's value is a TCL-list element.

The \fI-format query\fR option forces \fIqddb_rows select\fR to throw
away the tuples after it finds the row values.   If \fI-format rows\fR
is in effect, then the tuples are all kept in memory.   Obviously,
if you have a very large database, and you don't control the number
of tuples that a query can match, then you should use the \fI-flush on\fR
option (unless you have a huge amount of RAM in your machine).

.TP
\fIqddb_rows all\fR
traverses the tuple described by the given <tuple desc> to produce a
set of rows.   This command returns a list of 
{<row desc> <row values>} by default ('-format rows'), each of
which describes a row in the tuple described by <tuple desc>.   The
values of the rows may be obtained with a call to \fIqddb_rows get\fR.
If the \fB-instance attr,inst\fR argument is provided, then
only those rows that match the (attr,inst) pair are returned.  For example,
if you supply \fB-instance Person.Address,1.1\fR, then the result
is only rows containing
the first instance of \fBAddress\fR within the first instance of \fBPerson\fR.
In this case,

.nf
    qddb_rows all -sep " " -instance Person.Address,1.1 \
        -print \
        { Person.Name.First 
          Person.Name.Last 
          Person.Address.Street
        } $tuple
.fi

would operate on the following readable tuple
.nf
    Person (
        Name ( 
            First = "Henry"
            Last = "McKinney"
        )
        Name (
            First = "Georgia"
            Last = "McKinney"
        )
        Address (
            Street = "123 Rowdy Way"
        )
        Address (
            Street = "2312 Dougherty Parkway"
        )
    )
    Person (
        Name ( 
            First = "Monrey"
            Last = "Montavere"
        )
        Address (
            Street = "321 Howdy Way"
        )
    )
.fi
and produce rows containing:
.nf
     Henry McKinney 123 Rowdy Way
     Georgia McKinney 123 Rowdy Way
.fi

To produce rows with all instances of the \fIPerson.Address\fR attribute,
you may specify \fI-instance Person.Address,1\fR.   This will produce all
rows with the 1st Person and any Address.   For example, using the readable
tuple above you would get:
.nf
     Henry McKinney 123 Rowdy Way
     Henry McKinney 2312 Dougherty Parkway
     Georgia McKinney 123 Rowdy Way
     Georgia McKinney 2312 Dougherty Parkway
.fi

.TP
\fIqddb_rows all -format table\fR
produces a table descriptor suitable for use with the \fIqddb_table\fR
command.   The table has the following properties:
.nf
    1) each row is the same as would be returned by \fIqddb_rows all -format rows\fR
    2) column names are fully qualified attribute names (in order) from
       the -print option's list
    3) the column titles are the verbosenames of the corresponding attributes
    4) each column type defaults to the corresponding attribute type
    5) row comment fields are set to "<tuple_desc> <row_desc>" unless
       '-rowdescs off' is specified
.fi

.TP
\fIqddb_rows select\fR
finds all rows for all tuples in the keylist (described by <keylist desc>) 
that have at least one node in the given keylist for each supplied
attribute.  That is, <attribute list> describes the
attributes used in the search(es) that produced the keylist, and 
\fBqddb_rows select\fR produces only rows that match in every attribute
used in the search.  If no <attribute list> is supplied, then all rows
for each tuple described in the keylist are selected.   If no <print list>
is supplied, then the return value is list of triples:
.nf
    { <tuple desc> <row desc> {} }
    { <tuple desc> <row desc> {} }
.fi
If <print list> is supplied, then the value for each
attribute specified in <print list> is returned as the fourth
sub-element in each element of the returned list and
all duplicate rows are deleted:
.nf
    { <tuple desc> <row desc> { <formatted string> }
    { <tuple desc> <row desc> { <formatted string> }
.fi
The option \fI-suppress on\fR forces the suppression of
the formatted string, but still deletes duplicate rows based
on the \fI-print\fR options.  The \fI-sortby\fR and \fI-ascending\fR
options each accepts a list of leaf attributes.   \fI-sortby\fR 
specifies the sorting order of the rows, while \fI-ascending\fR determines
which attributes are sorted in ascending (increasing) order.   The
default sorting order is descending (decreasing).
The option \fI-tclelements on\fR
replaces the formatted string with a list of full element values.
The <tuple desc> in each row is a ready-to-use tuple descriptor, distinct
from any tuple descriptor that was open at the time of the call.   Each
returned <tuple desc> must be deleted when the application is finished
with it (as well as each <row desc>).   The option \fI-flush on\fR
flushes tuple from memory as it reads them to obtain row values.   The
flush option is faster when memory is limited and many tuples are returned
from a query (it is somewhat slower when memory isn't an issue).

.TP
\fIqddb_rows select -format table\fR
produces a table descriptor suitable for use with the \fIqddb_table\fR
command.   The table is set up with the following properties:
.nf
    1) each row is the same as would be returned by \fIqddb_rows select -format rows\fR
    2) column names are fully qualified attribute names (in order) from
       the -print option's list
    3) the column titles are the verbosenames of the corresponding attributes
    4) each column type defaults to the corresponding attribute type
    5) row comment fields are set to "<tuple_desc> <row_desc>" unless
       '-rowdescs off' is specified
.fi
Since the option '-rowdescs on' (the default) provides a tuple and row descriptor
in the comment field for each row, the user is responsible for 
explicitly deleting the tuples and rows after use.   For example,
the following code will walk through such a table, delete all
tuple and row descriptors, then finally delete the table itself.
.nf
    ...
    set table [qddb_rows select -format table -attrs \
        {A B C} -print {A B C} $keylist]
    set maxnum [qddb_table row maxnum $table]
    for {set i 1} {$i <= $maxnum} {incr i} {
        set tuple [qddb_table row cget $table $i -comment]
        catch "qddb_tuple delete [lindex $tuple 0]"
    }
    qddb_table delete $table
.fi

This command finds all rows in exactly the same manner 
as \fIqddb_rows select\fR.
The return value is a table descriptor suitable as an argument to
\fIqddb_table\fR.   Each column in the table is named by the
corresponding attribute (i.e. A.B.C), has the same type, and
the title is the verbosename of the attribute.
The \fI-rowdesc on\fR option places a row descriptor
in the comment field of each row in the table; if \fI-rowdesc\fR is off,
the corresponding tuples and rows are not saved and are deleted from
memory as each tuple is read.  The \fI-flush on\fR option flushes
each tuple from memory, but still saves the row descriptor in the 
comment field of each row for later use.   
Note that table operations are generally much faster than manipulating
standard Tcl lists.    If speed of table operations is important to
you, you should use this command instead of \fIqddb_rows select\fR.

.TP
\fIqddb_rows get\fR
returns a list of (attribute,value) pairs for the given <row_desc>.
\fBqddb_rows get\fR provides a way to get different
combinations of attribute values from a particular row.

.TP
\fIqddb_rows getval\fR
returns a list of unformatted values associated with each
element of <attribute list>.  For example:
.nf
    % qddb_rows getval { Person.Name.First Person.Name.Last } $r
    {Eric} {Herrin}
.fi
Note that any spaces in the attributes' values are not trimmed.

.TP
\fIqddb_rows sort\fR
returns a list of row descriptors identical to the given list
of row descriptors,
except they are sorted according to the given <attribute list>.
For example, given a set of rows:
.nf
    qddb_row1 {Henry} {McKinney}
    qddb_row2 {George} {Wilbur}
    qddb_row3 {Zoe} {Appleton}
    qddb_row4 {George} {Arthur}
.fi
an example use of \fIqddb_rows sort\fR might be:
.nf
    % qddb_rows sort -ascending {Person.Name.Last Person.Name.First} \\
        {Person.Name.First Person.Name.Last} \\
        {qddb_row1 qddb_row2 qddb_row3 qddb_row4}
    qddb_row1 qddb_row4 qddb_row2 qddb_row3
    % qddb_rows sort -ascending {Person.Name.Last Person.Name.First} \\
        {Person.Name.Last Person.Name.First} \\
        {qddb_row1 qddb_row2 qddb_row3 qddb_row4}
    qddb_row3 qddb_row4 qddb_row1 qddb_row2
    % qddb_rows sort {Person.Name.Last Person.Name.First} \\
        {qddb_row1 qddb_row2 qddb_row3 qddb_row4}
    qddb_row2 qddb_row1 qddb_row4 qddb_row3
.fi
The \fI-ascending\fR option's argument is a subset of the
<attribute list> specifying which of the columns are to be
sorted in an ascending fashion.   The default is \fIdescending\fR.
The \fIqddb_rows getval\fR command may then be used to get the 
values from the individual rows for viewing purposes.  Note that 
the sorting process uses the natural sorting method for the 
type of attribute (integer, real, string, or date).

.TP
\fIqddb_rows tuplename\fR
returns the tuple descriptor associated with the given row
descriptor.

.TP
\fIqddb_rows delete\fR
deletes the in-memory row given by <row_desc>.  The special
<row_desc> \fBall\fR deletes all rows from memory.

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_schema(n), 
qddb_search(n), qddb_table(n), qddb_tuple(n), 
qddb_view(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS
\fB qddb_rows select \fR operates on
the values permanently stored in the Qddb database.   If 
modifications to the tuple have been made at run-time (and not
saved), \fB qddb_rows select \fR may not produce reasonable
results.  Rows produced with \fB qddb_rows all \fR may be processed
with \fB qddb_rows getval \fR to produce current values as long as the
values aren't changed between the calls.   \fB qddb_rows select \fR
is generally used to produce a set of rows for tuple selection by
the user (or report generation).
.SH BUGS
None known.
