'\"
'\" qddb/ManPages/mann/Hx.n
'\" 
'\" Copyright (C) 1996-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Hx 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
Hx \- The Hx toolkit for building web interfaces to Qddb databases.
.SH SYNOPSIS
.ft B
.nf
Hx:Init <schema_desc>
Hx:DefinedEntryForm <schema_desc> <format>
Hx:ColumnSpecs <schema_desc> <name> <exclude attrs> \\
    <not checked attrs> <num columns>
Hx:SortSpecs <schema_desc> <name> <exclude attrs> \\
    <not checked attrs> <num specs>
Hx:GetPostedData
Hx:Search <schema_desc> <search list>
Hx:FormatTable <table_desc> <rowtitles=1|0> <coltitles=1|0>
Hx:PruneTable <table_desc> first last
Hx:DefinedListing <schema_desc> <table_desc> format
Hx:ParseError
Hx:NoSearch
Hx:NoMatches
Hx:GenericSearchEngine schema_name webmaster hostname \\
    mypath dbdir \\
    ?rowincr maxrows title opening message signature procs?
Hx:GenericSubmissionForm schema_name webmaster hostname \\
    mypath dbdir ?title opening message signature procs?

.SH DESCRIPTION
The 
.B Hx
toolkit allows programmers to easily build custom CGI web
applications.   A typical CGI script is in the following
form for searching:

.nf
#!/usr/local/qddb/bin/qtclsh
lappend auto_path $qddb_library/hx
set dir "/var/www/cgi-bin/qddb"
set mypath "/cgi-bin/qddb/search"
set dbname MyLittleDatabase
Hx:GenericSearchEngine $dbname joe@www.somewhere \\
    www.somewhere $mypath $dir
.fi

For data entry, the script is very similar to the script for 
searching:

.nf
#!/usr/local/qddb/bin/qtclsh
lappend auto_path $qddb_library/hx
set dir "/var/www/cgi-bin/qddb"
set mypath "/cgi-bin/qddb/submit"
set dbname MyLittleDatabase
Hx:GenericSubmissionForm $dbname joe@www.somewhere \\
    www.somewhere $mypath $dir
.fi


.TP
\fBHx:Init\fR
initializes the Hx toolkit.   It should be called before using
any Hx commands.

.TP
\fBHx:DefinedEntryForm\fR
returns an HTML form that must then be enclosed between
<form></form>.
<format> is a Tcl
list:
.nf
{
 {attribute label-width entry-type entry-width ?entry-height? ?values?}
 {<html> <br><br><p>Some stuff for the middle}
 {attribute label-width entry-type entry-width ?entry-height? ?values?}
}
.fi
where \fIattribute\fR is the attribute name (also used as the
entry name), \fIlabel-width\fR
is the width of the entry's label which comes from the verbosename schema
option, entry-type is one of the supported HTML form entry types (also
\fIselect-single\fR or \fIselect-multiple\fR),
and \fIentry-width\fR/\fIentry-height\fR are the width and height
options to the entry.
Multiple sublists may be on a single line to denote
that those entries should be on a single line in the form. 
The currently available entry types are \fItext\fR, \fIradio\fR, 
\fIcheckbox\fR, and \fItextarea\fR.   A special entry type
\fIlabel\fR allows you to build a label for an attribute and
place it anywhere you like.   The \fIvalues\fR list element
specifies a value for checkboxes, radiobuttons, select-single,
and select-multiple entry-types.
Another special entry type \fI<html>\fR is
provided to denote that everything after \fI<html>\fR should
be inserted verbatim in the form.

.TP
\fBHx:ColumnSpecs\fR
returns a formatted HTML table of checkboxes allowing the
user to specify the columns of a table.  The <name> is the
name you wish to use for the posted results (for example,
\fIhx-columns\fR).  <exclude attrs> is a Tcl list of attribute
names you want to exclude from the table, usually a list of
private fields.   <not checked attrs> are those attributes you
do not want selected by default.   <num columns> is the number
of columns you want in the table containing the checkboxes.

.TP
\fBHx:SortSpecs\fR
returns an HTML formatted set of selection entries allowing the
user to specify the sorting of the search results.  The <name> is the
name you wish to use for the posted results (for example,
\fIhx-sorted\fR).  <exclude attrs> is a Tcl list of attribute
names you want to exclude from the each selection, usually a list of
private fields.   <not checked attrs> are those attributes you
do not want selected by default.   <num specs> is the number
of selection entries that you want (typically around 3-4).

.TP
\fBHx:GetPostedData\fR
returns a list of lists, suitable for passing to \fBHx:Search\fR.
This list can also contain non-attribute form data, which is
ignored by \fBHx:Search\fR.    The format of the list returned
by \fBHx:GetPostedData\fR is:

.nf
{
    {name value} {name value}
}
.fi

where \fIname\fR is either an attribute name or the name of
a form entry that was manually introduced into the form.

.TP
\fBHx:Search\fR
accepts a list returned by \fBHx:GetPostedData\fR and
returns a Qddb keylist descriptor if the search is properly formatted, 
or an error otherwise.   The keylist descriptor may then be passed
to qddb_table(n) to obtain the corresponding search results.

\fBHx:Search\fR does not attempt to verify whether the search criteria
contains fields that were not supposed to be displayed.   It is the
programmer's responsibility to check for this situation if they
so desire.

.TP
\fBHx:FormatTable\fR
accepts a table descriptor as returned by qddb_rows(n), and
two arguments specifying whether to print the row and column
titles.    The default is to print both row and column titles.
You may optionally process the table before calling this routine
for special effects such as justification, etc.

.TP
\fBHx:DefinedListing\fR
accepts a schema descriptor, a table descriptor as returned
by qddb_rows(n), and a format specification list.   The
specification list is a Tcl list of the following form:
.nf
{
    {attribute entry-type ?entry-width?}
    {<html> <br><br><p>Some stuff for the middle}
    {myattr label 0}
    {myattr textarea 0}
}
.fi

.TP
\fBHxPruneTable\fR
accepts two arguments, the first and last rows you want to
keep in the table, and prunes the other rows from the table.
The row titles are modified to reflect each row's real position
in the original table.

.TP
\fBHx:ParseError\fR
is usually called to inform the user of a parsing error returned
by \fBHx:Search\fR.

.TP
\fBHx:NoSearch\fR
is usually called to inform the user that they did not specify
any search criteria.

.TP
\fBHx:NoMatches\fR
is usually called to inform the user that their search
did not produce any results.

.TP
\fBHx:GenericSearchEngine\fR

.nf
    schema_name - name of the relation
                  (not a schema descriptor)
    webmaster   - e-mail address of the webmaster
    hostname    - web server's host name
    mypath      - full path of the executing script
    dbdir       - full path of the directory containing
                  the Qddb relation "schema_name"
.fi

Optional arguments are as follows.   Note that these
arguments are optional from left to right, that is,
if you specify \fItitle\fR, you must also specify
\fIrowincr\fR and \fImaxrows\fR.  All these options default to the
empty string.

.nf
    rowincr     - rows displayed on a page (default 10)
    maxrows     - total rows to allow
    title       - <title> parameter
    opening     - Large opening statement
    message     - Message under opening statement
    signature   - A signature if necessary
    procs       - A Tcl list of procedure names:
                  {entryproc listingproc tableproc columnproc sortproc}
.fi

\fIentryproc\fR must be the name of a valid procedure
of the following form (defaults to \fBHx:GenericEntryForm\fR):

.nf
    proc MyEntryProc {schema_desc} {
        # Some entry form goes here.   Typically,
        # you want to call Hx:DefinedEntryForm
        # with special parameters.
    }
.fi

\fIlistingproc\fR must be the name of a valid procedure
of the following form (defaults to \fBHx:GenericListing\fR):

.nf
    proc MyListingProc {schema_desc table_desc} {
        # Some entry form goes here.   Typically,
        # you want to call Hx:DefinedListing
        # with special parameters and/or manipulate
        # the table before passing it to Hx:DefinedListing
    }
.fi

\fItableproc\fR must be the name of a valid procedure
of the following form (defaults to \fBHx:FormatTable\fR):

.nf
    proc MyTableProc {table_desc} {
        # Some entry form goes here.   Typically,
        # you want to call Hx:FormatTable
        # with special parameters and/or manipulate
        # the table before passing it to Hx:FormatTable.
    }
.fi

\fIcolumnproc\fR must be the name of a valid procedure
of the following form (defaults to \fBHx:ColumnSpecs\fR
and requires the same arguments):

.nf
    proc MyColumnSpecs {schema_desc varname 
        exclude_attrs notchecked_attrs numcolumns} {
        # Some column specs go here.   Typically,
        # you want to call Hx:ColumnSpecs
        # with special parameters.
    }
.fi

\fIsortproc\fR must be the name of a valid procedure
of the following form (defaults to \fBHx:SortSpecs\fR
and requires the same arguments):

.nf
    proc MySortSpecs {schema_desc varname 
        exclude_attrs notchecked_attrs numcolumns} {
        # Some sorting specs go here.   Typically,
        # you want to call Hx:SortSpecs
        # with special parameters.
    }
.fi

.TP
\fBHx:GenericSubmissionForm\fR
outputs to stdout a generic submission form.   The
required parameters are:
.nf
    schema_name - name of the relation
                  (not a schema descriptor)
    webmaster   - e-mail address of the webmaster
    hostname    - web server's host name
    mypath      - full path of the executing script
    dbdir       - full path of the directory containing
                  the Qddb relation "schema_name"
.fi

Optional arguments are as follows.   Note that these
arguments are optional from left to right, that is,
if you specify \fIopening\fR, you must also specify
\fItitle\fR.   All these options default to the
empty string.

.nf
    title       - <title> parameter
    opening     - Large opening statement
    message     - Message under opening statement
    signature   - A signature if necessary
    procs       - A Tcl list of procedure names:
                  {entryproc checkproc}
.fi


\fIentryproc\fR is the same format as \fBHx:GenericSearchEngine\fR
and defaults to \fBHx:GenericEntryForm\fR.

\fIcheckproc\fR must be the name of a valid procedure
of the following form:

.nf
    proc MyTupleCheckProc {tuple_desc} {
        # Some checks for valid fields and such go
        # here.   If something is amiss, output
        # an error to stdout, and exit
    }
.fi


.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
