'\"
'\" qddb/ManPages/mann/Fx:Print.n
'\" 
'\" Copyright (C) 1995-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx:Print 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
Fx:Print \- Routines for basic ASCII printing support.
.SH SYNOPSIS
.ft B
.nf
Fx:Print <list of lines>
Fx:PrintFile <file name>
Fx_PrintDialog <instance name> ?-toplevel <toplevel>? ?-title <title>?

.SH DESCRIPTION
\fBFx:Print\fR accepts a Tcl list of \fIlines\fR to be printed, prompts the user
for the name of the printer (or file), then outputs each element of the list
with an appended newline.   \fBFx:PrintFile\fR accepts a file name and prints
the file.   

.TP
\fBFx_PrintDialog\fR displays a dialog for the user to select
the method of printing.    The typical command sequence for using
\fBFx_PrintDialog\fR with \fBFx:Print\fR or \fBFx:PrintFile\fR
is:

.nf
    global fx_config

    Fx_PrintDialog dialog -toplevel "" -title "Neat printing"
    # Fx_PrintDialog doesn't return until user is finished
    if {$fx_config(cancel_print) == 0} {
        catch "Fx:PrintFile $fn"
    }
.fi

.SH DIAGNOSTIC
You must specify a list of formatted lines that are ready to output.   \fBFx:Print\fR
does not try to determine whether lines are too wide.

.SH SEE ALSO
Fx_Frame(n), Fx_Menubar(n), Fx_Entry(n), Fx_QddbSearchParser(n), Fx(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
