'\"
'\" qddb/ManPages/mann/Fx_Menubar.n
'\" 
'\" Copyright (C) 1993-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx_Menubar 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
Fx_Menubar \- Build a menubar with the default buttons and menus.
.SH SYNOPSIS
.ft B
.nf
Fx_Menubar itcl_instancename -w window -schema schema_desc

.SH DESCRIPTION
Fx_Menubar builds a menubar with all the standard options and menus.

.SH OPTIONS
.TP 
\fI -schema \fR schema_desc
Sets the schema descriptor (returned by \fBqddb_schema open\fR) to
\fIschema_desc\fR for all menubar operations.  This option is
mandatory.

.TP
\fI-w\fR frame_path
Use the Tk window path \fBframe_path\fR when creating the
frame for the entry and its buttons/label.   This option is mandatory.

.TP
\fI-array\fR arrayname
Specifies the array name to use when entering any of the modes.
Each attribute declared with Fx_Entry will be bound to
\fBarrayname(attributename)\fR.   The default name for the array is
\fIgv_attr\fR.

.TP
\fI-restrict\fR directory
Restricts all configuration files and templates
to a particular directory.   Typically, this is the same application-specific
directory given by the \fI-restrict\fR option to \fBFx_Frame\fR.   The
directory need not exist, but some ancestor must be writable by the user.
The user is constrained to the \fBTemplates\fR subdirectory for template access
and the \fB:search_results:\fR subdirectory for search results configurations.

.TP
\fI-auto_clear\fR 0|1
Turns on or off the "Auto-clear" option.   This overrides the user's
configuration.

.TP
\fI-auto_save\fR 0|1
Turns on or off the "Auto-save" option.   This overrides the user's
configuration.

.TP
\fI -beforechangemode \fR list
Evaluate \fIlist\fR before entering Change Mode.   You should
be careful when using this option.

.TP
\fI -afterchangemode \fR list
Evaluate \fIlist\fR after entering Change Mode.

.TP
\fI -beforereadonlymode \fR list
Evaluate \fIlist\fR before entering Read-only Mode.   You should
be careful when using this option.

.TP
\fI -afterreadonlymode \fR list
Evaluate \fIlist\fR after entering Read-only Mode.

.TP
\fI -beforesearchmode \fR list
Evaluate \fIlist\fR before entering Search Mode.   You should
be careful when using this option.

.TP
\fI-aftersearchmode\fR list
Evaluate \fIlist\fR after entering Search Mode.

.TP
\fI-beforeaddmode\fR list
Evaluate \fI list \fR before entering Add Mode. You should
be careful when using this option.

.TP
\fI-afteraddmode\fR list
Evaluate \fI list \fR after entering Add Mode.   This
is useful for adding default values.

.TP
\fI-beforetupledelete\fR list
Evaluate \fIlist\fR before deleting the tuple.  Useful
for inserting custom dialogs.   Defaults to:
.nf
    {
        if {[tk_dialog .dialog "RECORD DELETION PENDING" \\
            "Are you SURE you want to delete this record? \\
                Click on OK to proceed, Cancel to cancel." \\
                warning 0 Cancel OK] == 0} {
            return
	}
    }

.fi

.TP
\fI-beforequit\fR list
Evaluate \fIlist\fR before closing the schema.   Useful for custom
checking or exit cleanup.

.TP
\fI-afterquit\fR list
Evaluate \fIlist\fR after closing the schema.   Useful for custom
checking or exit cleanup.

.TP
\fI-exitproc\fR list
Evaluate \fIlist\fR to exit the program.  Defaults to
"exit 0".   Useful for adding your own exit procedures.

.TP
\fI-beforesave\fR list
Evaluate \fIlist\fR before saving the tuple.   Useful for custom
checking.

.TP
\fI-aftersave\fR list
Evaluate \fIlist\fR after saving the tuple.   Useful for custom
mode switching.

.TP
\fI-aftersearch\fR list
Evaluate \fIlist\fR after performing a search and filling
the last search results internal variable.   Can be used in
conjunction with \fI-search_results 0\fR and \fIGetLastSearch\fR
to build a custom way of displaying the Search Results.

.TP
\fI-config_dir\fR directory
Default location of the user's personal configuration.  Defaults
to .fx_config.  Always prefixed by \fB ~/\fR.   You must also
set the global variable fx_config_dir to the \fB same \fR value before calling
Fx:Init.

.TP
\fI-searchfor\fR 0|1
Defines whether to show the "Search for:" entry box.  Defaults
to \fB1\fR.

.TP
\fI-modebar\fR 0|1
Defines whether to show the mode bar (showing which mode you are in).  Defaults
to \fB1\fR.

.TP
\fI-statusbar\fR 0|1
Defines whether to show the status bar (showing miscellaneous messages).  Defaults
to \fB1\fR.

.TP
\fI-menubar\fR 0|1
Defines whether to show the main menubar.  Defaults to \fB1\fR.

.TP
\fI-force_readonly_mode\fR 0|1
If 1, forces \fBRead-only Mode\fR instead of \fBChange Mode\fR; otherwise,
allows entry into \fBChange Mode\fR.  Defaults to \fB0\fR.

.TP
\fI-instances\fR list
Defines a list of Fx_Entry instances associated with this menubar.
Must be specified with the configure method \fBafter\fR all Fx_Entry
instances have been created.

.TP
\fI-frames\fR list
Defines a list of Fx_Frame instances associated with this menubar.
Must be specified with the configure method \fBafter\fR all Fx_Frame
instances have been created.

.TP
\fI-auxbuttons\fR list
Defines a list of menubuttons to pack after the \fIView\fR menubutton.

.TP 
\fI-mode_variable\fR variable_name
Specifies the -textvariable option for the mode label.  Defaults
to fx:mode_variable.   Probably should not be changed.

.TP 
\fI-status_variable\fR variable_name
Specifies the -textvariable option for the status label.  Defaults
to fx:status_variable.   Probably should not be changed.

.TP 
\fI-searchfor_variable\fR variable_name
Specifies the -textvariable option for the searchfor entry.  Defaults
to fx:searchfor_variable.   Probably should not be changed.

.TP
\fI-search_results 0|1
Specifies whether to display the last search results when the user
performs a search or when selecting \fIView Last Search Results\fR.
Defaults to \fB1\fR.

.TP
\fI-afterpost_file\fR list
Evaluate \fBlist\fR after posting the File menu.
Allows changing the default stippling.

.TP
\fI-afterpost_edit\fR list
Evaluate \fBlist\fR after posting the Edit menu.
Allows changing the default stippling.

.TP
\fI-afterpost_modes\fR list
Evaluate \fBlist\fR after posting the Modes menu.
Allows changing the default stippling.

.TP
\fI-afterpost_view\fR list
Evaluate \fBlist\fR after posting the View menu.
Allows changing the default stippling.

.TP
\fI-afterpost_templates\fR list
Evaluate \fBlist\fR after posting the Templates menu.
Allows changing the default stippling.

.TP
\fItearoffs 0|1\fR
\fBTk 4.0 only!\fR
Specifies whether the standard Fx_Menubar menus are tear-off
menus.   You should not manually override any standard
Fx_menubar menu's -tearoff value.   All menus should be the
same for consistency.   If you add your own menus to the menubar,
you should specify the -tearoff option to the Tk \fImenu\fR 
command.

.SH MISC. PUBLIC VARIABLES
There are several useful public variables for the \fBFx_Menubar\fR itcl_class.
These variables may be read with \fIinstance info public varName -value\fR.

.TP
\fIschema\fR
Contains the current schema descriptor.

.TP 
\fItuple\fR
Contains the current tuple descriptor.

.TP
\fIview\fR
Contains the current view descriptor.

.SH OPTION NOTES
The mode variable (fx:mode_variable) \fBmust\fR be one of
\fISearch Mode\fR, \fIAdd Mode\fR, \fIChange Mode\fR, or \fIRead-only Mode\fR.
Fx uses the mode variable to determine what mode it is in, so you must
take care when modifying this variable (actually, you probably shouldn't
attempt to do it at all).

.SH METHODS
.TP
\fIconfigure\fR options
Reconfigure the instance with the specified options.

.TP
\fIDisplayLastSearch\fR
Displays the results of the last search in a listbox.

.TP
\fIKillLastSearch\fR
Kills the results of the last search so that it cannot
be displayed.

.TP
\fIGetLastSearch\fR
Returns the last non-empty results of a search.
This list is in the format returned by a call to 
\fI qddb_rows select -format table\fR.

.TP
\fISetLastSearch\fR list
Sets the results of the last search to the specified list.
This list \fBmust\fR be a list returned by a call to 
\fI qddb_rows select -format table\fR.

.TP
\fILastSearchWasNull\fR
Returns \fB1\fR if the last search returned an empty
set or the query was empty; returns \fB0\fR otherwise.   This is useful
to check whether the list returned by \fIGetLastSearch\fR
is from the most recent search (generally in \fI-aftersearch\fR lists).
\fIGetLastSearch\fR returns the last \fBnon-empty\fR search
results.

.TP 
\fISearchModeProc\fR
Enters \fISearch Mode\fR after checking whether the current
tuple has been modified.  Sets the mode variable to "Search Mode".

.TP
\fIChangeModeProc\fR index
Enters \fIChange Mode\fR with the tuple located at the index
specified by \fIindex\fR in the list of last search results.
Checks to see if the current tuple has been modified first.
Locks the tuple for writing if possible; if the tuple is already
locked for writing by another process, \fIChangeModeProc\fR
will enter \fIRead-only Mode\fR.
Sets the mode variable to "Change Mode".

.TP
\fIAddModeProc\fR 
Enters \fIAdd Mode\fR after checking whether the current
tuple has been modified.
Sets the mode variable to "Add Mode".

.TP
\fISearchProc\fR
Performs a search based on the contents of the variable specified by 
-searchfor_variable and -searcharrayname.   The search is the logical
intersection of the contents of each variable.
Sets the mode variable to "Search Mode".

.TP
\fISaveProc\fR
Save the current tuple; must be in "Change Mode" or "Add Mode".

.TP
\fIQuitProc\fR
Quit after checking the need to save the current tuple.  If
the current tuple has been modified, the user will be given the
opportunity to save it.

.SH GLOBAL VARIABLES
Several global variables are available for setting miscellaneous
messages and values.     Fx uses variables of the form
\fIfx:MODE_modeval\fR to determine the current mode.  Variables
of the form \fIfx:MODE_statusval\fR are informational messages placed
in the status line when entering \fIMODE\fR.

.TP
\fIfx:search_modeval\fR
Set the value of the mode line to "${fx:search_modeval}" whenever
entering Search Mode.   The default is "Search Mode".

.TP
\fIfx:add_modeval\fR
Set the value of the mode line to "${fx:add_modeval}" whenever
entering Add Mode.   The default is "Add Mode".

.TP
\fIfx:change_modeval\fR
Set the value of the mode line to "${fx:change_modeval}" whenever
entering Change Mode.   The default is "Change Mode".

.TP
\fIfx:readonly_modeval\fR
Set the value of the mode line to "${fx:readonly_modeval}" whenever
entering Read-only Mode.   The default is "Read-only Mode".

.TP
\fIfx:search_statusval\fR
Set the value of the status line to "${fx:search_statusval}" whenever
entering Search Mode.  The default is "Ready to search".

.TP
\fIfx:add_statusval\fR
Set the value of the status line to "${fx:add_statusval}" whenever
entering Add Mode.  The default is "Ready to add new record".

.TP
\fIfx:change_statusval\fR
Set the value of the status line to "${fx:change_statusval}" whenever
entering Change Mode.  The default is "Ready to modify record".

.TP
\fIfx:readonly_statusval\fR
Set the value of the status line to "${fx:readonly_statusval}" whenever
entering Read-only Mode.  The default is "Modifications not allowed".

.SH TK WIDGETS
Fx_Menubar builds a set of predefined menubuttons in the
frame specified with \fI-w\fR (say .mb).   These are:
(1) file (File), (2) edit (Edit), (3) modes (Modes),
(4) view (View), (5) config (Configure) and (6) help (Help).
The individual menus can be augmented by accessing the
menubutton name plus \fI menu\fR.  For example: 
.nf
    .mb.help.menu add command -label "Do Something" \
        -command "DoSomething"
.fi

.SH NOTES
You must specify --with-itcl when configuring Qddb to install
the Fx toolkit.   Fx depends on [Incr Tcl].   The busy cursor
depends on BLT (configure with --with-blt).

.SH SEE ALSO
Fx_Entry(n), Fx_Frame(n), Fx_Print(n), Fx_QddbSearchParser(n), Fx(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
