'\"
'\" qddb/ManPages/mann/Fx_Frame.n
'\" 
'\" Copyright (C) 1993, 1994, 1995 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx_Frame 1 "27 Oct 1995" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 27 Oct 1995
.SH NAME
Fx_Frame \- Bind a Tk frame/label to a Qddb structured attribute
.SH SYNOPSIS
.ft B
.nf
Fx_Frame itcl_instancename -w window -attr attrname ?options?

.SH DESCRIPTION
Fx_Frame binds a Tk frame/label pair (with Add/View/Del buttons
if the attribute is expandable) to a Qddb structured attribute.   You must 
specify the  -w and -attr options for each Fx_Frame instance.

.SH OPTIONS
.TP 
\fI-setschema\fR schema_desc
Sets the schema descriptor (returned by \fBqddb_schema open\fR) to
\fIschema_desc\fR for all subsequent calls to Fx_Frame and Fx_Entry.
Need only be specified once.

.TP
\fI-w\fR frame_path
Use the Tk window path \fBframe_path\fR when creating the
frame for the entry and its buttons/label.   This is mandatory.

.TP
\fI-attr\fR attr
Declares this instance to refer to the Qddb attribute \fBattr\fR
in the current view.   This is mandatory.

.TP
\fI-restrict\fR directory
Restricts all configuration files for expandable attributes
to a particular directory.   Typically, this is the same application-specific
directory given by the \fI-restrict\fR option to \fBFx_Menubar\fR.   The
directory need not exist, but some ancestor must be writable by the user.
The user is constrained to the \fBattr_config/ATTRNAME\fR subdirectory for 
reading/writing expandable attribute configuration files, where ATTRNAME
is the name of the attribute being configured.

.TP
\fI-focus\fR TkWidg
When an instance is added, place focus in the Tk widget \fBTkWidg\fR.
Typically, this is an entry or a text box.   You can get the entry
by calling the Fx_Entry method \fIGetEntry\fR.  For example, if the
Fx_Entry instance that you want to receive focus is \fIentry_number_1\fR
and the Fx_Frame instance is \fIframe_number_1\fR, you might reconfigure
the Fx_Frame after creating its entries by:
.nf
    frame_number_1 configure -focus [entry_number_1 GetEntry]
.fi

.TP
\fI-beforeadd\fR list
Evaluate the Tcl list \fIlist\fR before adding a new instance.

.TP
\fI-beforechange\fR list
Evaluate the Tcl list \fIlist\fR before viewing a instance.

.TP
\fI-beforedelete\fR list
Evaluate the Tcl list \fIlist\fR before deleting a instance.

.TP
\fI-afteradd\fR list
Evaluate the Tcl list \fIlist\fR after adding a new instance.

.TP
\fI-afterchange\fR list
Evaluate the Tcl list \fIlist\fR after viewing a instance.

.TP
\fI-afterdelete\fR list
Evaluate the Tcl list \fIlist\fR after deleting a instance.

.TP
\fI-addtoend\fR 0|1
Add new instances to the end of the instance pool for this
attribute.   Defaults to \fB1\fR.   If 0, new instances
are added to the beginning of the instance pool (so that
more recently added instances are first).

.TP
\fI-copy_instances\fR list
When a new instance is created, copy attribute values
from the current view to the new instance.   Only attributes
in \fIlist\fR are copied.

.TP
\fI-showbutton_add\fR 0|1
If 0, do not show the \fBadd\fR button if the attribute
is expandable; otherwise, show the \fBadd\fR button.
The default is \fB1\fR.

.TP
\fI-showbutton_view\fR 0|1
If 0, do not show the \fBview\fR button if the attribute
is expandable; otherwise, show the \fBview\fR button.
The default is \fB1\fR.

.TP
\fI-showbutton_del\fR 0|1
If 0, do not show the \fBdel\fR button if the attribute
is expandable; otherwise, show the \fBdel\fR button.
The default is \fB1\fR.

.TP
\fI-button_add\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fBAdd\fR.

.TP
\fI-button_view\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fBView\fR.

.TP
\fI-button_del\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fBDel\fR.

.TP
\fI-side\fR top|bottom|left|right
Declares the side to pack the label's frame within
$w.

.TP
\fI-padx\fR padding
Declare the horizontal padding for the frame specified
with -w.

.TP
\fI-pady\fR padding
Declare the vertical padding for the frame specified
with -w.

.TP
\fI-anchor\fR e|w|s|n|ne|se|sw|nw
Specifies the anchoring for the frame containing the
label and buttons.

.TP
\fI-relief\fR sunken|raised|flat|groove
Specifies the relief of the frame specified by -w

.TP
\fI-bd\fR borderwidth
Specifies the border width of the frame specified by -w.

.TP 
\fI-labelfg\fR color
Overrides the default Fx label color (blue).

.SH OPTION NOTES
The options -button_{add,view,del}, -{before,after}{add,change,delete}
and -addtoend are only valid for expandable attributes.   The sort/print
order of the "view" button (if it exists) may be configured by clicking <Control-Button-3>
over the Fx_Frame's label.

.SH METHODS
.TP
\fIconfigure\fR options
Reconfigure the instance with the specified options.

.SH PROCEDURES
.TP
\fIGetInstances\fR
Returns all instances of Fx_Frame.

.SH TK WIDGETS
Each Fx_Frame instance contains the main frame specified
with \fI-w\fR (say .f), a subframe called \fIf_0\fR (.f.f_0),
a label \fIl\fR (.f.f_0.l), and three buttons \fIb_add\fR,
\fIb_view\fR, and \fIb_del\fR (.f.f_0.b_add, etc.) iff the
associated attribute is expandable.   You can re-pack these
Tk widgets any way you please after calling Fx_Frame.

.SH DEFAULT BINDINGS
Clicking <Control-Button-3> over the Fx_Frame's label will bring up
a dialog for configuring the view button's listbox.   If the
attribute associated with the Fx_Frame is not expandable, <Control-Button-3>
does nothing.

.SH NOTES
You must specify --with-itcl when configuring Qddb to install
the Fx toolkit.   Fx depends on [Incr Tcl]. The busy cursor
depends on --with-blt.

.SH SEE ALSO
Fx_Menubar(n), Fx_Entry(n), Fx_Print(n), Fx_QddbSearchParser(n), Fx(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
