'\"
'\" qddb/ManPages/mann/Fx_Entry.n
'\" 
'\" Copyright (C) 1993-1997 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH Fx_Entry 1 "2 Mar 1997" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 2 Mar 1997
.SH NAME
Fx_Entry \- Bind a Tk label/entry to a Qddb attribute
.SH SYNOPSIS
.ft B
.nf
Fx_Entry itcl_instancename -w window -attr attrname ?options?

.SH DESCRIPTION
Fx_Entry binds a Tk label/entry pair (with Add/View/Del buttons
if the attribute is expandable) to a Qddb attribute.   You must 
specify the  -w and -attr options for each Fx_Entry instance.

.SH OPTIONS
.TP 
\fI-setschema\fR schema_desc
Sets the schema descriptor (returned by \fBqddb_schema open\fR) to
\fIschema_desc\fR for all subsequent calls to Fx_Entry and Fx_Frame.
Should be used on the first call to Fx_Entry.   You need only specify
\fI-setschema\fR once.

.TP
\fI-searchfor_entry\fR entry_path
Specifies the Tk widget path for the "Search for:" entry.   Usually,
this is the result of a call to the Fx_Menubar instance's SearchForEntry method.
This is mandatory before searching.

.TP
\fI-w\fR frame_path
Use the Tk window path \fB frame_path \fR when creating the
frame for the entry and its buttons/label.   This is mandatory.

.TP
\fI-attr\fR attr
Declares this instance to refer to the Qddb attribute \fB attr \fR
in the current view.   This is mandatory.

.TP
\fI-beforeadd\fR list
Evaluate the Tcl list \fIlist\fR before adding a new instance.

.TP
\fI-beforechange\fR list
Evaluate the Tcl list \fIlist\fR before viewing a instance.

.TP
\fI-beforedelete\fR list
Evaluate the Tcl list \fIlist\fR before deleting a instance.

.TP
\fI-afteradd\fR list
Evaluate the Tcl list \fIlist\fR after adding a new instance.

.TP
\fI-afterchange\fR list
Evaluate the Tcl list \fIlist\fR after viewing a instance.

.TP
\fI-afterdelete\fR list
Evaluate the Tcl list \fIlist\fR after deleting a instance.

.TP
\fI-addtoend\fR 0|1
Add new instances to the end of the instance pool for this
attribute.   Defaults to \fB1\fR.

.TP
\fI-copy_instances\fR 0|1
When a new instance is added, copy the value from the
instance in the current view.

.TP
\fI-showbutton_add\fR 0|1
If 0, do not show the \fBadd\fR button if the attribute
is expandable; otherwise, show the \fBadd\fR button.
The default is \fB1\fR.

.TP
\fI-showbutton_view\fR 0|1
If 0, do not show the \fBview\fR button if the attribute
is expandable; otherwise, show the \fBview\fR button.
The default is \fB1\fR.

.TP
\fI-showbutton_del\fR 0|1
If 0, do not show the \fBdel\fR button if the attribute
is expandable; otherwise, show the \fBdel\fR button.
The default is \fB1\fR.

.TP
\fI-button_add\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fBAdd\fR.

.TP
\fI-button_view\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fB View\fR.

.TP
\fI-button_del\fR text|bitmap
If the first character in the value is '@', then Fx assumes
it is a bitmap and the following characters specify the path
to the bitmap file.   Otherwise, it is assumed to be text.
The default is \fBDel\fR.

.TP
\fI-side\fR top|bottom|left|right
Declares the side to pack the entry's label.

.TP
\fI-padx\fR padding
Declare the horizontal padding for the frame specified
with -w.

.TP
\fI-pady\fR padding
Declare the vertical padding for the frame specified
with -w.

.TP
\fI-anchor\fR e|w|s|n|ne|se|sw|nw
Specifies the anchoring for the frame containing the
label and buttons.

.TP
\fI-relief\fR sunken|raised|flat|groove
Specifies the relief of the frame specified by -w

.TP
\fI-bd\fR borderwidth
Specifies the border width of the frame specified by -w.

.TP
\fI-entryfg\fR color
Overrides the Entry standard foreground.

.TP 
\fI-labelfg\fR color
Overrides the default Fx label color (blue).

.TP
\fI-type\fR Entry|Text|Radiobutton
Specifies the type of Tk widget to use for the entry.

.TP
\fI-height\fR num
Specifies the height for the entry (only valid for -type Text).

.TP
\fI -width\fR num
Specifies the width for the entry (only valid for -type Entry|Text).

.TP
\fI-default_values\fR list
Specifies a Tcl list of values to use iff the type of the entry
is Radiobutton.

.TP
\fI-read_only\fR 0|1
If 1, the entry will be disabled in all modes except Search Mode.

.TP
\fI-mandatory\fR 0|1
If 1, the entry will be mandatory and Fx will not allow the user
to add/view/del instances or save the record unless the entry is
populated.

.TP
\fI-unique\fR 0|1
If 1, the entry must have a unique value; otherwise, the entry
need not have a unique value.   You should take extra care when
using this option.   Uniqueness is checked with \fBqddb_search $schema word\fR,
so you must make sure that the attribute's \fIseparator\fR option is properly
set in the Schema file.

.TP
\fI-regexp_search\fR 0|1
Allow regular expression searching if 1, disallow otherwise.

.TP
\fI-range_search\fR 0|1
Allow range searching if 1, disallow otherwise.

.TP
\fI-numeric_search\fR 0|1
Allow numeric searching if 1, disallow otherwise.

.TP
\fI-date_search\fR 0|1
Allow date searching if 1, disallow otherwise.   Attribute must be of
type date.

.TP
\fI-userconfig\fR 0|1
If 1, the user will be allowed to modify the entry's form (height, width,
type, mandatory, read-only).

.SH OPTION NOTES
The options -button_{add,view,del}, -{before,after}{add,change,delete}
and -addtoend are only valid for expandable attributes.   The -height, -width,
-type and -default_values may be set at run time by clicking <Control-Button-3>
over the label associated with the entry.

.SH METHODS
.TP
\fIconfigure\fR options
Reconfigure the instance with the specified options.

.TP
\fIAddInstance\fR
Add an instance to the attribute associated with this Fx_Entry.

.TP
\fIDelInstance\fR
Delete the instance of the attribute associated with this
Fx_Entry in the current view.

.TP
\fIViewInstance\fR
View the instance of the attribute associated with this
Fx_entry in the current view.

.SH PROCEDURES
.TP
\fIGetInstances\fR
Returns all instances of Fx_Entry.

.TP
\fIAfterReconfigure\fR list
Evaluate list after reconfiguring any Fx_Entry.  Mostly used for
resizing a canvas in scrollable applications.

.TP
\fIScrollbarSide\fR left|right
Set the default side for a Text entry's scrollbar.

.TP
\fITupleChanged\fR ?0|1?
If no argument is given, \fITupleChanged\fR returns the
whether the current tuple has been modified.   If an argument
is given, \fITupleChanged\fR sets whether the current tuple
has been modified.

.SH TK WIDGETS
Each Fx_Entry instance contains the main frame specified
with \fI-w\fR (say .f), a subframe called \fIf_0\fR (.f.f_0),
a label \fIl\fR (.f.f_0.l), and three buttons \fIb_add\fR,
\fIb_view\fR, and \fIb_del\fR (.f.f_0.b_add, etc.) iff the
associated attribute is expandable.   Text and Entry types are
named \fIe\fR (.f.e); Radiobuttons are 
placed in a frame \fIe.t\fR (.f.e.t) and are called \fI.e.t.rX\fR
where \fIX\fR is an integer beginning with 0.    \fI.f.e\fR is a frame,
and \fI.f.e.t\fR is a text widget if the height is greater than one.    
If you have multiple lines of radiobuttons, then there is also a 
scrollbar \fI.f.e.s\fR.
You can re-pack these Tk widgets any way you please after calling Fx_Entry.

.SH DEFAULT BINDINGS
Clicking <Control-Button-3> over the Fx_Entry's label will bring up
a dialog for entering the -type, -mandatory, -read-only, -width,
-height, and -default_values options.

.SH NOTES
You must specify --with-itcl when configuring Qddb to install
the Fx toolkit.   Fx depends on [Incr Tcl].  The busy cursor
depends on --with-blt.

.SH SEE ALSO
Fx_Menubar(n), Fx_Frame(n), Fx_Print(n), Fx_QddbSearchParser(n), Fx(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

Qddb User's Guide

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

Schema and Tuple Trees: An Intuitive Structure for 
Representing Relational Data
Eric H. Herrin, II and Raphael A. Finkel
Computing Systems, Volume 9, Number 2
MIT Press, Cambridge MA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
