%{

/* qddb/Lib/LibQddb/TableParse.y 
 * Bison/yacc grammar file for the Qddb Table calculated
 * fields.
 *
 * Copyright (C) 1996 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* Define yyparse() to be EntryParse() so that multiple parsers can
 * occupy the same executable.
 */
int yyerror _ANSI_ARGS_((char *));

#define yyparse	TableParse
#define yylex   Tablelex

int yylex();

static Qddb_TableCalc 	*compiled;
static int		numcompiled;

static void NewCalcOp _ANSI_ARGS_((int, char *));
static void NewCalcNumVal _ANSI_ARGS_((double));
static void NewCalcStrVal _ANSI_ARGS_((char *));

%}
%expect 6
%pure_parser

%token LPAREN 300 RPAREN 301 COMMA 302 COLON 303 ATSIGN 304
%left MOD 305
%left PLUS 306 MINUS 307
%left MULT 308 DIV 309
%left NEGATE 310
%token SUM 311 AVG 312 OP_MIN 313 OP_MAX 314
%token COUNT 315 STDDEV 316
%token SQRT 317 EXP 318 LN 319 LOG 320 FLOOR 321 
%token CEIL 322 RND 323 ROUND 324 POWER 325 TOK_PI 326
%token ABS 327 HYPOT 328
%token DEGREES 329 RADIANS 330
%token SIN 331 COS 332 TAN 333
%token ASIN 334 ACOS 335 ATAN 336 ATAN2 337
%token THISROW 338 THISCOL 339 CELLVAL 340
%token STRING 341 CSTRING 342
%token SVALUE 343 NVALUE 344
%token RANGE 345 CELL 346 ROW 347 COL 348
%token NUMBER 349
%left LOGICAL_NOT 350
%left EQ 351 LT 352 GT 353 LE 354 GE 355 NE 356
%left LOGICAL_AND 357 LOGICAL_OR 358
%token IF 359
%token MAXROW 360 MAXCOL 361
%token PROD 362

%type <Real>		NumericFunc NumericScalar NUMBER
%type <String>		RowCol
%type <String>		STRING CSTRING

%type <Integer>		NumericFuncType1 NumericFuncType2 NumericFuncType3
%type <Integer>		LogicalCmp LogicalOp

%union {
    int		Integer;
    double	Real;
    char	*String;
};

%%

all:
    NumericExpr {
	NewCalcOp(0, NULL); /* terminate */
    };

RowCol:
    NumericExpr {
    } |
    STRING {
	NewCalcStrVal($1);
    };

MiniRange:
    RANGE LPAREN RowCol COMMA RowCol COLON RowCol COMMA RowCol RPAREN {
	NewCalcOp(RANGE, NULL);
    } |
    RANGE LPAREN STRING COMMA RowCol COMMA RowCol COLON RowCol COMMA RowCol RPAREN {
	NewCalcOp(RANGE, $3);
    } |
    CELL LPAREN RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELL, NULL);
    } |
    CELL LPAREN STRING COMMA RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELL, $3);
    } |
    ROW LPAREN RowCol RPAREN {
	NewCalcOp(ROW, NULL);
    } |
    ROW LPAREN STRING COMMA RowCol RPAREN {
	NewCalcOp(ROW, $3);
    } |
    COL LPAREN RowCol RPAREN {
	NewCalcOp(COL, NULL);
    } |
    COL LPAREN STRING COMMA RowCol RPAREN {
	NewCalcOp(COL, $3);
    } |
    ATSIGN LPAREN RowCol COMMA RowCol COLON RowCol COMMA RowCol RPAREN {
	NewCalcOp(RANGE, NULL);
    } |
    ATSIGN LPAREN STRING COMMA RowCol COMMA RowCol COLON RowCol COMMA RowCol RPAREN {
	NewCalcOp(RANGE, $3);
    } |
    ATSIGN LPAREN RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELL, NULL);
    } |
    ATSIGN LPAREN STRING COMMA RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELL, $3);
    };

Range:
    MiniRange {
    } |
    Range COMMA MiniRange {
    };

NumericScalar:
    NUMBER {
	NewCalcNumVal($1);
    } |
    TOK_PI {
	NewCalcNumVal(M_PI);
    } |
    THISROW {
	NewCalcOp(THISROW, NULL);
    } |
    THISCOL {
	NewCalcOp(THISCOL, NULL);
    } |
    MAXROW {
	NewCalcOp(MAXROW, NULL);
    } |
    MAXCOL {
	NewCalcOp(MAXCOL, NULL);
    };

NumericExpr:
    NumericScalar {
    } |
    NumericFunc {
    } |
    IF LPAREN LogicalExpr COMMA NumericExpr COMMA NumericExpr RPAREN {
	NewCalcOp(IF, NULL);
    } |
    IF LPAREN STRING COMMA LogicalExpr COMMA NumericExpr COMMA NumericExpr RPAREN {
	NewCalcOp(IF, $3);
    } |
    NumericExpr MOD NumericExpr {
	NewCalcOp(MOD, NULL);
    } |
    NumericExpr PLUS NumericExpr {
	NewCalcOp(PLUS, NULL);
    } |
    NumericExpr MINUS NumericExpr {
	NewCalcOp(MINUS, NULL);
    } |
    NumericExpr MULT NumericExpr {
	NewCalcOp(MULT, NULL);
    } |
    NumericExpr DIV NumericExpr {
	NewCalcOp(DIV, NULL);
    } |
    MINUS NumericExpr %prec NEGATE {
	NewCalcOp(NEGATE, NULL);
    } |
    LPAREN NumericExpr RPAREN {
    };

NumericFunc:
    NumericFuncType1 LPAREN Range RPAREN {
	NewCalcOp($1, NULL);
    } |
    NumericFuncType1 LPAREN STRING COMMA Range RPAREN {
	NewCalcOp($1, $3);
    } |
    NumericFuncType2 LPAREN NumericExpr RPAREN {
	NewCalcOp($1, NULL);
    } |
    NumericFuncType3 LPAREN NumericExpr COMMA NumericExpr RPAREN {
	NewCalcOp($1, NULL);
    } |
    CELLVAL LPAREN RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELLVAL, NULL);
    } |
    CELLVAL LPAREN STRING COMMA RowCol COMMA RowCol RPAREN {
	NewCalcOp(CELLVAL, $3);
    };


NumericFuncType1:
    NVALUE {
	$$ = NVALUE;
    } |
    SUM {
	$$ = SUM;
    } |
    AVG {
	$$ = AVG;
    } |
    OP_MIN {
	$$ = OP_MIN;
    } |
    OP_MAX {
	$$ = OP_MAX;
    } |
    COUNT {
	$$ = COUNT;
    } |
    STDDEV {
	$$ = STDDEV;
    } | 
    PROD {
	$$ = PROD;
    };

NumericFuncType2:
    SQRT {
	$$ = SQRT;
    } |
    EXP {
	$$ = EXP;
    } |
    LN {
	$$ = LN;
    } |
    LOG {
	$$ = LOG;
    } |
    FLOOR {
	$$ = FLOOR;
    } |
    CEIL {
	$$ = CEIL;
    } |
    DEGREES {
	$$ = DEGREES;
    } |
    RADIANS {
	$$ = RADIANS;
    } |
    SIN {
	$$ = SIN;
    } |
    COS {
	$$ = COS;
    } |
    TAN {
	$$ = TAN;
    } |
    ASIN {
	$$ = ASIN;
    } |
    ACOS {
	$$ = ACOS;
    } |
    ATAN {
	$$ = ATAN;
    } |
    ABS {
	$$ = ABS;
    } |
    RND {
	$$ = RND;
    };

NumericFuncType3:
    ATAN2 {
	$$ = ATAN2;
    } |
    ROUND {
	$$ = ROUND;
    } |
    POWER {
	$$ = POWER;
    } |
    HYPOT {
	$$ = HYPOT;
    };

LogicalExpr:
    NumericExpr LogicalCmp NumericExpr {
	NewCalcOp($2, NULL);
    } |
    LogicalExpr LogicalOp LogicalExpr {
	NewCalcOp($2, NULL);
    } |
    LOGICAL_NOT LogicalExpr {
	NewCalcOp(LOGICAL_NOT, NULL);
    } |
    LPAREN LogicalExpr RPAREN {
    };

LogicalCmp:
    EQ {
	$$ = EQ;
    } |
    LT {
	$$ = LT;
    } |
    GT {
	$$ = GT;
    } |
    LE {
	$$ = LE;
    } |
    GE {
	$$ = GE;
    } |
    NE {
	$$ = NE;
    };

LogicalOp:
    LOGICAL_AND {
	$$ = LOGICAL_AND;
    } |
    LOGICAL_OR {
	$$ = LOGICAL_OR;
    };

%%

static void NewCalcNumVal(val)
    double		val;
{
    Qddb_TableCalc	*thiscalc;

    numcompiled++;
    if (compiled == NULL) {
	compiled = (Qddb_TableCalc *)Calloc(sizeof(Qddb_TableCalc));
    } else {
	compiled = (Qddb_TableCalc *)Realloc(compiled, sizeof(Qddb_TableCalc)*numcompiled);
    }
    thiscalc = compiled + numcompiled - 1;
    thiscalc->table = NULL;
    thiscalc->op = NVALUE;
    thiscalc->numval = val;
    thiscalc->strval = NULL;
}

static void NewCalcStrVal(val)
    char		*val;
{
    Qddb_TableCalc	*thiscalc;

    numcompiled++;
    if (compiled == NULL) {
	compiled = (Qddb_TableCalc *)Calloc(sizeof(Qddb_TableCalc));
    } else {
	compiled = (Qddb_TableCalc *)Realloc(compiled, sizeof(Qddb_TableCalc)*numcompiled);
    }
    thiscalc = compiled + numcompiled - 1;
    thiscalc->table = NULL;
    thiscalc->op = SVALUE;
    thiscalc->numval = 0.00;
    thiscalc->strval = val;
}

static void NewCalcOp(op, table)
    int			op;
    char		*table;
{
    Qddb_TableCalc	*thiscalc;

    numcompiled++;
    if (compiled == NULL) {
	compiled = (Qddb_TableCalc *)Calloc(sizeof(Qddb_TableCalc));
    } else {
	compiled = (Qddb_TableCalc *)Realloc(compiled, sizeof(Qddb_TableCalc)*numcompiled);
    }
    thiscalc = compiled + numcompiled - 1;
    thiscalc->op = op;
    thiscalc->table = table;
    thiscalc->numval = 0.00;
    thiscalc->strval = NULL;
}

void Qddb_ResetTableParser()
{
    compiled = NULL;
    numcompiled = 0;
    Qddb_ResetTableLex();
}

Qddb_TableCalc *Qddb_GetTableParserResults()
{
    return compiled;
}
