%{

/* qddb/Lib/LibQddb/TableLex.l
 * Uses 'flex' fast lexical analyzer.  Not compatible with lex at all!
 *
 * Copyright (C) 1996 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"
#include "TableParse.h"

/* Redefine the YY_DECL from yylex() to the needed yylex() with parameters
 * for bison's pure_parser directive.  This is very flex specific code,
 * so don't try to use lex with it!!
 */

#ifdef	YY_DECL
#	undef 		YY_DECL
#endif
#define YY_DECL		int yylex(yylvalp) \
                                  YYSTYPE		*yylvalp;
#ifdef yywrap
#	undef		yywrap
#endif

#if defined(YY_INPUT)
#undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size) \
{ \
    int c = Qddb_ReadBuffer(buf, (size_t)max_size); \
    result = (c == 0) ? YY_NULL : c; \
}


int yywrap();

extern  int LineNumber;

%}
a	[aA]
b	[bB]
c	[cC]
d	[dD]
e	[eE]
f	[fF]
g	[gG]
h	[hH]
i	[iI]
j	[jJ]
k	[kK]
l	[lL]
m	[mM]
n	[nN]
o	[oO]
p	[pP]
q	[qQ]
r	[rR]
s	[sS]
t	[tT]
u	[uU]
v	[vV]
w	[wW]
x	[xX]
y	[yY]
z	[zZ]
%%

@{s}{u}{m}                              return SUM;
@{a}{v}{g}                              return AVG;
@{m}{i}{n}                              return OP_MIN;
@{m}{a}{x}                              return OP_MAX;
@{c}{o}{u}{n}{t}                        return COUNT;
@{s}{t}{d}{d}{e}{v}                     return STDDEV;
@{p}{r}{o}{d}                           return PROD;
@{s}{q}{r}{t}                           return SQRT;
@{e}{x}{p}                              return EXP;
@{l}{n}                                 return LN;
@{l}{o}{g}                              return LOG;
@{f}{l}{o}{o}{r}                        return FLOOR;
@{c}{e}{i}{l}                           return CEIL;
@{r}{n}{d}                              return RND;
@{r}{o}{u}{n}{d}                        return ROUND;
@{p}{o}{w}                              return POWER;
@{p}{i}                                 return TOK_PI;
@{a}{b}{s}                              return ABS;
@{h}{y}{p}{o}{t}                        return HYPOT;
@{d}{e}{g}{r}{e}{e}{s}                  return DEGREES;
@{r}{a}{d}{i}{a}{n}{s}                  return RADIANS;
@{s}{i}{n}                              return SIN;
@{c}{o}{s}                              return COS;
@{t}{a}{n}                              return TAN;
@{a}{s}{i}{n}                           return ASIN;
@{a}{c}{o}{s}                           return ACOS;
@{a}{t}{a}{n}2                          return ATAN2;
@{a}{t}{a}{n}                           return ATAN;
@{t}{h}{i}{s}{r}{o}{w}                  return THISROW;
@{t}{h}{i}{s}{c}{o}{l}                  return THISCOL;
@{c}{e}{l}{l}{v}{a}{l}                  return CELLVAL;
@{s}{v}{a}{l}{u}{e}                     return SVALUE;
@{n}{v}{a}{l}{u}{e}                     return NVALUE;
@{r}{a}{n}{g}{e}                        return RANGE;
@{c}{e}{l}{l}                           return CELL;
@{r}{o}{w}                              return ROW;
@{c}{o}{l}                              return COL;
@{i}{f}                                 return IF;
@{m}{a}{x}{r}{o}{w}                     return MAXROW;
@{m}{a}{x}{c}{o}{l}                     return MAXCOL;

@                                       return ATSIGN;

[\$a-zA-Z][a-zA-Z0-9\.\_\-]* 	{
					yylvalp->String = Malloc((size_t)yyleng+1);
					strcpy(yylvalp->String, yytext);
					return STRING;
				}

(([0-9]*\.[0-9]+)|([0-9]+\.?[0-9]*)) {
                                        yylvalp->Real = atof(yytext);
                                        return NUMBER;
                                }

\"\"				{
					yylvalp->String = Malloc(1);
					yylvalp->String[0] = '\0';
					return CSTRING;
				}

\"				{
                                        char	*Buf;
					int	i, Index;
                                        size_t  bufsiz;
					
					Buf = Malloc(BUFSIZ);
					bufsiz = BUFSIZ;
					Index = 0;
RestartDoubleQuote:
					while ((i=input()) != '"') {
					    if (i == EOF) {
						REJECT;
					    } else {
						if (Index >= bufsiz-3)
						    Buf = Realloc(Buf, bufsiz+=BUFSIZ);
						Buf[Index] = i;
						Index++;
					    }
					}
					Buf[Index] = '\0';
					if (Index != 0 && Buf[Index-1] == '\\') {
					    Buf[Index-1] = '"';
					    goto RestartDoubleQuote;
					}
					Buf = Realloc(Buf, (size_t)Index+1);
					yylvalp->String = Buf;
					return CSTRING;
				}

"("				return LPAREN;
")"				return RPAREN;
"+"                             return PLUS;
"-"                             return MINUS;
"*"                             return MULT;
"/"                             return DIV;
"%"                             return MOD;
","				return COMMA;
":"                             return COLON;
"="				return EQ;
">"                             return GT;
"<"                             return LT;
">="                            return GE;
"<="                            return LE;
"!="                            return NE;
"&"                             return LOGICAL_AND;
"|"                             return LOGICAL_OR;
"!"                             return LOGICAL_NOT;
\#.*$                           ;
\n				LineNumber++;
[\ \t\b\r]+			;

%%

void Qddb_ResetTableLex()
{
    LineNumber = 1;
    yy_init = 1;		/* whether we need to initialize */
    yy_start = 0;		/* start state number */
    yyin = yyout = (FILE *)NULL;
    if (yy_current_buffer)
        YY_FLUSH_BUFFER;
    return;
}

/* end of file TableLex.l */

#undef yyunput
#undef yy_push_state
#undef yy_pop_state
#undef yy_top_state
