%{

/* qddb/Lib/LibQddb/TCLParse.y 
 * Bison grammar file for the Qddb Entry parser for the TCL form 
 * of a tuple.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* Define yyparse() to be EntryParse() so that multiple parsers can
 * occupy the same executable.
 */
#define yyparse	TCLParse
#define yylex   TCLlex

int yylex();

static Schema		*CurrentSchema;
static InCoreEntry	*CurrentEntries = NULL;
static unsigned int	CurrentEntriesLength;

void Qddb_TCLParse_Set(schema)
    Schema		*schema;
{
    CurrentSchema = schema;
}

InCoreEntry *Qddb_TCLParse_Get()
{
    return CurrentEntries;
}

static unsigned int	CurrentAttribute = 0;

static unsigned int	CurrentAncestors[MAXIMUM_NUMBER_OF_SCHEMA_LEVELS];
static unsigned int	CurrentInstances[MAXIMUM_NUMBER_OF_SCHEMA_LEVELS];
static unsigned int	CurrentLevel = 1;
%}

%pure_parser
%expect 2

%token STRING CSTRING
%token LBRACE RBRACE 
%token NUMBER

%type <String>		STRING CSTRING
%type <Integer>		String Cstring 

%union {
    char	*String;
    double	Real;
    int		Integer;
};


%%

FileOfEntries:
    WholeEntry {
    } |
    WholeEntry FileOfEntries {
    };

WholeEntry:
    UniqueSequenceNumber Entry {
	CurrentEntriesLength = CurrentAttribute;
	CurrentEntries[CurrentAttribute+1].SequenceNumber = 0;
	CurrentAttribute = 0;
    };

Entry:
    /* return an TEMPLATE */
    Record {
    } |
    Record Entry {
    };

Record:
    /* return an INSTANCE */
    IndividualRecord {
    } |
    IndividualRecord Record {

    };

IndividualRecord:
    /* return a TEMPLATE */
    LBRACE Cstring RBRACE {
    } |
    LbraceString Record RBRACE {
	CurrentLevel--;
    };

LbraceString:
    LBRACE String {
	CurrentLevel++;
	CurrentAttribute--;
    };

String:
    STRING {
	SchemaNode	*ThisAttribute;
	int		AttrNo, TCL_FindAttribute();
	int		i;

    	/* return an INSTANCE */
	AttrNo = TCL_FindAttribute($1);
	if (AttrNo < 0) {
	    fprintf(stderr, "  Attribute named '%s' is either misplaced or it is\n", $1);
	    fprintf(stderr, "not an attribute name in Schema\n");
	    YYERROR;
	}

	ThisAttribute = CurrentSchema->Entries+AttrNo;
	CurrentEntries[CurrentAttribute].BytesOfData = 0;
	CurrentEntries[CurrentAttribute].AttributeNumber = AttrNo;
	$$ = ThisAttribute->Number;
	if (CurrentAncestors[CurrentLevel] != ThisAttribute->Number) {
	    CurrentInstances[CurrentLevel] = 1;
	} else
	    CurrentInstances[CurrentLevel]++;
	CurrentAncestors[CurrentLevel] = ThisAttribute->Number;
	for (i = 1; i <= CurrentLevel; i++)
	    CurrentEntries[CurrentAttribute].Instance[i] = CurrentInstances[i];
	CurrentAttribute++;
    };

Cstring:
    STRING CSTRING {
	SchemaNode	*ThisAttribute;
	int		AttrNo, TCL_FindAttribute();
	int		i;

	AttrNo = TCL_FindAttribute($1);
	if (AttrNo < 0) {
	    fprintf(stderr, "  Attribute named '%s' is either misplaced or it is\n", $1);
	    fprintf(stderr, "not an attribute name in Schema\n");
	    YYERROR;
	}	
	ThisAttribute = CurrentSchema->Entries+AttrNo;
	CurrentEntries[CurrentAttribute].AttributeNumber =
	    AttrNo;
	CurrentEntries[CurrentAttribute].Data = $2;
	CurrentEntries[CurrentAttribute].BytesOfData = strlen($2);
	$$ = ThisAttribute->Number;
	if (CurrentAncestors[CurrentLevel] != ThisAttribute->Number) {
	    CurrentInstances[CurrentLevel] = 1;
	} else
	    CurrentInstances[CurrentLevel]++;
	CurrentAncestors[CurrentLevel] = ThisAttribute->Number;
	for (i = 1; i <= CurrentLevel; i++)
	    CurrentEntries[CurrentAttribute].Instance[i] = CurrentInstances[i];
	CurrentAttribute++;
    };

UniqueSequenceNumber:
    LBRACE NUMBER CSTRING RBRACE {
	InCoreEntry		*NewEntry;

	NewEntry = (InCoreEntry *)Malloc(sizeof(InCoreEntry)*MAXIMUM_SCHEMA_ENTRY);
	CurrentEntries = NewEntry;
	CurrentEntriesLength = 0;
	CurrentAttribute = 0;
	NewEntry[0].SequenceNumber = atoi($3);
	NewEntry[0].BytesOfData = 0;
	NewEntry[0].AttributeNumber = 0;
    };
%%

int TCL_FindAttribute(string)
    char		*string;
{
    unsigned int	i, j;

    for (i = 1; i <= CurrentSchema->NumberOfAttributes; i++) {
	if (strcmp(string, CurrentSchema->Entries[i].Name) == 0) {
	    /* this is a possibility.. */
	    if (CurrentLevel != CurrentSchema->Entries[i].Level) {
		continue;
	    }
	    /* Check out the ancestors */
	    if (CurrentSchema->Entries[i].Level != CurrentLevel)
		continue;
	    for (j = 0; j < CurrentLevel; j++) {
		if (CurrentSchema->Entries[i].AncestorNumber[j] != 
		    CurrentAncestors[j]) {
		    break;
		}
	    }
	    if (j != CurrentLevel) {
		continue;
	    }
	    return i;
	}
    }
    return -1;
}

void Qddb_ResetTCLParser()
{
    if (CurrentEntries != NULL) {
	Free(CurrentEntries);
	CurrentEntries = NULL;
    }
    CurrentAttribute = 0;
    CurrentLevel = 1;
    CurrentInstances[0] = 0;
    CurrentAncestors[0] = 0;
    Qddb_ResetTCLLex();
}
