%{

/* qddb/Lib/LibQddb/TCLLex.l
 * Uses 'flex' fast lexical analyzer.  Not compatible with lex at all!
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"
#include "TCLParse.h"

/* Redefine the YY_DECL from yylex() to the needed yylex() with parameters
 * for bison's pure_parser directive.  This is very flex specific code,
 * so don't try to use lex with it!!
 */
#ifdef	YY_DECL
#	undef 		YY_DECL
#endif
#define YY_DECL		int yylex(yylvalp) \
                                  YYSTYPE		*yylvalp;
#ifdef yywrap
#	undef		yywrap
#endif
int yywrap();

#if defined(YY_INPUT)
#undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size) \
{ \
    int c = Qddb_ReadBuffer(buf, (size_t)max_size); \
    result = (c == 0) ? YY_NULL : c; \
}

extern int LineNumber;
%}
a	[aA]
b	[bB]
c	[cC]
d	[dD]
e	[eE]
f	[fF]
g	[gG]
h	[hH]
i	[iI]
j	[jJ]
k	[kK]
l	[lL]
m	[mM]
n	[nN]
o	[oO]
p	[pP]
q	[qQ]
r	[rR]
s	[sS]
t	[tT]
u	[uU]
v	[vV]
w	[wW]
x	[xX]
y	[yY]
z	[zZ]
%%
\$NUMBER\$                      {
                                    return NUMBER;
                                }
[a-zA-Z][a-zA-Z0-9\_\-]* 	{
                                    yylvalp->String = Malloc((size_t)yyleng+1);
				    strcpy(yylvalp->String, yytext);
				    return STRING;
				}


\"\"				{
                                    yylvalp->String = Malloc((size_t)yyleng+1);
				    yylvalp->String[0] = '\0';
				    return CSTRING;
				}

\"				{
				    char	Buf[MAX_ATTRIBUTE_SIZE];
				    int	i, Index;
					
				    Index = 0;
RestartDoubleQuote:
				    while ((i=input()) != '"')
					if (i == EOF) {
					    REJECT;
					} else {
					    if (i == '\n') {
						Buf[Index++] = '\\';
						Buf[Index++] = '\n';
					    } else
						Buf[Index++] = i;
					}
				    if ((Index != 0) && 
					(Buf[Index-1] == '\\')) {
					Buf[Index++] = '"';
					goto RestartDoubleQuote;
				    }
				    Buf[Index] = '\0';
				    yylvalp->String = Malloc(strlen(Buf)+1);
				    strcpy(yylvalp->String, Buf);
				    return CSTRING;
				}

\#.*				/* comments */ ;
"{"				return LBRACE;
"}"				return RBRACE;
\n				LineNumber++;
[\ \t\b\r;]+			;

%%

void Qddb_ResetTCLLex()
{
    LineNumber = 1;
    yy_init = 1;		/* whether we need to initialize */
    yy_start = 0;		/* start state number */
    yyin = yyout = (FILE *)NULL;
    if (yy_current_buffer)
        YY_FLUSH_BUFFER;
}

/* end of file TCLLex.l */

#undef yyunput
#undef yy_push_state
#undef yy_pop_state
#undef yy_top_state

