
/* Sort.c - Sort entries.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

static Schema *schema;

int CompareInCoreEntries(e1, e2)
    InCoreEntry		*e1, *e2;
{
    SchemaNode		*sch1, *sch2;
    size_t		attr1, attr2, min, level1, level2, inst1, inst2, i;
    size_t		LastLevel1, LastLevel2;

    attr1 = e1->AttributeNumber;
    attr2 = e2->AttributeNumber;
#if defined(DIAGNOSTIC)
    if (attr1 > schema->NumberOfAttributes) {
	char		buf[BUFSIZ];

	sprintf(buf, "CompareInCoreEntries: e1->AttributeNumber == %d\n", (int)attr1);
	PANIC(buf);
    }
#endif
    sch1 = schema->Entries + attr1;
#if defined(DIAGNOSTIC)
    if (attr2 > schema->NumberOfAttributes) {
	char		buf[BUFSIZ];

	sprintf(buf, "CompareInCoreEntries: e2->AttributeNumber == %d\n", (int)attr2);
	PANIC(buf);
    }
#endif
    sch2 = schema->Entries + attr2;
    if (sch1->Level < sch2->Level) {
	min = sch1->Level;
	LastLevel1 = sch1->Number;
	LastLevel2 = sch2->AncestorNumber[min];
    } else if (sch1->Level > sch2->Level) {
	min = sch2->Level;
	LastLevel1 = sch1->AncestorNumber[min];
	LastLevel2 = sch2->Number;
    } else {
	min = sch1->Level;
	LastLevel1 = sch1->Number;
	LastLevel2 = sch2->Number;
    }
    if (sch1->Level == 1 && sch2->Level == 1) {
	level1 = LastLevel1;
	level2 = LastLevel2;
    } else if (sch1->Level == 1) {
	level1 = LastLevel1;
	level2 = sch2->AncestorNumber[1];
    } else if (sch2->Level == 1) {
	level1 = sch1->AncestorNumber[1];
	level2 = LastLevel2;
    } else {
	level1 = sch1->AncestorNumber[1];
	level2 = sch2->AncestorNumber[1];
    }
    for (i = 0; i < min; i++) {
	if (level1 < level2)
	    return -1;
	else if (level1 > level2)
	    return 1;
	if (i < min-2) {
	    level1 = sch1->AncestorNumber[i+2];
	    level2 = sch2->AncestorNumber[i+2];
	} else if (i == min-2) {
	    level1 = LastLevel1;
	    level2 = LastLevel2;
	}
	inst1 = e1->Instance[i];
	inst2 = e2->Instance[i];
	if (inst1 < inst2) 
	    return -1;
	else if (inst1 > inst2)
	    return 1;
    }
    return 0;
}

void Qddb_SortInCoreEntries(TheSchema, TheEntry)
    Schema			*TheSchema;
    InCoreEntry			*TheEntry;
{
    size_t			len;
    InCoreEntry			*e;
	
    if (TheEntry == NULL)
	return;
    schema = TheSchema;
    len = 0;
    e = TheEntry;
    while (e->SequenceNumber != 0) {
	len++;
	e++;
    }
    qsort(TheEntry, len, sizeof(InCoreEntry), 
	  (int (*) _ANSI_ARGS_((const void *, const void *)))CompareInCoreEntries);
}
