%{

/* qddb/Lib/LibQddb/SchemaLex.l
 * Uses 'flex' fast lexical analyzer.  Not compatible with lex at all!
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"
#include "SchParse.h"

/* Redefine the YY_DECL from yylex() to the needed yylex() with parameters
 * for bison's pure_parser directive.  This is very flex specific code,
 * so don't try to use lex with it!!
 */

#ifdef	YY_DECL
#	undef 		YY_DECL
#endif
#define YY_DECL		int yylex(yylvalp) \
                                  YYSTYPE		*yylvalp;
#ifdef yywrap
#	undef		yywrap
#endif

#if defined(YY_INPUT)
#undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size) \
{ \
    int c = Qddb_ReadBuffer(buf, (size_t)max_size); \
    result = (c == 0) ? YY_NULL : c; \
}


int yywrap();

int LineNumber = 1;
%}
a	[aA]
b	[bB]
c	[cC]
d	[dD]
e	[eE]
f	[fF]
g	[gG]
h	[hH]
i	[iI]
j	[jJ]
k	[kK]
l	[lL]
m	[mM]
n	[nN]
o	[oO]
p	[pP]
q	[qQ]
r	[rR]
s	[sS]
t	[tT]
u	[uU]
v	[vV]
w	[wW]
x	[xX]
y	[yY]
z	[zZ]
%%

\${n}{u}{m}{b}{e}{r}\$			return NUMBER;

{a}{l}{i}{a}{s}				return ALIAS;

{v}{e}{r}{b}{o}{s}{e}{n}{a}{m}{e}	return VERBOSENAME;

{d}{e}{f}{a}{u}{l}{t}{v}{a}{l}{u}{e}	return DEFAULTVALUE;

{t}{y}{p}{e}				return TYPE;

{u}{s}{e}                               return USE;

{h}{a}{s}{h}{s}{i}{z}{e}                return HASHSIZE;

{h}{a}{s}{h}{t}{y}{p}{e}                return HASHTYPE;

{c}{a}{c}{h}{e}{d}                      return CACHED;

{s}{e}{c}{o}{n}{d}{a}{r}{y}             return SECONDARY;

{s}{e}{a}{r}{c}{h}                      return SEARCH;

{h}{a}{s}{h}{i}{n}{g}                   return HASHING;

{r}{e}{d}{u}{c}{e}{d}                   return REDUCED;

{a}{t}{t}{r}{i}{b}{u}{t}{e}             return ATTRIBUTE;

{i}{d}{e}{n}{t}{i}{f}{i}{e}{r}{s}       return IDENTIFIERS;

{c}{a}{c}{h}{e}{s}{i}{z}{e}             return CACHESIZE;

{m}{a}{x}{m}{e}{m}                      return MAXMEM;

{m}{a}{x}{f}{i}{l}{e}{s}                return MAXFILES;

{f}{o}{r}{m}{a}{t}                      return FORMAT;

{d}{a}{t}{e}{f}{o}{r}{m}{a}{t}          return DATEFORMAT;

{s}{e}{p}{a}{r}{a}{t}{o}{r}{s}          return SEPARATORS;

{e}{x}{c}{l}{u}{d}{e}{w}{o}{r}{d}{s}    return EXCLUDEWORDS;

{e}{x}{c}{l}{u}{d}{e}                   return EXCLUDE;

{c}{o}{n}{d}{e}{n}{s}{e}{d}             return CONDENSED;

{i}{n}{d}{e}{x}{i}{n}{g}                return INDEXING;

{l}{a}{r}{g}{e}                         return LARGE;

{d}{a}{t}{a}{b}{a}{s}{e}                return DATABASE;

{o}{p}{t}{i}{m}{i}{z}{a}{t}{i}{o}{n}{s} return OPTIMIZATIONS;


[a-zA-Z][a-zA-Z0-9\_\-]* 	{
					yylvalp->String = Malloc((size_t)yyleng+1);
					strcpy(yylvalp->String, yytext);
					return STRING;
				}


\"\"				{
					yylvalp->String = Malloc(1);
					yylvalp->String[0] = '\0';
					return CSTRING;
				}

\"				{
                                        char	*Buf;
					int	i, Index;
                                        size_t  bufsiz;
					
					Buf = Malloc(BUFSIZ);
					bufsiz = BUFSIZ;
					Index = 0;
RestartDoubleQuote:
					while ((i=input()) != '"') {
					    if (i == EOF) {
						REJECT;
					    } else {
						if (Index >= bufsiz-3)
						    Buf = Realloc(Buf, bufsiz+=BUFSIZ);
						Buf[Index] = i;
						Index++;
					    }
					}
					Buf[Index] = '\0';
					if (Index != 0 && Buf[Index-1] == '\\') {
					    Buf[Index-1] = '"';
					    goto RestartDoubleQuote;
					}
					Buf = Realloc(Buf, (size_t)Index+1);
					yylvalp->String = Buf;
					return CSTRING;
				}

[0-9]+                          {
                                        yylvalp->Integer = atoi(yytext);
					return INTEGER;
				}

\#.*				/* comments */ ;
"("				return LPAREN;
")"				return RPAREN;
"*"				return ASTERISK;
","				return COMMA;
"\""				return DOUBLEQUOTE;
"'"				return SINGLEQUOTE;
"="				return EQUALS;
\n				LineNumber++;
[\ \t\b\r;]+			;

%%

void Qddb_ResetSchemaLex()
{
    LineNumber = 1;
    yy_init = 1;		/* whether we need to initialize */
    yy_start = 0;		/* start state number */
    yyin = yyout = (FILE *)NULL;
    if (yy_current_buffer)
        YY_FLUSH_BUFFER;
}

/* yywrap() - Flex define of yywrap() = 1 is overridden here.  
 */
int yywrap()
{
    LineNumber = 1;
    return 1;
}

/* end of file SchemaLex.l */

#undef yyunput
#undef yy_push_state
#undef yy_pop_state
#undef yy_top_state
