
/* qddb/Lib/LibQddb/MakeKeys.c
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void Qddb_MakeKeys(schema)
    Schema	*schema;	
{
    char	*RelationFN = schema->RelationName;
    char	KeyFN[MAXFILENAMELEN];
    int		RfileFile, KeyFile;
    FILE	*KeyFD;
    int		i, ActuallyRead, First, base;
    off_t	Start, FilePosition;
    size_t      Length;
    char	Buffer[BUFSIZ+2], *start_ch, *length_ch;
    enum {
	NEWLINE,
	ESCAPED,
	NONE
    }		State;

    RfileFile = schema->database_fd;
    lseek(RfileFile, (off_t)0, 0);
    strcpy(KeyFN, RelationFN);
    strcat(KeyFN, "/Database.key");
    KeyFile = Open(KeyFN, O_WRONLY|O_CREAT|O_TRUNC, 0666);
    KeyFD   = fdopen(KeyFile, "w");
    First = 1;
    Start = 0;
    Length = 0;
    FilePosition = 0;
    State = NONE;
    if (schema->UseCondensedIndexing == False) {
	base = 10;
    } else {
	base = 62;
    }
    while ((ActuallyRead=read(RfileFile, Buffer, BUFSIZ)) > 0) {
	Buffer[ActuallyRead] = '\n';
	for (i = 0; i < ActuallyRead; i++, FilePosition++) {
	    if (First && Buffer[i] == '%') {
		State = NONE;
		Start = FilePosition;
		First = 0;
	    } else if (Start >= 0 && Buffer[i] == '\n') {
		if (State == NEWLINE) {
		    /* Length doesn't include the ending
		     * newline.
		     */
		    Length = FilePosition - Start + 1;
		    start_ch = Qddb_OffsetToBase(Start, base);
		    length_ch = Qddb_SizeToBase(Length, base);
		    fprintf(KeyFD, "%s %s\n", start_ch, length_ch);
		    First = 1;
		    Start = 0;
		    State = NONE;
		} else if (State == ESCAPED)
		    State = NONE;
		else
		    State = NEWLINE;
	    } else if (Buffer[i] == '\\') {
		if (State != ESCAPED)
		    State = ESCAPED;
		else
		    State = NONE;
	    } else {
		State = NONE;
	    }
	}	
    }
    fclose(KeyFD);
}
